/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WebField;

public class WProcess
extends HttpServlet {
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        if (wsc == null) {
            WebUtil.createTimeoutPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null);
            return;
        }
        WebDoc doc = null;
        int AD_Menu_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"AD_Menu_ID");
        if (AD_Menu_ID > 0) {
            this.log.info("doGet - AD_Menu_ID=" + AD_Menu_ID);
            doc = this.createParameterPage(wsc, AD_Menu_ID);
        } else {
            String fileName = WebUtil.getParameter((HttpServletRequest)request, (String)"File");
            int AD_PInstance_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"AD_PInstance_ID");
            this.log.info("doGet - AD_PInstance_ID=" + AD_PInstance_ID + ", File=" + fileName);
            String error = this.streamResult(request, response, AD_PInstance_ID, fileName);
            if (error == null) {
                return;
            }
            doc = WebDoc.createWindow((String)error);
        }
        if (doc == null) {
            doc = WebDoc.createWindow((String)"Process Not Found");
        }
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)true);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        if (wsc == null) {
            WebUtil.createTimeoutPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null);
            return;
        }
        int AD_Process_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"AD_Process_ID");
        this.log.info("doGet - AD_Process_ID=" + AD_Process_ID);
        if (AD_Process_ID == 0) {
            WebUtil.createErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (String)"No Process");
            return;
        }
        WebDoc doc = this.createProcessPage(request, AD_Process_ID);
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
    }

    private WebDoc createParameterPage(WebSessionCtx wsc, int AD_Menu_ID) {
        MProcess process = MProcess.getFromMenu((Ctx)wsc.ctx, (int)AD_Menu_ID);
        if (process == null) {
            WebDoc doc = WebDoc.createWindow((String)"Process Not Found");
            return doc;
        }
        WebDoc doc = WebDoc.createWindow((String)process.getName());
        td center = doc.addWindowCenter(false);
        if (process.getDescription() != null) {
            center.addElement((Element)new p((Element)new i(process.getDescription())));
        }
        if (process.getHelp() != null) {
            center.addElement((Element)new p(process.getHelp(), "left"));
        }
        form myForm = new form("WProcess").setName("process" + process.getAD_Process_ID());
        myForm.setOnSubmit("this.Submit.disabled=true;return true;");
        myForm.addElement((Element)new input("hidden", "AD_Process_ID", process.getAD_Process_ID()));
        table myTable = new table("0", "0", "5", "100%", null);
        myTable.setID("WProcessParameter");
        MProcessPara[] parameter = process.getParameters();
        for (int i2 = 0; i2 < parameter.length; ++i2) {
            MProcessPara para = parameter[i2];
            WebField wField = new WebField(wsc, para.getColumnName(), para.getName(), para.getDescription(), para.getAD_Reference_ID(), para.getFieldLength(), para.getFieldLength(), false, false, para.isMandatory(), false, false, false);
            td toField = para.isRange() ? wField.getField(para.getLookup(), para.getDefaultValue2()) : new td(WebEnv.NBSP);
            myTable.addElement((Element)new tr().addElement((Element)wField.getLabel()).addElement((Element)wField.getField(para.getLookup(), para.getDefaultValue())).addElement((Element)toField));
        }
        myTable.addElement((Element)new tr().addElement((Element)new td(null, "left", "middle", false, (Element)new input("reset", "Reset", "Reset"))).addElement((Element)new td(null, "left", "middle", false, null)).addElement((Element)new td(null, "right", "middle", false, (Element)new input("submit", "Submit", "Submit"))));
        myForm.addElement((Element)myTable);
        center.addElement((Element)myForm);
        return doc;
    }

    private WebDoc createProcessPage(HttpServletRequest request, int AD_Process_ID) {
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        MProcess process = MProcess.get((Ctx)wsc.ctx, (int)AD_Process_ID);
        if (process == null) {
            WebDoc doc = WebDoc.createWindow((String)"Process Not Found");
            return doc;
        }
        WebDoc doc = WebDoc.createWindow((String)process.getName());
        td center = doc.addWindowCenter(false);
        if (process.getDescription() != null) {
            center.addElement((Element)new p((Element)new i(process.getDescription())));
        }
        if (process.getHelp() != null) {
            center.addElement((Element)new p(process.getHelp(), "left"));
        }
        MPInstance pInstance = this.fillParameter(request, process);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        pi.setAD_User_ID(wsc.ctx.getAD_User_ID());
        pi.setAD_Client_ID(wsc.ctx.getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        p p2 = new p();
        p2.addElement(Msg.translate((Ctx)wsc.ctx, (String)"AD_PInstance_ID") + ": " + pInstance.getAD_PInstance_ID());
        center.addElement((Element)p2);
        boolean processOK = false;
        if (process.isJavaProcess()) {
            Trx trx = Trx.get((String)Trx.createTrxName((String)"WebPrc"), (boolean)true);
            try {
                processOK = process.processIt(pi, trx);
                trx.commit();
                trx.close();
            }
            catch (Throwable t) {
                trx.rollback();
                trx.close();
            }
            if (!processOK || pi.isError()) {
                center.addElement(new p("Error:" + pi.getSummary(), "left").setClass("Cerror"));
                processOK = false;
            }
            center.addElement((Element)new p().addElement(pi.getSummary()));
            center.addElement(pi.getLogInfo(true));
        }
        if (processOK && process.isReport()) {
            ReportEngine re = ReportEngine.get((Ctx)wsc.ctx, (ProcessInfo)pi);
            if (re == null) {
                center.addElement(new p("Could not start ReportEngine", "left").setClass("Cerror"));
            } else {
                try {
                    File file = File.createTempFile("WProcess", ".pdf");
                    boolean ok = re.createPDF(file);
                    if (ok) {
                        String url = "WProcess?AD_PInstance_ID=" + pInstance.getAD_PInstance_ID() + "&File=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8");
                        a link2 = new a(url, null, "_blank", process.getName());
                        center.addElement((Element)new p().addElement("Report created: ").addElement((Element)link2));
                        wsc.ctx.put((Object)("AD_PInstance_ID=" + pInstance.getAD_PInstance_ID()), (Object)"ok");
                    } else {
                        center.addElement(new p("Could not create Report", "left").setClass("Cerror"));
                    }
                }
                catch (Exception e) {
                    center.addElement(new p("Could not create Report:", "left").setClass("Cerror"));
                    center.addElement(e.toString());
                }
            }
        }
        return doc;
    }

    private MPInstance fillParameter(HttpServletRequest request, MProcess process) {
        MPInstance pInstance = new MPInstance(process, 0);
        MPInstancePara[] iParams = pInstance.getParameters();
        for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            String key = iPara.getParameterName();
            MProcessPara pPara = process.getParameter(key);
            if (pPara == null) {
                this.log.log(Level.SEVERE, "Parameter not found: " + key);
                continue;
            }
            String valueString = WebUtil.getParameter((HttpServletRequest)request, (String)key);
            this.log.fine("fillParameter - " + key + " = " + valueString);
            String value = valueString;
            if (valueString != null && valueString.length() == 0) {
                value = null;
            }
            if (value == null) continue;
            try {
                if (DisplayType.isNumeric((int)pPara.getAD_Reference_ID()) || DisplayType.isID((int)pPara.getAD_Reference_ID())) {
                    BigDecimal bd = null;
                    bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                    iPara.setP_Number(bd);
                    this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + bd + "=)");
                } else if (DisplayType.isDate((int)pPara.getAD_Reference_ID())) {
                    Timestamp ts = null;
                    ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                    iPara.setP_Date(ts);
                    this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + ts + "=)");
                } else {
                    iPara.setP_String(value.toString());
                }
                iPara.save();
                continue;
            }
            catch (Exception e) {
                this.log.warning("fillParameter - " + key + " = " + valueString + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
            }
        }
        return pInstance;
    }

    private String streamResult(HttpServletRequest request, HttpServletResponse response, int AD_PInstance_ID, String fileName) {
        if (AD_PInstance_ID == 0) {
            return "Your process not found";
        }
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        Object value = wsc.ctx.get((Object)("AD_PInstance_ID=" + AD_PInstance_ID));
        if (value == null || !value.equals("ok")) {
            return "Process Instance not found";
        }
        if (fileName == null || fileName.length() == 0) {
            return "No Process Result";
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return "Process Result not found: " + file;
        }
        return WebUtil.streamFile((HttpServletResponse)response, (File)file);
    }
}

