/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanInfoUtil
extends SimpleBeanInfo {
    private static Log log = LogFactory.getLog(BeanInfoUtil.class);

    public final PropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> pdArray = new ArrayList<PropertyDescriptor>();
        String className = this.getClass().getName();
        className = className.substring(0, className.indexOf("BeanInfo"));
        Class<?> tagClass = null;
        try {
            tagClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex1) {
            log.error((Object)("class not found: " + className));
        }
        for (Method meth : tagClass.getMethods()) {
            String methodName;
            if (meth.getParameterTypes().length != 1 || (methodName = meth.getName()).indexOf("set") != 0 || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3))) continue;
            String attributeName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            try {
                pdArray.add(new PropertyDescriptor(attributeName, null, meth));
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
        }
        PropertyDescriptor[] pd = new PropertyDescriptor[pdArray.size()];
        Iterator iterator = pdArray.iterator();
        int pdCount = 0;
        while (iterator.hasNext()) {
            pd[pdCount] = (PropertyDescriptor)iterator.next();
            ++pdCount;
        }
        return pd;
    }
}

