/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.ajax.AjaxJavascriptParts;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.font;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WLogin
extends HttpServlet {
    private static final long serialVersionUID = -2475317452678336560L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String P_USERNAME = "User";
    private static final String P_PASSWORD = "Password";
    private static final String P_SUBMIT = "Submit";
    public static final String P_ROLE = "AD_Role_ID";
    public static final String P_CLIENT = "AD_Client_ID";
    public static final String P_ORG = "AD_Org_ID";
    public static final String P_DATE = "Date";
    public static final String P_WAREHOUSE = "M_Warehouse_ID";
    protected static final String P_ERRORMSG = "ErrorMessage";
    protected static final String P_STORE = "SaveCookie";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("WLogin.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Login";
    }

    public void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
        HttpSession sess = request.getSession(true);
        sess.setMaxInactiveInterval(900);
        Properties cProp = AWebUtil.getCookieProprties(request);
        WebSessionCtx wsc = WebSessionCtx.create((HttpServletRequest)request);
        WebDoc doc = null;
        if (!DB.isConnected()) {
            String msg = Msg.getMsg((Ctx)wsc.ctx, (String)"WLoginNoDB");
            if (msg.equals("WLoginNoDB")) {
                msg = "No Database Connection";
            }
            doc = WebDoc.createWindow((String)msg);
        } else {
            String usr = WebUtil.getParameter((HttpServletRequest)request, (String)P_USERNAME);
            String pwd = WebUtil.getParameter((HttpServletRequest)request, (String)P_PASSWORD);
            Principal userPrincipal = request.getUserPrincipal();
            this.log.info("Principal=" + userPrincipal + "; User=" + usr);
            if (userPrincipal == null && (usr == null || pwd == null)) {
                doc = this.createFirstPage(cProp, request, "");
            } else {
                KeyNamePair[] roles = null;
                Login login = new Login(wsc.ctx);
                if (userPrincipal != null) {
                    roles = login.getRoles(userPrincipal);
                    usr = userPrincipal.getName();
                } else {
                    roles = login.getRoles(usr, pwd);
                }
                if (roles == null) {
                    doc = this.createFirstPage(cProp, request, Msg.getMsg((Ctx)wsc.ctx, (String)"UserPwdError"));
                } else {
                    doc = this.createSecondPage(request, WebUtil.convertToOption((NamePair[])roles, null), "");
                    wsc.ctx.setContext("#AD_Language", WebUtil.getParameter((HttpServletRequest)request, (String)"#AD_Language"));
                    MSession.get((Ctx)wsc.ctx, (String)request.getRemoteAddr(), (String)request.getRemoteHost(), (String)sess.getId());
                }
                if (WebUtil.getParameter((HttpServletRequest)request, (String)P_STORE) == null) {
                    cProp.clear();
                } else {
                    cProp.setProperty(P_USERNAME, usr);
                    cProp.setProperty(P_STORE, "Y");
                    cProp.setProperty(P_PASSWORD, pwd);
                    cProp.setProperty("#AD_Language", WebUtil.getParameter((HttpServletRequest)request, (String)"#AD_Language"));
                }
            }
        }
        AWebUtil.writeDebugLog("main", doc.toString());
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, (Properties)cProp, (WebDoc)doc, (boolean)true);
    }

    private WebDoc createFirstPage(Properties cProp, HttpServletRequest request, String errorMessage) {
        this.log.info("createFirstPage - " + errorMessage);
        String AD_Language = cProp.getProperty("#AD_Language", Language.getAD_Language((Locale)request.getLocale()));
        String windowTitle = Msg.getMsg((String)AD_Language, (String)"Login");
        String usrText = Msg.getMsg((String)AD_Language, (String)P_USERNAME);
        String pwdText = Msg.getMsg((String)AD_Language, (String)P_PASSWORD);
        String lngText = Msg.translate((String)AD_Language, (String)"AD_Language");
        String okText = "OK";
        String cancelText = "\u30ad\u30e3\u30f3\u30bb\u30eb";
        String storeTxt = Msg.getMsg((String)AD_Language, (String)P_STORE);
        String action = request.getRequestURI();
        form myForm = null;
        myForm = new form(action).setName("Login1");
        myForm.setName("Login1");
        table table2 = new table().setAlign("center");
        div divBody = (div)new div().setID("body");
        div divLoginBox = (div)new div().setID("login-box");
        divBody.addElement((Element)divLoginBox);
        div divInner = (div)new div().setClass("inner");
        divLoginBox.addElement((Element)divInner);
        divInner.addElement((Element)myForm);
        String userData = cProp.getProperty(P_USERNAME, "");
        tr line = new tr();
        label usrLabel = new label().setFor("UserF").addElement(usrText);
        usrLabel.setID("UserL");
        line.addElement((Element)new td().addElement((Element)usrLabel).setAlign("right"));
        input usr = new input("text", P_USERNAME, userData);
        usr.setID("UserF");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)usr).setAlign("left"));
        table2.addElement((Element)line);
        String pwdData = cProp.getProperty(P_PASSWORD, "");
        table2.addElement((Element)line);
        line = new tr();
        label pwdLabel = new label().setFor("PasswordF").addElement(pwdText);
        pwdLabel.setID("PasswordL");
        line.addElement((Element)new td().addElement((Element)pwdLabel).setAlign("right"));
        input pwd = new input("password", P_PASSWORD, pwdData);
        pwd.setID("PasswordF");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)pwd).setAlign("left"));
        table2.addElement((Element)line);
        table2.addElement((Element)line);
        line = new tr();
        label langLabel = new label().setFor("#AD_Language".substring(1) + "F").addElement(lngText);
        langLabel.setID("#AD_Language".substring(1) + "L");
        line.addElement((Element)new td().addElement((Element)langLabel).setAlign("right"));
        option[] options = new option[Language.getLanguageCount()];
        for (int i = 0; i < Language.getLanguageCount(); ++i) {
            Language language = Language.getLanguage((int)i);
            options[i] = new option(language.getAD_Language()).addElement(AmpiereUtil.maskHTML(language.getName()));
            if (language.getAD_Language().equals(AD_Language)) {
                options[i].setSelected(true);
                continue;
            }
            options[i].setSelected(false);
        }
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement(new select("#AD_Language", options).setID("#AD_Language".substring(1) + "F")));
        table2.addElement((Element)line);
        String storeData = cProp.getProperty(P_STORE, "N");
        line = new tr();
        input store = new input("checkbox", P_STORE, "Y").addElement(storeTxt).setChecked(storeData.equals("Y"));
        store.setID("SaveCookieF");
        line.addElement((Element)new td().addElement((Element)store).setAlign("left"));
        table2.addElement((Element)line);
        if (errorMessage != null && errorMessage.length() > 0) {
            line = new tr();
            line.addElement((Element)new td().setColSpan(2).addElement((Element)new font("#FF0000", 4).addElement((Element)new b(errorMessage))));
            table2.addElement((Element)line);
        }
        table2.addElement((Element)line);
        line = new tr();
        div divButtonBox = (div)new div().setClass("button-box");
        input ok = new input("submit", P_SUBMIT, okText);
        ok.setID("btn_submit");
        divButtonBox.addElement((Element)ok);
        input cancel = new input("reset", "Reset", cancelText);
        cancel.setID("btn_reset");
        divButtonBox.addElement((Element)cancel);
        line.addElement((Element)new td().addElement((Element)divButtonBox));
        table2.addElement((Element)line);
        myForm.addElement((Element)table2);
        request.setAttribute("SECOND_DIV_ID", (Object)"login");
        WebDoc doc = WebDoc.createWindow((String)windowTitle, (HttpServletRequest)request);
        doc.addWindowCenter(true).addElement((Element)divBody);
        doc.getBody().addElement((Element)WebUtil.getClearFrame((String)"WMenu")).setTitle(windowTitle);
        return doc;
    }

    private WebDoc createSecondPage(HttpServletRequest request, option[] roleOptions, String errorMessage) {
        this.log.info("createSecondPage - " + errorMessage);
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        String windowTitle = "\u8077\u8cac\u9078\u629e";
        request.setAttribute("SECOND_DIV_ID", (Object)"login");
        WebDoc doc = WebDoc.createWindow((String)windowTitle, (HttpServletRequest)request);
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        String action = WebEnv.getBaseDirectory((String)"WMenu");
        form myForm = null;
        myForm = new form(action).setName("Login2");
        myForm.setTarget("WMenu");
        table table2 = new table().setAlign("center");
        div divBody = (div)new div().setID("body");
        div divLoginBox = (div)new div().setID("login-box");
        divBody.addElement((Element)divLoginBox);
        div divInner = (div)new div().setClass("inner");
        divLoginBox.addElement((Element)divInner);
        divInner.addElement((Element)myForm);
        tr line = new tr();
        label roleLabel = new label().setFor("AD_Role_IDF").addElement(Msg.translate((Language)wsc.language, (String)P_ROLE));
        roleLabel.setID("AD_Role_IDL");
        line.addElement((Element)new td().addElement((Element)roleLabel).setAlign("right").setWidth(220));
        select role = new select(P_ROLE, roleOptions);
        role.setClass("w240");
        role.setID("AD_Role_IDF");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)role));
        table2.addElement((Element)line);
        table2.setWidth(500);
        StringBuffer sbRoleAjaxScript = new StringBuffer().append(AjaxJavascriptParts.makeAjaxAmpiereMutiUpdate(WebEnv.getBaseDirectory((String)"WLoginAjaxAction.do"), "AD_Role_IDF", null, true, null, null, "role", null, null));
        line = new tr();
        label clientLabel = new label().setFor("AD_Client_IDF").addElement(Msg.translate((Language)wsc.language, (String)P_CLIENT));
        clientLabel.setID("AD_Client_IDL");
        line.addElement((Element)new td().addElement((Element)clientLabel).setAlign("right"));
        select client = new select(P_CLIENT);
        client.setID("AD_Client_IDF");
        client.setClass("w240");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)client));
        table2.addElement((Element)line);
        StringBuffer sbClientAjaxScript = new StringBuffer().append(AjaxJavascriptParts.makeAjaxAmpiereMutiUpdate(WebEnv.getBaseDirectory((String)"WLoginAjaxAction.do"), "AD_Client_IDF", null, true, null, null, "client", null, null));
        line = new tr();
        label orgLabel = new label().setFor("AD_Org_IDF").addElement(Msg.translate((Language)wsc.language, (String)P_ORG));
        orgLabel.setID("AD_Org_IDL");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)orgLabel).setAlign("right"));
        select org = new select(P_ORG);
        org.setID("AD_Org_IDF");
        org.setClass("w240");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)org));
        table2.addElement((Element)line);
        StringBuffer sbOrgAjaxScript = new StringBuffer().append(AjaxJavascriptParts.makeAjaxAmpiereMutiUpdate(WebEnv.getBaseDirectory((String)"WLoginAjaxAction.do"), "AD_Org_IDF", null, true, null, null, "org", null, null));
        line = new tr();
        label whLabel = new label().setFor("M_Warehouse_IDF").addElement(Msg.translate((Language)wsc.language, (String)P_WAREHOUSE));
        whLabel.setID("M_Warehouse_IDL");
        line.addElement((Element)new td().addElement((Element)whLabel).setAlign("right"));
        select wh = new select(P_WAREHOUSE);
        wh.setID("M_Warehouse_IDF");
        wh.setClass("w240");
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)wh));
        table2.addElement((Element)line);
        String dateData = wsc.dateFormat.format(new Date());
        line = new tr();
        label dateLabel = new label().setFor("DateF").addElement(Msg.getMsg((Language)wsc.language, (String)P_DATE));
        dateLabel.setID("DateL");
        line.addElement((Element)new td().addElement((Element)dateLabel).setAlign("right"));
        input date = new input("text", P_DATE, dateData);
        date.setID("DateF");
        date.setOnChange("checkDateValidation(this, paraInvalidDateMsg);");
        String png = "Calendar16.png";
        img button2 = new img(WebEnv.getImageDirectory((String)png), "DateP");
        button2.setID("DateP");
        button2.setClass("popupButton");
        div dateTimePickerScriptDiv = new div();
        String inputBoxId = "DateF";
        String buttonId = "DateP";
        AmpiereUtil.addDatePickerScript((Element)dateTimePickerScriptDiv, inputBoxId, buttonId);
        date.addElement((Element)button2);
        date.addElement((Element)dateTimePickerScriptDiv);
        table2.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement((Element)date).setAlign("left"));
        table2.addElement((Element)line);
        if (errorMessage != null && errorMessage.length() > 0) {
            line = new tr();
            line.addElement((Element)new td().addElement((Element)new strong(errorMessage)).setColSpan(2).setAlign("center"));
            table2.addElement((Element)line);
        }
        line = new tr();
        div divButtonBox = (div)new div().setClass("button-box");
        input submit = new input("submit", P_SUBMIT, "OK");
        submit.setOnClick("showLoadingMenu('" + WebEnv.getBaseDirectory((String)"") + "');");
        submit.setID("btn_submit");
        divButtonBox.addElement((Element)submit);
        input cancel = new input("reset", "Reset", "\u30ad\u30e3\u30f3\u30bb\u30eb");
        divButtonBox.addElement((Element)cancel);
        cancel.setID("btn_reset");
        line.addElement((Element)new td().addElement((Element)divButtonBox));
        table2.addElement((Element)line);
        myForm.addElement((Element)table2);
        AjaxJavascriptParts.addAjaxHeader(doc.getHead(), false, false);
        doc.addWindowCenter(true).addElement((Element)divBody);
        String scriptGlobalProgress = AjaxJavascriptParts.makeAjaxProgressScript(WebEnv.PROGRESS_ID);
        String script2 = "$('AD_Role_IDF').onchange();";
        body bdy = doc.getBody();
        bdy.addElement((Element)new script(sbRoleAjaxScript.toString()));
        bdy.addElement((Element)new script(sbClientAjaxScript.toString()));
        bdy.addElement((Element)new script(sbOrgAjaxScript.toString()));
        bdy.addElement((Element)new script(scriptGlobalProgress));
        bdy.addElement((Element)new script(script2));
        doc.addWindowFooter().addElement((Element)new p(Msg.getMsg((Language)wsc.language, (String)"WLoginBrowserNote"), "center"));
        return doc;
    }
}

