/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.GenerateInvoiceFromOrderForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class GenerateInvoiceFromOrder
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ORDER_LIST = "orderlist";
    private static final String ACTION_FORM = "GenerateInvoiceFromOrderForm";
    private static final String ERROR_FORWARD = "error";
    private static final int ORDERLINE_WAREHOUSE_COLUMN_ID = 2163;
    private static final int FORM_ID = 100;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        wsc.ctx.setContext(0, "IsSOTrx", "Y");
        MForm form2 = this.getForm(wsc.ctx, 100);
        wsc.ctx.setContext("FormName", form2.getName());
        GenerateInvoiceFromOrderForm myForm = (GenerateInvoiceFromOrderForm)request.getAttribute(ACTION_FORM);
        if (myForm == null && (myForm = (GenerateInvoiceFromOrderForm)actionForm) == null) {
            myForm = new GenerateInvoiceFromOrderForm();
        }
        myForm.setMainWindowTitle(form2.getName() + " - " + wsc.loginInfo);
        myForm.setPageTitle(form2.getName());
        myForm.setOrganizationLabel(Msg.translate((Ctx)wsc.ctx, (String)"AD_Org_ID"));
        ArrayList dataList = new ArrayList();
        MLookup lookup = MLookupFactory.get((Ctx)wsc.ctx, (int)0, (int)2163, (int)19);
        for (KeyNamePair keyName : lookup.getData(false, false, true, false)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("key", String.valueOf(keyName.getKey()));
            data.put("value", keyName.getName());
            dataList.add(data);
        }
        myForm.setOrganizationList(dataList);
        myForm.setBusinessPartnerLabel(Msg.translate((Ctx)wsc.ctx, (String)"C_BPartner_ID"));
        myForm.setOrderList(this.getOrderList(wsc, myForm.getOrganizationId(), myForm.getBusinessPartnerId()));
        myForm.setGenerateSelectMessage(Msg.getMsg((Ctx)wsc.ctx, (String)"InvGenerateSel"));
        myForm.setGenerateButtonLabel(Msg.getMsg((Ctx)wsc.ctx, (String)"Generate"));
        myForm.setCancelButtonLabel(Msg.getMsg((Ctx)wsc.ctx, (String)"Cancel"));
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return mapping.findForward(ORDER_LIST);
    }

    private ArrayList getOrderList(WebSessionCtx wsc, int organizationId, int businessPartnerId) {
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("RowType", "title");
        data.put("C_Order_ID", "");
        data.put("AD_Org_ID", Msg.translate((Ctx)wsc.ctx, (String)"AD_Org_ID"));
        data.put("C_DocType_ID", Msg.translate((Ctx)wsc.ctx, (String)"C_DocType_ID"));
        data.put("DocumentNo", Msg.translate((Ctx)wsc.ctx, (String)"DocumentNo"));
        data.put("C_BPartner_ID", Msg.translate((Ctx)wsc.ctx, (String)"C_BPartner_ID"));
        data.put("DateOrdered", Msg.translate((Ctx)wsc.ctx, (String)"DateOrdered"));
        data.put("TotalLines", Msg.translate((Ctx)wsc.ctx, (String)"TotalLines"));
        dataList.add(data);
        int clientId = wsc.ctx.getAD_Client_ID();
        StringBuffer sql = new StringBuffer("SELECT C_Order_ID, o.Name, dt.Name, DocumentNo, bp.Name, DateOrdered, TotalLines FROM C_Invoice_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (organizationId > 0) {
            sql.append(" AND ic.AD_Org_ID=").append(organizationId);
        }
        if (businessPartnerId > 0) {
            sql.append(" AND ic.C_BPartner_ID=").append(businessPartnerId);
        }
        sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        this.log.fine(sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, clientId);
            ResultSet rs = pstmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                data = new HashMap();
                if (++count % 2 == 0) {
                    data.put("RowType", "even");
                } else {
                    data.put("RowType", "odd");
                }
                data.put("C_Order_ID", rs.getInt(1));
                data.put("AD_Org_ID", rs.getString(2));
                data.put("C_DocType_ID", rs.getString(3));
                data.put("DocumentNo", rs.getString(4));
                data.put("C_BPartner_ID", rs.getString(5));
                data.put("DateOrdered", wsc.dateFormat.format(rs.getTimestamp(6)));
                data.put("TotalLines", wsc.amountFormat.format(rs.getBigDecimal(7)));
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return dataList;
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage((Ctx)ctx, (String)"AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language((Ctx)ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
        }
        return form2;
    }
}

