/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.jetspeed.portlet.AccessDeniedException;
import org.apache.jetspeed.portlet.Portlet;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletException;
import org.apache.jetspeed.portlet.PortletLog;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.PortletSession;
import org.apache.jetspeed.portlet.PortletSessionListener;
import org.apache.jetspeed.portlet.PortletSettings;
import org.apache.jetspeed.portlet.UnavailableException;

public abstract class PortletAdapter
extends Portlet
implements PortletSessionListener {
    private PortletConfig portletConfig = null;
    private Hashtable variables = new Hashtable();

    public void init(PortletConfig config) throws UnavailableException {
        this.portletConfig = config;
    }

    public void destroy(PortletConfig config) {
    }

    public void initConcrete(PortletSettings settings) throws UnavailableException {
    }

    public void destroyConcrete(PortletSettings settings) {
    }

    public void login(PortletRequest request) throws PortletException {
    }

    public void logout(PortletSession session) throws PortletException {
    }

    public long getLastModified(PortletRequest request) {
        return -1L;
    }

    public void service(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        if (request.getMode() == Portlet.Mode.VIEW) {
            this.doView(request, response);
        } else if (request.getMode() == Portlet.Mode.EDIT) {
            this.doEdit(request, response);
        } else if (request.getMode() == Portlet.Mode.HELP) {
            this.doHelp(request, response);
        } else if (request.getMode() == Portlet.Mode.CONFIGURE) {
            this.doConfigure(request, response);
        }
    }

    public void doView(PortletRequest request, PortletResponse response) throws PortletException, IOException {
    }

    public void doEdit(PortletRequest request, PortletResponse response) throws PortletException, IOException {
    }

    public void doHelp(PortletRequest request, PortletResponse response) throws PortletException, IOException {
    }

    public void doConfigure(PortletRequest request, PortletResponse response) throws PortletException, IOException {
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public PortletLog getPortletLog() {
        return this.getPortletConfig().getContext().getLog();
    }

    public void setVariable(String name, Object value) throws AccessDeniedException {
        if (this.getPortletSettings() == null) {
            throw new AccessDeniedException();
        }
        String key = this.getPortletSettings().hashCode() + name;
        this.variables.put(key, value);
    }

    public Object getVariable(String name) throws AccessDeniedException {
        if (this.getPortletSettings() == null) {
            throw new AccessDeniedException();
        }
        String key = this.getPortletSettings().hashCode() + name;
        return this.variables.get(key);
    }

    public void removeVariable(String name) throws AccessDeniedException {
        if (this.getPortletSettings() == null) {
            throw new AccessDeniedException();
        }
        String key = this.getPortletSettings().hashCode() + name;
        this.variables.remove(key);
    }
}

