/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.BasicStroke;
import java.awt.Paint;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

abstract class AxisChartTestBase {
    AxisChartTestBase() {
    }

    abstract DataSeries getDataSeries() throws ChartDataException;

    static void axisChartTest(String string, AxisChartTestBase axisChartTestBase) throws ChartDataException {
        int n = 10;
        HTMLGenerator hTMLGenerator = new HTMLGenerator("./" + string + "Test.html");
        int n2 = 0;
        while (n2 < n) {
            AxisProperties axisProperties = new AxisProperties();
            TestDataGenerator.randomizeAxisProperties(axisProperties);
            axisProperties.setYAxisRoundValuesToNearest(0);
            axisProperties.setXAxisVerticalScaleFlag(TestDataGenerator.getRandomNumber(1.0) > 0.5);
            int n3 = (int)TestDataGenerator.getRandomNumber(500.0, 800.0);
            int n4 = (int)TestDataGenerator.getRandomNumber(300.0, 600.0);
            LegendProperties legendProperties = new LegendProperties();
            TestDataGenerator.randomizeLegend(legendProperties);
            ChartProperties chartProperties = new ChartProperties();
            chartProperties.setBorderStroke(new BasicStroke(1.0f));
            AxisChart axisChart = new AxisChart(axisChartTestBase.getDataSeries(), chartProperties, axisProperties, legendProperties, n3, n4);
            String string2 = "./" + string + n2 + ".jpeg";
            ChartTestDriver.exportImage(axisChart, string2);
            axisChart.toHTML(hTMLGenerator, string2);
            hTMLGenerator.addLineBreak();
            ++n2;
        }
        hTMLGenerator.saveFile();
    }

    final DataSeries createDataSeries(int n) {
        String[] stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(10.0), false);
        String string = TestDataGenerator.getRandomString(15, true);
        String string2 = TestDataGenerator.getRandomString(15, true);
        return new DataSeries(stringArray, string, string2, "This is a test title that is so freaking long is is going to wrap around the image for sure. lfksjg;ljs; dflgkjdfgsdgdg dsgdsgsdfg dsfgsdfgsdfgs dfgdsfgd");
    }

    final AxisChartDataSet createAxisChartDataSet(ChartType chartType, ChartTypeProperties chartTypeProperties, int n, int n2, int n3, int n4) throws ChartDataException {
        double[][] dArray = TestDataGenerator.getRandomNumbers(n, n2, n3, n4);
        String[] stringArray = TestDataGenerator.getRandomStrings(n, 10, false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        return new AxisChartDataSet(dArray, stringArray, paintArray, chartType, chartTypeProperties);
    }
}

