/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.search;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

import org.apache.ecs.AlignType;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

/**
 *	Asset Information
 *	
 *  @author Jorg Janke
 *  @version $Id: InfoAsset.java,v 1.1 2010/01/13 11:52:01 clmg Exp $
 */
public class InfoAsset extends Info
{
	private Info_Column[] s_assetLayout = null;

	/**
	 *	Standard Constructor

	 * @param frame frame
	 * @param modal modal
	 * @param WindowNo window no
	 * @param A_Asset_ID asset
	 * @param value    Query Value or Name if enclosed in @
	 * @param multiSelection multiple selections
	 * @param whereClause where clause
	 */
	public InfoAsset (int WindowNo, int A_Asset_ID, String value, boolean multiSelection, String whereClause, Ctx ctx)
	{
		super (WindowNo, "a", "A_Asset_ID", multiSelection, whereClause, ctx);

		log.info(value + ", ID=" + A_Asset_ID + ", WHERE=" + whereClause);
		title = Msg.translate(ctx, "InfoAsset");

		/**  Array of Column Info    */
		int i = 0;
		s_assetLayout = new Info_Column [9];
		columnAttrList = new ArrayList<Integer>();
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "Select"), "a.A_Asset_ID", IDColumn.class);
		columnAttrList.add(1);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "Value"), "a.Value", String.class);
		columnAttrList.add(1);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "Name"), "a.Name", String.class);
		columnAttrList.add(1);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "M_Product_ID"), "p.Name", String.class);
		columnAttrList.add(1);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "C_BPartner_ID"), "bp.Name",  String.class);
		columnAttrList.add(1);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "AD_User_ID"), "u.Name", String.class);
		columnAttrList.add(1);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "AssetServiceDate"), "a.AssetServiceDate", Timestamp.class);
		columnAttrList.add(0);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "GuaranteeDate"), "a.GuaranteeDate", Timestamp.class);
		columnAttrList.add(0);
		s_assetLayout[i++] = new Info_Column(Msg.translate(ctx, "VersionNo"), "a.VersionNo", String.class);
		columnAttrList.add(0);

		m_keyColumnIndex = 0;

		//
		statInit(ctx);
		initInfo();

		p_loadedOK = true;
	}	//	InfoProduct

	/** From Clause             */
	private static String s_assetFROM = "A_ASSET a"
		+ " LEFT OUTER JOIN M_Product p ON (a.M_Product_ID=p.M_Product_ID)"
		+ " LEFT OUTER JOIN C_BPartner bp ON (a.C_BPartner_ID=bp.C_BPartner_ID)"
		+ " LEFT OUTER JOIN AD_User u ON (a.AD_User_ID=u.AD_User_ID)";
	
	/**
	 *	Static Setup - add fields to parameterPanel
	 */
	private void statInit(Ctx ctx)
	{
		componentList.add(new ComponentBean(Msg.translate(ctx, "Value"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("Value", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_TEXT, "", AlignType.LEFT, AlignType.MIDDLE, "", 220));

		//	From A_Asset.
//		fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get (ctx, p_WindowNo, 0, 8065, DisplayType.Search));
		componentList.add(new ComponentBean(Msg.translate(ctx, "BPartner"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("C_BPartner_ID", new Integer(componentList.size()));
		componentList.add(new ComponentBean("C_BPartner_ID", ComponentBean.TYPE_LOOKUP, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));

		componentList.add(new ComponentBean(ComponentBean.TYPE_BR));

		componentList.add(new ComponentBean(Msg.translate(ctx, "Name"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("Name", new Integer(componentList.size()));
		componentList.add(new ComponentBean("", ComponentBean.TYPE_TEXT, "", AlignType.LEFT, AlignType.MIDDLE, "", 220));

//		fProduct_ID = new VLookup("M_Product_ID", false, false, true, MLookupFactory.get (ctx, p_WindowNo, 0, 8047, DisplayType.Search));
		componentList.add(new ComponentBean(Msg.translate(ctx, "Product"), ComponentBean.TYPE_LABEL, "", AlignType.RIGHT, AlignType.MIDDLE, "", 0));
		componentMapping.put("M_Product_ID", new Integer(componentList.size()));
		componentList.add(new ComponentBean("M_Product_ID", ComponentBean.TYPE_LOOKUP, "", AlignType.LEFT, AlignType.MIDDLE, "", 198));
	}	//	statInit

	/**
	 *	Dynamic Init
	 *  @param value value
	 *  @param whereClause where clause
	 */
	private void initInfo ()
	{
		//	Create Grid
		StringBuffer where = new StringBuffer();
		where.append("a.IsActive='Y'");
		if (p_whereClause != null && p_whereClause.length() > 0)
			where.append(" AND ").append(p_whereClause);
		//
		prepareTable(s_assetLayout, s_assetFROM,
			where.toString(),
			"a.Value");
	}	//	initInfo

	/**
	 *	Construct SQL Where Clause and define parameters.
	 *  (setParameters needs to set parameters)
	 *  Includes first AND
	 *  @return sql
	 */
	protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
		StringBuffer sql = new StringBuffer();

		// Value
		String s = getComponetValue(valueMapping, "Value");
		if (s != null)
		{
			s = s.toUpperCase();
			if (! s.endsWith("%"))
				s += "%";
			sql.append(" AND UPPER(a.Value) LIKE ");
			sql.append(DB.TO_STRING(s));
		}

		// Name
		s = getComponetValue(valueMapping, "Value");
		if (s != null)
		{
			s = s.toUpperCase();
			if (! s.endsWith("%"))
				s += "%";
			sql.append (" AND UPPER(a.Name) LIKE ");
			sql.append(DB.TO_STRING(s));
		}

		// Business Partner
		s = getComponetValue(valueMapping, "C_BPartner_ID");
		if (s != null)
		{
			sql.append (" AND a.C_BPartner_ID=");
			sql.append(Integer.parseInt(s));
		}

		// Product
		s = getComponetValue(valueMapping, "M_Product_ID");
		if (s != null)
		{
			sql.append (" AND a.C_BPartner_ID=");
			sql.append(Integer.parseInt(s));
		}

		return sql.toString();
	}

	/**
	 *  Set Parameters for Query
	 *  (as defined in getSQLWhere)
	 *
	 * @param pstmt pstmt
	 *  @param forCount for counting records
	 * @throws SQLException
	 */
	protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException
	{
	}	//	setParameters

	/**************************************************************************
	 *  Get dynamic WHERE part of SQL
	 *	To be overwritten by concrete classes
	 *  @return WHERE clause
	 */
	protected String getSQLWhere() {
		if (p_sqlWhere != null && p_sqlWhere.length() > 0) {
			return p_sqlWhere;
		}
		return "";
	}
}	//	InfoAsset
