package com.ampiere.util.ajax;

import org.apache.ecs.Element;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.compiere.util.WebEnv;

/**
 * 
 * @author bato
 * @version $Id: AjaxJavascriptParts.java,v 1.1 2010/01/13 11:52:48 clmg Exp $
 */
public class AjaxJavascriptParts {
	/**
	 * 	Add Ajax Header js and css
	 * @return all header
	 * @param includeDisplaytagCSS include Displaytag CSS or not
	 * @param includeAjaxtagsCSS include Ajaxtags CSS or not
	 * @author bato
	 */
	public static head addAjaxHeader(head m_head, boolean includeDisplaytagCSS, boolean includeAjaxtagsCSS)
	{
		if (m_head == null)
			return null;

		String baseDir = WebEnv.getBaseDirectory("");
		//<script type="text/javascript" src="/compiere/ajax/js/prototype-1.4.0.js"></script>
		m_head.addElement(new script((Element)null, baseDir+"ajax/js/prototype-1.4.0.js"));
		//<script type="text/javascript" src="/compiere/ajax/js/scriptaculous.js"></script>
		m_head.addElement(new script((Element)null, baseDir+"ajax/js/scriptaculous.js"));
		//<script type="text/javascript" src="/compiere/ajax/js/overlibmws.js"></script>
		m_head.addElement(new script((Element)null, baseDir+"ajax/js/overlibmws.js"));
		//<script type="text/javascript" src="/compiere/ajax/js/ajaxtags-1.2-beta1.js"></script>
		m_head.addElement(new script((Element)null, baseDir+"ajax/js/ajaxtags-1.2-beta1.js"));
		m_head.addElement(new script((Element)null, baseDir+"ajax/js/ajax4ampiere.js"));
		//<link rel="stylesheet" type="text/css" href="/compiere/ajax/css/ajaxtags.css" />
		if (includeAjaxtagsCSS)
		m_head.addElement(new link(baseDir+"ajax/css/ajaxtags.css", link.REL_STYLESHEET, link.TYPE_CSS));
		//<link rel="stylesheet" type="text/css" href="/compiere/ajax/css/displaytag.css" />
		if (includeDisplaytagCSS)
		m_head.addElement(new link(baseDir+"ajax/css/displaytag.css", link.REL_STYLESHEET, link.TYPE_CSS));

		return m_head;
	}	//	addAjaxHeader
	
	
	/**
	 * Make Ajax progress script.
	 * Ajax Header must be added.
	 * @param pID
	 * @param showProgressGIF when load data show progress GIF image.
	 * @param reportError when has no responce show error dialogue.
	 * @param pCallFrontFunc this javascript will be called before Ajax access.
	 * @param pCallAfterFunc this javascript will be called after Ajax access.
	 * @author bato
	 */
	public static String makeAjaxProgressScript(String pID)
	{
		StringBuffer sbUserFunc = new StringBuffer().append("\n")
		.append("var GlobalProgressHandlers = {").append("\n")
		.append("	onCreate: function(){").append("\n")
		.append("		Element.show('progress"+pID+"');").append("\n")
		.append("	},").append("\n")
		.append("	onComplete: function() {").append("\n")
		.append("		if(Ajax.activeRequestCount == 0){").append("\n")
		.append("			Effect.Fade('progress"+pID+"');").append("\n")
		.append("		}").append("\n")
		.append("	}").append("\n")
		.append("};").append("\n")
		.append("Ajax.Responders.register(GlobalProgressHandlers);").append("\n")
		.append("");

		return sbUserFunc.toString();
	}	//	makeAjaxProgressScript
	
	/**
	 * 
	 * @param pURL URL for Ajax Request
	 * @param pSourceID the html id.
	 * @param reportError when has no responce show error dialogue.
	 * @param pCallFrontFunc this javascript will be called before Ajax access.
	 * @param pCallAfterFunc this javascript will be called after Ajax access.
	 * @param pWebParamName web param name
	 * @param pOtherPram if you want pass some other param
	 * @param pEventType the event type
	 * @return
	 */
	public static String makeAjaxAmpiereMutiUpdate(
		String pURL, String pSourceID, String pParser,
		boolean reportError, 
		String pCallFrontFunc, String pCallAfterFunc, 
		String pWebParamName, String pOtherPram, String pEventType
	){
		StringBuffer sbAjaxScript = new StringBuffer();
		sbAjaxScript.append("new AjaxJspTag.AmpiereCallout(").append("\n")
		.append("\""+pURL+"\", {").append("\n")
		.append("parameters: \""+pWebParamName+"={" + pSourceID + "}")
		.append(pOtherPram==null ? "\"," : pOtherPram +"\",").append("\n")
		.append(pCallAfterFunc==null? "" : "postFunction: "+pCallAfterFunc+",").append("\n")
		.append(pParser==null ? "" :  "parser: new "+pParser+",").append("\n")
		//.append("target: \"" + pTargetID + "\",").append("\n") target decided by inside web application side.
		.append(pCallFrontFunc==null ? "" : "preFunction: " + pCallFrontFunc + ",").append("\n")
		.append("source: \"" + pSourceID + "\",").append("\n")
		.append(pEventType==null ? "eventType: \"change\"," : "eventType: \""+pEventType +"\"," ).append("\n")
		.append(reportError ? " errorFunction: function(){ alert('an error on get "+pSourceID+" callout.');}" : "errorFunction: function(){}").append("\n")
		.append("});");
		return sbAjaxScript.toString();		
	}
	/**
	 * make Ajax drop down select first javascript
	 * @param pURI get data from this URL
	 * @param pSourceID html source id 
	 * @param pTargetID html target id
	 * @return javascript content
	 * @author bato
	 */
	public static String makeAjaxSelect(String pURI, String pSourceID, String pTargetID) {
		StringBuffer sbAjaxScript = new StringBuffer();
		sbAjaxScript.append("new AjaxJspTag.Select(").append("\n")
		.append("\""+pURI+"\", {").append("\n")
		.append("parameters: \"p={" + pSourceID + "}\",").append("\n")
		.append("postFunction: resetProgress" + pSourceID + ",").append("\n")
		.append("parser: new ResponseXmlParser(),").append("\n")
		.append("target: \"" + pTargetID + "\",").append("\n")
		.append("preFunction: initProgress" + pSourceID + ",").append("\n")
		.append("source: \"" + pSourceID + "\",").append("\n")
		.append("eventType: \"change\",").append("\n")
		.append("errorFunction: reportError" + pSourceID).append("\n")
		.append("});");
		return sbAjaxScript.toString();
	}	//	makeAjaxSelect

}
