/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.AlignType;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.Lookup;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;


/**
 *  WAccount Servlet.
 *  <p>
 *  The servlet is invoked by a parent window via
 *  <code>
 *  WAccount?FormName=formName%ColumnName=columnName
 *  </code>
 *  and assumes that in the opening window/form there are two fields
 *  <code>
 *  opener.document.formName.columnName - The (hidden) field for the ID
 *  opener.document.formName.columnNameD - The display field for the value
 *  </code>
 *  When selecting an entry, the window is closed and the value of the two fields set.
 *
 *  @author Jorg Janke
 *  @version  $Id: WAccount.java,v 1.1 2010/01/13 11:51:47 clmg Exp $
 */
public class WAccount extends HttpServlet
{
	private static final long serialVersionUID = -6348547380305885368L;

	/**
	 * Initialize global variables
	 *
	 * @param config
	 * @throws ServletException
	 */
	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WAccount.init");
	}   //  init
	
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(WAccount.class);

	/**
	 * Process the HTTP Get request - initial Start
	 * Needs to have parameters FormName and ColumnName
	 *
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void doGet (HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException
	{
		log.config( "WAccount.doGet");
		WebSessionCtx wsc = WebSessionCtx.get(request); 
		WWindowStatus ws = WWindowStatus.get(request);
		if (wsc == null || ws == null)
		{
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		//  Get Mandatory Parameters
//		String formName = WebUtil.getParameter (request, "formName");
		String columnName = WebUtil.getParameter (request, "columnName");
		//
		GridField mField = ws.curTab.getField(columnName);
//		log.config("FormName=" + formName + ", ColumnName=" + columnName + ", MField=" + mField.toString());
		log.config("ColumnName=" + columnName + ", MField=" + mField.toString());
//		if (mField == null || formName == null || columnName == null || formName.equals("") || columnName.equals(""))
		if (mField == null || columnName == null || columnName.equals(""))
		{
			WebUtil.createTimeoutPage(request, response, this,  
				Msg.getMsg(wsc.ctx, "ParameterMissing"));
			return;
		}

	//	Object value = ws.curTab.getValue(columnName);
//		String target = "window.opener.top.WWindow.document." + formName + "." + columnName;
		String target = columnName;

		//  Create Document
		WebDoc doc = WebDoc.create (mField.getHeader());

		doc.getHead().addElement(new script((Element)null, "js/window.js"));

	    StringBuffer sb = new StringBuffer();
	    sb.append("function selectAccount(columnName, key, value) {\n")
	        .append("    if (! checkParent(window)) {\n")
	        .append("        window.close();\n")
	        .append("		return;\n")
	        .append("	}\n")
	        .append("    var targetObj = null;\n")
	        .append("    var updateObj = null;\n")
	        .append("    if (window.opener.top.WWindow) {\n")
	        .append("    	targetObj = (window.opener.top.WWindow.document.getElementById(columnName + 'D'));\n")
	        .append("    	updateObj = (window.opener.top.WWindow.document.getElementById(columnName + 'F'));\n")
	        .append("    } else {\n")
	        .append("	    targetObj = (window.opener.top.document.getElementById(columnName + 'D'));\n")
	        .append("	    updateObj = (window.opener.top.document.getElementById(columnName + 'F'));\n")
	        .append("    }\n")
	        .append("    if (targetObj != null && updateObj != null) {\n")
	        .append("        targetObj.value = key;\n")
	        .append("        updateObj.value = value;\n")
	        .append("        startUpdate(updateObj);\n")
	        .append("    }\n")
	        .append("    window.close();\n")
	        .append("    window.opener.focus();\n")
	        .append("}\n");
		doc.getHead().addElement(new script(sb.toString()));
	    sb = new StringBuffer();
	    sb.append("function resetAccount(columnName) {\n")
	        .append("    selectAccount(columnName, '', '');\n")
	        .append("}\n");
		doc.getHead().addElement(new script(sb.toString()));

		body body = doc.getBody();
		body.setOnBlur("self.focus();");
		body.addElement(fillTable(ws, mField, target));

		//  Reset, Cancel
		button reset = new button();
		reset.addElement("Reset");                      //  translate
		reset.setOnClick("resetAccount('" + target + "');");
		button cancel = new button();
		cancel.addElement("Cancel");                    //  translate
		cancel.setOnClick("window.close();");
		body.addElement(new p(AlignType.RIGHT)
			.addElement(reset)
			.addElement("&nbsp")
			.addElement(cancel));
		//
	//	log.fine( doc.toString());
		WebUtil.createResponse (request, response, this, null, doc, false);
	}   //  doGet


	/**
	 *  Process the HTTP Post request - perform doGet
	 *  @param request
	 *  @param response
	 *  @throws ServletException
	 *  @throws IOException
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		log.config( "WAccount.doPost");
		doGet(request, response);
	}   //  doPost


	/*************************************************************************/

	/**
	 *  Fill Table (Generic)
	 *
	 * @param ws        WindowStatus
	 * @param mField    the Field
	 * @param target    target field string
	 * @return  Table with selection
	 */
	private table fillTable (WWindowStatus ws, GridField mField, String target)
	{
		table table = new table("1");
		tr line = new tr();
//		line.addElement(new th("&nbsp")).addElement(new th(Msg.translate(ws.ctx, "Name")));
		line.addElement(new th("&nbsp")).addElement(new th(Msg.translate(ws.ctx, "Name")));
		table.addElement(line);

		//  Fill & list options
		Lookup lookup = mField.getLookup();
		lookup.fillComboBox(mField.isMandatory(false), true, true, true);   //  no context check
		int size = lookup.getSize();
		for (int i = 0; i < size; i++)
		{
			Object lValue = lookup.getElementAt(i);
			if (!(lValue != null && lValue instanceof KeyNamePair))
				continue;
			//
		//	log.fine( lValue.toString());
			KeyNamePair np = (KeyNamePair)lValue;
			button button = new button();
			button.addElement("&gt;");
			StringBuffer script = new StringBuffer("selectAccount('" + target + "', '" + np.getKey() + "', '" + np.getName() + "');");
//			script.append(".value='").append(np.getKey()).append("';")
//				.append(target).append("D.value='").append(np.getName()).append("';window.close();");
			button.setOnClick(script.toString());
			//
			line = new tr();
			line.addElement(new td(button));
			String name = np.getName();
			if (name == null || name.length() == 0)
				name = "&nbsp";
			line.addElement(new td(name));
			table.addElement(line);
		}
		//  Restore
		lookup.fillComboBox(true);
		return table;
	}   //  fillTable

}   //  WAccount
