/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.AlignType;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;


/**
 *	HTML Find UI.
 *
 *  @author Jorg Janke
 *  @version  $Id: WHistory.java,v 1.1 2010/01/13 11:51:47 clmg Exp $
 */
public class WHistory extends HttpServlet {
    /** Serial Version UID. */
	private static final long serialVersionUID = 6617424544044122702L;

    /**	Logger.	*/
    private CLogger log = CLogger.getCLogger(getClass());

	/**
	 * Initialize global variables.
     * @param config ServletConfig
     * @throws ServletException ServletException
	 */
	public final void init(final ServletConfig config)
		throws ServletException {
		super.init(config);
		if (!WebEnv.initWeb(config)) {
			throw new ServletException("WProcess.init");
        }
	}   //  init

	/**
	 *	Process the HTTP Get request.
	 *	Initial Call
     *  @param request request
     *  @param response response
     *  @throws ServletException ServletException
     *  @throws IOException IOException
	 */
	public final void doGet(
            final HttpServletRequest request,
            final HttpServletResponse response)
		throws ServletException, IOException {

        log.fine("doGet");
        
        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);

		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}
		
		WebDoc doc = createFindPage(request);

		if (doc == null) {
			doc = WebDoc.createWindow("Error");
		}

		// Add body onUnload event, close all popup window when unload 
		doc.getBody().setOnUnload("closeMyChildren();");

		//
		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doGet


	/**
	 *  Process the HTTP Post request.
	 *  Get Parameters and Process
     *  @param request request
     *  @param response response
     *  @throws ServletException ServletException
     *  @throws IOException IOException
	 */
	public final void doPost(final HttpServletRequest request, final HttpServletResponse response)
		throws ServletException, IOException {

        log.fine("doPost");
        
        //  Get Session attributes
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);

		if (wsc == null) {
			WebUtil.createTimeoutPage(request, response, this, null);
			return;
		}

//        if (WebUtil.getParameter(request, "All") != null) {
//            ws.curTab.query(false, 0);
//        } else if (WebUtil.getParameter(request, "Year") != null) {
//            ws.curTab.query(false, 365);
//        } else if (WebUtil.getParameter(request, "Month") != null) {
//            ws.curTab.query(false, 31);
//        } else if (WebUtil.getParameter(request, "Week") != null) {
//            ws.curTab.query(false, 7);
//        } else if (WebUtil.getParameter(request, "Day") != null) {
//            ws.curTab.query(true, 0);
//        }
        if (WebUtil.getParameter(request, "All") != null) {
//            ws.curTab.query(false, 0);
        	 ws.curTab.query(0);
        } else if (WebUtil.getParameter(request, "Year") != null) {
            ws.curTab.query(365);
        } else if (WebUtil.getParameter(request, "Month") != null) {
            ws.curTab.query(31);
        } else if (WebUtil.getParameter(request, "Week") != null) {
            ws.curTab.query(7);
        } else if (WebUtil.getParameter(request, "Day") != null) {
            ws.curTab.query(0);
        }

        WebDoc doc = WebDoc.createWindow(ws.curTab.getTableName());
		doc.getBody().addElement(ws.curTab.getQuery().getWhereClause());
		StringBuffer sb = new StringBuffer();
		sb.append("<script language='javascript'>");
		sb.append("   opener.document.WForm.PCommand.value='Refresh';");
		sb.append("   opener.document.WForm.submit();");
		sb.append("   window.close();");
		sb.append("</script>");
		doc.getBody().addElement(sb.toString());

		WebUtil.createResponse(request, response, this, null, doc, false);
	}   //  doPost

	/**
	 * 	Create Find Page.
     *  @param request request
	 *	@return Page
	 */
	private WebDoc createFindPage(final HttpServletRequest request) {
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		WWindowStatus ws = WWindowStatus.get(request);

		WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx , "VOnlyCurrentDays", true));
		
		form myForm = new form(request.getRequestURI());
		myForm.setID("WHistory");

		table myTable = new table();
		myTable.setAlign("CENTER");

		//	Submit
		myTable.addElement(new tr()
			   .addElement(new td(null, AlignType.CENTER, AlignType.MIDDLE, false,
                       new input(input.TYPE_SUBMIT, "Day", Msg.translate(wsc.ctx, "Day"))))
			   .addElement(new td(null, AlignType.CENTER, AlignType.MIDDLE, false,
                       new input(input.TYPE_SUBMIT, "Week", Msg.translate(wsc.ctx, "Week"))))
		   	   .addElement(new td(null, AlignType.CENTER, AlignType.MIDDLE, false,
                       new input(input.TYPE_SUBMIT, "Month", Msg.translate(wsc.ctx, "Month"))))
		   	   .addElement(new td(null, AlignType.CENTER, AlignType.MIDDLE, false,
                       new input(input.TYPE_SUBMIT, "Year", Msg.translate(wsc.ctx, "Year"))))
		       .addElement(new td(null, AlignType.CENTER, AlignType.MIDDLE, false,
                       new input(input.TYPE_SUBMIT, "All", Msg.translate(wsc.ctx, "All")))));

		myForm.addElement(myTable);
		doc.getBody().addElement(myForm);

		return doc;
	}	//	createFindPage
	
}   //  WHistory
