/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.struts.common.PopupBaseForm;

/**
 * @author Shinjirito
 *
 */
public class InfoLookupForm extends PopupBaseForm {
	private static final long serialVersionUID = -7461986088138535151L;

	private String name;
	private String searchWhere;
	private String months;
	private String shortMonths;
	private String weeks;
	private String shortWeeks;
	private String dateFormat = "MM/DD/YYYY";
	private String invalidDateMsg = "Invalid Date";

	/**
	 * Reset all properties to their default values.
	 *
	 * @param mapping The mapping used to select this instance
	 * @param request The servlet request we are processing
	 */
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		/**
    	 * This will set LoginUserId From Session  
    	 */
    	super.reset(mapping, request);		

    	/**
    	 * Reset all properties to their default values.
    	 */
	}

	/**
	 *	Static Setup - set field value
	 */
	public void statInit(Ctx ctx) {
		super.statInit(ctx);
		setTitle(Msg.translate(ctx, "Lookup"));
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDateFormat() {
		return dateFormat;
	}
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}
	public String getMonths() {
		return months;
	}
	public void setMonths(String months) {
		this.months = months;
	}
	public String getShortMonths() {
		return shortMonths;
	}
	public void setShortMonths(String shortMonths) {
		this.shortMonths = shortMonths;
	}
	public String getShortWeeks() {
		return shortWeeks;
	}
	public void setShortWeeks(String shortWeeks) {
		this.shortWeeks = shortWeeks;
	}
	public String getWeeks() {
		return weeks;
	}
	public void setWeeks(String weeks) {
		this.weeks = weeks;
	}
	public String getSearchWhere() {
		return searchWhere;
	}
	public void setSearchWhere(String searchWhere) {
		this.searchWhere = searchWhere;
	}
	public String getInvalidDateMsg() {
		return invalidDateMsg;
	}

	public void setInvalidDateMsg(String invalidDateMsg) {
		this.invalidDateMsg = invalidDateMsg;
	}
	/**
	 * Set date relative informations(month, day, week day, date format)
	 * @param loc
	 */
	public void setDateInfos(Locale loc, String dateFormat, String invalidDateMsg) {
		months = AmpiereUtil.getMonths(loc);
		shortMonths = AmpiereUtil.getShortMonths(loc);
		weeks = AmpiereUtil.getWeeks(loc);
		shortWeeks = AmpiereUtil.getShortWeeks(loc);
		this.dateFormat = "\"" + dateFormat + "\"";
		this.invalidDateMsg = "\"" + invalidDateMsg + "\"";
	}
}
