/*
 * Copyright James House (c) 2001-2004
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 1.
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. 2. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 */
package com.jware.apps.scheduler.jobs;

import java.util.Date;

import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;

/**
 * @author James House
 */
public class QuartzRemoteClient {

    QuartzRemoteClient() {
    }

    public static void useRemoteScheduler(SchedulerFactory schedFact)
            throws Exception {

        Scheduler sched = schedFact.getScheduler();

        JobDetail job = new JobDetail("remotelyAddedJob", "default",
                DumbJob2.class);
        JobDataMap map = new JobDataMap();
        map.put("msg", "Your remotely added job has executed!");
        job.setJobDataMap(map);
        //    SimpleTrigger st = new SimpleTrigger("remotelyAddedTrigger",
        // "default", "remotelyAddedJob", "default", new Date(), null, 0, 0);
        CronTrigger ct = new CronTrigger("remotelyAddedTrigger", "default",
                "remotelyAddedJob", "default", new Date(), null, "/5 * * ? * *");

        sched.scheduleJob(job, ct);

        System.err.println("\n*** Remote job scheduled.");

    }

    public static void main(String[] args) throws Exception {

        // Configure Log4J
        // org.apache.log4j.PropertyConfigurator.configure(System.getProperty("log4jConfigFile",
        // "log4j.properties"));

        try {
            useRemoteScheduler(new org.quartz.impl.StdSchedulerFactory());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}