/*
 */
package com.jware.base.error;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Shigeaki Wakizaka
 *
 */
public class JwareRuntimeException extends RuntimeException {

/**
 * ��Ȍ���̗�O��ێ�
 */
	protected Throwable rootCause = null;
	
/**
 * �K�w�̗�O����ێ�
 */
	private List exceptions = new ArrayList();
	
/**
 * Struts�̃��\�[�X�o���h���̃L�[�Ƃ��Ďg�p
 */
	private String messageKey = null;
	
/**
 * ���\�[�X�o���h���Ń��b�Z�[�W�Ƃ��ė��p����ϐ�
 */	
	private Object[] messageBundleValues = null;


	public JwareRuntimeException(){
		super();
	}
	
	public JwareRuntimeException(String messageKey){
		super();
		this.messageKey = messageKey;
	}

	public JwareRuntimeException(String messageKey,Object[] messageBundleValues){
		super();
		this.messageKey = messageKey;
		this.messageBundleValues = messageBundleValues;	
	}

	public List getExceptions() {
		return this.exceptions;
	}

	public void addException(JwareRuntimeException ex) {
		exceptions.add(ex);
	}


	/**
	 * @return
	 */
	public Object[] getMessageBundleValues() {
		return this.messageBundleValues;
	}

	/**
	 * @return
	 */
	public String getMessageKey() {
		return this.messageKey;
	}
	
	/**
 	*	@return
	*/
	public Throwable getRootCause() {
		return this.rootCause;
	}
	
	/**
	 * @param objects
	 */
	public void setMessageBundleValues(Object[] messageBundleValues) {
		this.messageBundleValues = messageBundleValues;
	}

	/**
	 * @param string
	 */
	public void setMessageKey(String messageKey) {
		this.messageKey = messageKey;
	}

	/**
	 * @param throwable
	 */
	public void setRootCause(Throwable rootCause) {
		this.rootCause = rootCause;
	}

	public void printStackTrace() {
		printStackTrace(System.err);
	}

	public void printStackTrace(PrintStream outStream) {
		printStackTrace(new PrintWriter(outStream));
	}

	public void printStackTrace(PrintWriter writer) {
		super.printStackTrace(writer);

		if (getRootCause() != null) {
			getRootCause().printStackTrace(writer);
			
		}

		writer.flush();

	}



}
