package com.jware.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

/**
 * @author jrmt
 */
public class FileUtility {

    /**
     * 
     */
    public FileUtility() {
        super();
    }

	/**
 	 * ファイル内容に行リストの記述
	 * @param listFile
	 * @param stringList
	 * @throws IOException
	 */
	public static boolean writeToNewFile(String dir, String filename, String contents, String encoding ) 
		{

	    boolean result = false;
	    File file = null;
	    FileOutputStream fos = null;
	    FileChannel channel = null;
	    
	    try {
			//ファイルクラスのインスタンス作成と初期化		
			file = new File(dir + 
				FileSeparator(dir) + 
				filename);
	
			//存在する場合削除する
//		    file.deleteOnExit();
	
		    int lastIndex = file.getPath().lastIndexOf(File.separator);
		    if( lastIndex > 0 ){
			    String filePath = file.getPath().substring( 0, lastIndex );
		        File pathFile = new File(  filePath );
		        pathFile.mkdirs();
		    }
		    
		    //ファイルの作成
			file.createNewFile();
	
			//ファイルストリームのインスタンス作成と初期化
			fos = new FileOutputStream(file);
	
			//ファイルチャネルクラスのインスタンス作成と初期化
			channel = fos.getChannel();
			
			//Charsetの初期化
			Charset charset = Charset.forName(encoding);
			CharsetEncoder encoder = charset.newEncoder();
	
			//各変数の初期化
			ByteBuffer byteBuffer = null;
			CharBuffer charBuffer;
			char[] ch;
			
			charBuffer = CharBuffer.wrap(contents.toCharArray());
			byteBuffer = encoder.encode(charBuffer);
			channel.write(byteBuffer);
			byteBuffer.clear();
			charBuffer.clear();
	
			byteBuffer = null;
			charBuffer = null;
			file = null;
		    
			result = true;

	    } catch ( IOException e ) {
	        e.printStackTrace();
	    } finally {
	        
	        if( channel != null ){
	            try{
	                channel.close();
	            }catch(IOException e){
	                ;
	            }
				channel = null;
	        }
	        if( fos != null){
	            try{
	                fos.close();
	            }catch(IOException e){
	                ;
	            }
				fos = null;
	        }
			file = null;
	    }
		
		return result;
	}

	/**
 	 * ファイル内容に行リストの記述
	 * @param listFile
	 * @param stringList
	 * @throws IOException
	 */
	public static boolean writeToNewFile(String dir, String filename, byte[] contents ) 
		{

	    boolean result = false;
	    File file = null;
	    FileOutputStream fos = null;
	    
	    try {
			//ファイルクラスのインスタンス作成と初期化		
			file = new File(dir + 
				FileSeparator(dir) + 
				filename);
	
			//存在する場合削除する
//		    file.deleteOnExit();
	
		    int lastIndex = file.getPath().lastIndexOf(File.separator);
		    if( lastIndex > 0 ){
			    String filePath = file.getPath().substring( 0, lastIndex );
		        File pathFile = new File(  filePath );
		        pathFile.mkdirs();
		    }
		    
		    //ファイルの作成
			file.createNewFile();
	
			//ファイルストリームのインスタンス作成と初期化
			fos = new FileOutputStream(file);
	
			fos.write( contents );
			
			file = null;
		    
			result = true;

	    } catch ( IOException e ) {
	        e.printStackTrace();
	    } finally {
	        
	        if( fos != null){
	            try{
	                fos.close();
	            }catch(IOException e){
	                ;
	            }
				fos = null;
	        }
			file = null;
	    }
		
		return result;
	}
	
	
	private static String FileSeparator( String leadingpath ){

		String needSeperator = "";
		if( leadingpath != null && leadingpath.length() > 0 ){
			String end_char = leadingpath.substring(leadingpath.length()-1);
			if( !"/".equals(end_char) && !File.separator.equals(end_char) ){
				needSeperator = File.separator;		
			}
		}
		
		return( needSeperator ); 
				
	}
	
    
    
}
