/*
 * Created on 2004/11/15
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jware.util.dbutils;

import java.sql.*;

/**
 * @author jrmt
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DataModule {

    private static DataModule myDM;

    private String  dbDriver = "oracle.jdbc.driver.OracleDriver";   //  database Driver
    private String  dbUrl = "jdbc:oracle:thin:@jrwin2000:1521:orcl";   //  database URL
    private String  dbUsr = "mms";   //  database user
    private String  dbPas = "mms";   //  database password
    private String  dbCharset = "UFT8";   //  database charset

    public DataModule() {
      try {
        jbInit();
      }
      catch(Exception e) {
        e.printStackTrace();
      }
    }
    
    private void jbInit() throws Exception {
      loadDriver();
    }
    
    public static DataModule getDataModule() {
      if (myDM == null) {
        myDM = new DataModule();
      }
      return myDM;
    }
    
    private void  loadDriver()  {
        
      try {
           Class.forName(dbDriver);
      }catch(java.lang.ClassNotFoundException  e) {
          
      }
    }

    //  Get Database Connection Object
    public Connection  getConnection() throws Exception {
      Connection  conn  = null;
      loadDriver();
      try {
          conn  = java.sql.DriverManager.getConnection(dbUrl, dbUsr,dbPas);
      }
      catch(SQLException  e)  {
        throw e;
      }
      return  conn;
    }

    //  Get Database Connection Object
    public Connection  getConnection(String url,
                                     String user,
                                     String pass
                                     ) throws Exception  {
      Connection  conn  = null;
      loadDriver();
      try {
          conn  = java.sql.DriverManager.getConnection(url, user,pass);
      }
      catch(SQLException  e)  {
        throw e;
      }
      return  conn;
    }

    public Connection  getConnection(boolean autocommit, //  true:auto commit , false:mannual commit
                                     int level          //  transaction level
                                     ) throws Exception  {
      Connection  conn  = null;
      loadDriver();
      try {
        conn  = java.sql.DriverManager.getConnection(dbUrl, dbUsr,dbPas);
        conn.setAutoCommit(autocommit);
        conn.setTransactionIsolation(level);
      }
      catch(SQLException  e)  {
        System.out.println(e.getMessage());
        throw e;
      }
      return  conn;
    }

    public Connection  getConnection(String url,
                                     String user,
                                     String pass,
                                     boolean autocommit, //  true:auto commit , false:mannual commit
                                     int level          //  transaction level
                                     ) throws Exception  {
      Connection  conn  = null;
      loadDriver();
      try {
        conn  = java.sql.DriverManager.getConnection(url, user,pass);
        conn.setAutoCommit(autocommit);
        conn.setTransactionIsolation(level);
      }
      catch(SQLException  e)  {
        System.out.println(e.getMessage());
        throw e;
      }
      return  conn;
    }

    //  Disconnect Database
    public  void  closeConnection(Connection  conn) throws  Exception {
      try {
        conn.close();
      }
      catch(SQLException  e)  {
        throw e;
      }
    }

    /**
     * @return Returns the myDM.
     */
    public static DataModule getMyDM() {
        return myDM;
    }
    /**
     * @param myDM The myDM to set.
     */
    public static void setMyDM(DataModule myDM) {
        DataModule.myDM = myDM;
    }
    /**
     * @return Returns the dbCharset.
     */
    public String getDbCharset() {
        return dbCharset;
    }
    /**
     * @param dbCharset The dbCharset to set.
     */
    public void setDbCharset(String dbCharset) {
        this.dbCharset = dbCharset;
    }
    /**
     * @return Returns the dbDriver.
     */
    public String getDbDriver() {
        return dbDriver;
    }
    /**
     * @param dbDriver The dbDriver to set.
     */
    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }
    /**
     * @return Returns the dbPas.
     */
    public String getDbPas() {
        return dbPas;
    }
    /**
     * @param dbPas The dbPas to set.
     */
    public void setDbPas(String dbPas) {
        this.dbPas = dbPas;
    }
    /**
     * @return Returns the dbUrl.
     */
    public String getDbUrl() {
        return dbUrl;
    }
    /**
     * @param dbUrl The dbUrl to set.
     */
    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }
    /**
     * @return Returns the dbUsr.
     */
    public String getDbUsr() {
        return dbUsr;
    }
    /**
     * @param dbUsr The dbUsr to set.
     */
    public void setDbUsr(String dbUsr) {
        this.dbUsr = dbUsr;
    }
    
}
