/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.RemoteCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.RemoteCacheWatchRepairable;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheWatch;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheClusterMonitor;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerListener;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICacheManager;

public class RemoteCacheClusterManager
implements ICacheManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterManager == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterManager = RemoteCacheClusterManager.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheClusterManager")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterManager));
    static final Map instances = new HashMap();
    private static RemoteCacheClusterMonitor monitor;
    private int clients;
    final Map caches = new HashMap();
    final String host;
    final int port;
    final String service;
    private IRemoteCacheAttributes irca;
    private IRemoteCacheService remoteService;
    private RemoteCacheWatchRepairable remoteWatch;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterManager;

    private RemoteCacheClusterManager(String host, int port, String service) {
        this.host = host;
        this.port = port;
        this.service = service;
        String registry = "//" + host + ":" + port + "/" + service;
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up server " + registry));
        }
        try {
            Remote obj = Naming.lookup(registry);
            if (log.isDebugEnabled()) {
                log.debug((Object)"server found");
            }
            this.remoteService = (IRemoteCacheService)obj;
            this.remoteWatch = new RemoteCacheWatchRepairable();
            this.remoteWatch.setCacheWatch((IRemoteCacheObserver)obj);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            this.remoteService = new ZombieRemoteCacheService();
            this.remoteWatch = new RemoteCacheWatchRepairable();
            this.remoteWatch.setCacheWatch(new ZombieRemoteCacheWatch());
            RemoteCacheClusterMonitor.getInstance().notifyError();
        }
    }

    public IRemoteCacheAttributes getDefaultCattr() {
        return this.irca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCacheListener(IRemoteCacheAttributes cattr, IRemoteCacheListener listener) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            this.remoteWatch.addCacheListener(cattr.getCacheName(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteCacheClusterManager getInstance(IRemoteCacheAttributes cattr) {
        Location loc;
        RemoteCacheClusterManager ins;
        String host = cattr.getRemoteHost();
        int port = cattr.getRemotePort();
        String service = cattr.getRemoteServiceName();
        if (host == null) {
            host = "";
        }
        if (port < 1024) {
            port = 1099;
        }
        if ((ins = (RemoteCacheClusterManager)instances.get(loc = new Location(host, port))) == null) {
            Map map = instances;
            synchronized (map) {
                ins = (RemoteCacheClusterManager)instances.get(loc);
                if (ins == null) {
                    ins = new RemoteCacheClusterManager(host, port, service);
                    ins.irca = cattr;
                    instances.put(loc, ins);
                }
            }
            try {
                cattr.setCacheName("server");
                ins.addRemoteCacheListener(cattr, RemoteCacheServerListener.getInstance(cattr));
            }
            catch (IOException ioe) {
                log.error((Object)ioe);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        ++ins.clients;
        if (monitor == null && (monitor = RemoteCacheClusterMonitor.getInstance()) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
        return ins;
    }

    public ICache getCache(String cacheName) {
        IRemoteCacheAttributes ca = (IRemoteCacheAttributes)this.irca.copy();
        ca.setCacheName(cacheName);
        return this.getCache(ca);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICache getCache(IRemoteCacheAttributes cattr) {
        RemoteCacheNoWait c = null;
        Map map = this.caches;
        synchronized (map) {
            c = (RemoteCacheNoWait)this.caches.get(cattr.getCacheName());
            if (c == null) {
                c = new RemoteCacheNoWait(new RemoteCache(cattr, this.remoteService));
                this.caches.put(cattr.getCacheName(), c);
            }
        }
        try {
            this.addRemoteCacheListener(cattr, RemoteCacheServerListener.getInstance(cattr));
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCache(String name) throws IOException {
        ICache c = null;
        Map map = this.caches;
        synchronized (map) {
            c = (ICache)this.caches.get(name);
        }
        if (c != null) {
            c.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (--this.clients != 0) {
            return;
        }
        Map map = this.caches;
        synchronized (map) {
            Iterator allCaches = this.caches.values().iterator();
            while (allCaches.hasNext()) {
                ICache c = (ICache)allCaches.next();
                if (c == null) continue;
                try {
                    c.dispose();
                }
                catch (IOException ex) {
                    log.error((Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixCaches(IRemoteCacheService remoteService, IRemoteCacheObserver remoteWatch) {
        Map map = this.caches;
        synchronized (map) {
            this.remoteService = remoteService;
            this.remoteWatch.setCacheWatch(remoteWatch);
            Iterator en = this.caches.values().iterator();
            while (en.hasNext()) {
                RemoteCacheNoWait cache = (RemoteCacheNoWait)en.next();
                cache.fixCache(this.remoteService);
            }
        }
    }

    public int getCacheType() {
        return 4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Location {
        public final String host;
        public final int port;

        public Location(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Location)) {
                return false;
            }
            Location l = (Location)obj;
            if (this.host == null && l.host != null) {
                return false;
            }
            return this.host.equals(l.host) && this.port == l.port;
        }

        public int hashCode() {
            return this.host == null ? this.port : this.host.hashCode() ^ this.port;
        }
    }
}

