/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.factories.GreekAlphabetFactory;

public class GreekList
extends List {
    public GreekList() {
        super(true);
        this.setGreekFont();
    }

    public GreekList(int n) {
        super(true, n);
        this.setGreekFont();
    }

    public GreekList(boolean bl, int n) {
        super(true, n);
        this.lowercase = bl;
        this.setGreekFont();
    }

    protected void setGreekFont() {
        float f2 = this.symbol.getFont().getSize();
        this.symbol.setFont(FontFactory.getFont("Symbol", f2, 0));
    }

    public boolean add(Object object2) {
        if (object2 instanceof ListItem) {
            ListItem listItem = (ListItem)object2;
            Chunk chunk = new Chunk(this.preSymbol, this.symbol.getFont());
            chunk.append(GreekAlphabetFactory.getString(this.first + this.list.size(), this.lowercase));
            chunk.append(this.postSymbol);
            listItem.setListSymbol(chunk);
            listItem.setIndentationLeft(this.symbolIndent, this.autoindent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object2 instanceof List) {
                List list = (List)object2;
                list.setIndentationLeft(list.getIndentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object2 instanceof String) {
                return this.add(new ListItem((String)object2));
            }
        }
        return false;
    }
}

