/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;

public class HandoutPdf {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("arguments: srcfile destfile pages");
        } else {
            try {
                int n = Integer.parseInt(stringArray[2]);
                if (n < 2 || n > 8) {
                    throw new DocumentException("You can't have " + n + " pages on one page (minimum 2; maximum 8).");
                }
                float f2 = 30.0f;
                float f3 = 280.0f;
                float f4 = 320.0f;
                float f5 = 565.0f;
                float[] fArray = new float[n];
                float[] fArray2 = new float[n];
                float f6 = (778.0f - 20.0f * (float)(n - 1)) / (float)n;
                fArray[0] = 812.0f;
                fArray2[0] = 812.0f - f6;
                for (int j = 1; j < n; ++j) {
                    fArray[j] = fArray2[j - 1] - 20.0f;
                    fArray2[j] = fArray[j] - f6;
                }
                PdfReader pdfReader = new PdfReader(stringArray[0]);
                int n2 = pdfReader.getNumberOfPages();
                System.out.println("There are " + n2 + " pages in the original file.");
                Document document = new Document(PageSize.A4);
                PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(stringArray[1]));
                document.open();
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                int n3 = 0;
                int n4 = 0;
                while (n3 < n2) {
                    float f7;
                    Rectangle rectangle;
                    float f8;
                    float f9 = (f8 = (f3 - f2) / (rectangle = pdfReader.getPageSizeWithRotation(++n3)).getWidth()) < (f7 = (fArray[n4] - fArray2[n4]) / rectangle.getHeight()) ? f8 : f7;
                    float f10 = f8 == f9 ? 0.0f : (f3 - f2 - rectangle.getWidth() * f9) / 2.0f;
                    float f11 = f7 == f9 ? 0.0f : (fArray[n4] - fArray2[n4] - rectangle.getHeight() * f9) / 2.0f;
                    PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n3);
                    int n5 = pdfReader.getPageRotation(n3);
                    if (n5 == 90 || n5 == 270) {
                        pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -f9, f9, 0.0f, f2 + f10, fArray2[n4] + f11 + rectangle.getHeight() * f9);
                    } else {
                        pdfContentByte.addTemplate(pdfImportedPage, f9, 0.0f, 0.0f, f9, f2 + f10, fArray2[n4] + f11);
                    }
                    pdfContentByte.setRGBColorStroke(192, 192, 192);
                    pdfContentByte.rectangle(f4 - 5.0f, fArray2[n4] - 5.0f, f5 - f4 + 10.0f, fArray[n4] - fArray2[n4] + 10.0f);
                    for (float f12 = fArray[n4] - 19.0f; f12 > fArray2[n4]; f12 -= 16.0f) {
                        pdfContentByte.moveTo(f4, f12);
                        pdfContentByte.lineTo(f5, f12);
                    }
                    pdfContentByte.rectangle(f2 + f10, fArray2[n4] + f11, rectangle.getWidth() * f9, rectangle.getHeight() * f9);
                    pdfContentByte.stroke();
                    System.out.println("Processed page " + n3);
                    if (++n4 != n) continue;
                    n4 = 0;
                    document.newPage();
                }
                document.close();
            }
            catch (Exception exception) {
                System.err.println(exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
    }
}

