/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.ssl;

import com.sfcommerce.jpaymentcomponent.exceptions.CantConnectToServerException;
import com.sfcommerce.jpaymentcomponent.exceptions.CantTunnelThroughProxyException;
import com.sfcommerce.jpaymentcomponent.exceptions.CipherSuiteRefusedByServerException;
import com.sfcommerce.jpaymentcomponent.exceptions.CodeOperationNotFoundException;
import com.sfcommerce.jpaymentcomponent.exceptions.CommunicationErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.ConfigNotInitializedException;
import com.sfcommerce.jpaymentcomponent.exceptions.ConnectionRefusedException;
import com.sfcommerce.jpaymentcomponent.exceptions.HostUnknownException;
import com.sfcommerce.jpaymentcomponent.exceptions.HttpErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.IncorrectParametersException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidRetriesException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidTimeoutException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidURLException;
import com.sfcommerce.jpaymentcomponent.exceptions.ManualInterventionRequiredException;
import com.sfcommerce.jpaymentcomponent.exceptions.MerchantTxnNotSetException;
import com.sfcommerce.jpaymentcomponent.exceptions.NullParameterException;
import com.sfcommerce.jpaymentcomponent.exceptions.ReadFileException;
import com.sfcommerce.jpaymentcomponent.exceptions.ServerCertifNotTrustedException;
import com.sfcommerce.jpaymentcomponent.exceptions.SocketCreationFailedException;
import com.sfcommerce.jpaymentcomponent.exceptions.SocketIOException;
import com.sfcommerce.jpaymentcomponent.exceptions.TransactionAbortedException;
import com.sfcommerce.jpaymentcomponent.exceptions.TransactionNotFoundException;
import com.sfcommerce.jpaymentcomponent.exceptions.UnrecoverableTransactionException;
import com.sfcommerce.jpaymentcomponent.exceptions.UnsupportedCipherSuiteException;
import com.sfcommerce.jpaymentcomponent.ssl.SSLComm;
import com.sfcommerce.jpaymentcomponent.ssl.ServerResponse;
import com.sfcommerce.jpaymentcomponent.utilities.Config;
import com.sfcommerce.jpaymentcomponent.utilities.EventLog;
import java.io.File;
import java.io.IOException;

public class RequestProcessing {
    private static final int PURCHASE = 3;
    private static final int AUTHORIZE = 1;
    private static final int SETTLEMENT = 2;
    private static final String EQUAL_SIGN = "=";
    private static final String UMPERSAND_SIGN = "&";
    private static final String STARTED = "Surefire Commerce Payment Component started";
    private static final String EXITED = "Surefire Commerce Payment Component exited";
    private String myRequest = null;
    private String myResponse = null;
    private String myErrorDesc = null;
    private String myMerchantId = null;
    private String myMerchantPwd = null;
    private String myAccount = null;
    private int myStatus = 0;
    private boolean myCfgFileRead = false;
    private int myTypeOfOperation = -1;
    private String myTxnNumber;
    private StringBuffer myBuiltErrResponse;
    private StringBuffer myUnrecoverableResponse;

    public boolean init(String aConfigFile) throws NullParameterException {
        boolean bRet = true;
        boolean exceptionOccured = false;
        try {
            File file = new File(aConfigFile);
            if (!file.exists()) {
                this.myStatus = -1;
                this.myErrorDesc = "  ERROR(64) Configuration file not found.";
                bRet = false;
                return false;
            }
            if (!file.canRead()) {
                this.myStatus = -4;
                this.myErrorDesc = "  ERROR(67) Configuration file is not readable.";
                bRet = false;
                return false;
            }
        }
        catch (NullPointerException npex) {
            throw new NullParameterException(" Configuration file should be non null string");
        }
        catch (SecurityException sex) {
            this.myStatus = -4;
            this.myErrorDesc = "  ERROR(66) Access denied to the Configuration file.";
            bRet = false;
            return false;
        }
        try {
            this.readConfigFile(aConfigFile);
            EventLog.init("");
            EventLog.log(0, STARTED);
        }
        catch (ReadFileException rfex) {
            this.myStatus = -4;
            this.myErrorDesc = "  ERROR(65) Error reading the configuration file.";
            EventLog.log(1, this.myErrorDesc);
            exceptionOccured = true;
        }
        if (!exceptionOccured) {
            try {
                bRet = this.checkParameters();
            }
            catch (ConfigNotInitializedException not) {
                not.printStackTrace();
            }
        }
        if (bRet) {
            try {
                this.myAccount = Config.getProperty("account");
                this.myMerchantId = Config.getProperty("merchantId");
                this.myMerchantPwd = Config.getProperty("merchantPwd");
            }
            catch (ConfigNotInitializedException cfn) {
                // empty catch block
            }
            this.myCfgFileRead = true;
        }
        return bRet;
    }

    private void readConfigFile(String aConfigFile) throws ReadFileException {
        try {
            Config.init(aConfigFile);
        }
        catch (IOException ioex) {
            throw new ReadFileException();
        }
    }

    private boolean checkParameters() throws ConfigNotInitializedException {
        int psp;
        boolean bRet = true;
        this.myStatus = 0;
        this.myErrorDesc = new String("Configuration file successfully processed");
        if (Config.getProperty("PaymentServerURL") == null || Config.getProperty("PaymentServerURL").length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = new String("  ERROR(50) PaymentServerURL is missing.");
            EventLog.log(1, this.myErrorDesc);
            bRet = false;
        } else if (Config.getProperty("PaymentServerPort") == null || Config.getProperty("PaymentServerPort").length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = new String("  ERROR(51) PaymentServerPort is missing.");
            EventLog.log(1, this.myErrorDesc);
            bRet = false;
        } else if (Config.getProperty("HTTPVersion") == null || Config.getProperty("HTTPVersion").length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = new String("  ERROR(60) HTTPVersion is missing.");
            EventLog.log(1, this.myErrorDesc);
            bRet = false;
        } else if (Config.getProperty("ProxyServer") != null && Config.getProperty("ProxyServer").length() > 0 && (Config.getProperty("ProxyPort") == null || Config.getProperty("ProxyPort").length() == 0)) {
            this.myStatus = -2;
            this.myErrorDesc = new String("  ERROR(54) ProxyPort is missing.");
            EventLog.log(1, this.myErrorDesc);
            bRet = false;
        } else if ((Config.getProperty("ProxyServer") == null || Config.getProperty("ProxyServer").length() == 0) && Config.getProperty("ProxyPort") != null && Config.getProperty("ProxyPort").length() > 0) {
            this.myStatus = -2;
            this.myErrorDesc = new String("  ERROR(53) ProxyServer is missing.");
            EventLog.log(1, this.myErrorDesc);
            bRet = false;
        } else if (Config.getProperty("Cipher") == null || Config.getProperty("Cipher").length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = new String("  ERROR(57) Cipher is missing.");
            EventLog.log(1, this.myErrorDesc);
            bRet = false;
        }
        if (bRet) {
            try {
                psp = Integer.parseInt(Config.getProperty("PaymentServerPort"));
            }
            catch (NumberFormatException nfex) {
                this.myStatus = -2;
                this.myErrorDesc = new String("  ERROR(61) PaymentServerPort is invalid.");
                EventLog.log(1, this.myErrorDesc);
                bRet = false;
            }
        }
        if (bRet && Config.getProperty("ProxyPort") != null && Config.getProperty("ProxyPort").length() > 0) {
            try {
                psp = Integer.parseInt(Config.getProperty("ProxyPort"));
            }
            catch (NumberFormatException nfex) {
                this.myStatus = -2;
                this.myErrorDesc = new String("  ERROR(62) ProxyPort is invalid.");
                EventLog.log(1, this.myErrorDesc);
                bRet = false;
            }
        }
        if (bRet) {
            int point = 46;
            int index = 0;
            index = Config.getProperty("HTTPVersion").indexOf(point);
            if (index == -1) {
                try {
                    int psp2 = Integer.parseInt(Config.getProperty("HTTPVersion"));
                }
                catch (NumberFormatException nfex) {
                    this.myStatus = -2;
                    this.myErrorDesc = new String("  ERROR(63) HTTPVersion is invalid.");
                    EventLog.log(1, this.myErrorDesc);
                    bRet = false;
                }
            } else {
                String str1 = Config.getProperty("HTTPVersion").substring(0, index);
                String str2 = Config.getProperty("HTTPVersion").substring(index + 1);
                try {
                    int psp3 = Integer.parseInt(str1);
                    int psp1 = Integer.parseInt(str2);
                }
                catch (NumberFormatException nfex) {
                    this.myStatus = -2;
                    this.myErrorDesc = new String("  ERROR(63) HTTPVersion is invalid.");
                    EventLog.log(1, this.myErrorDesc);
                    bRet = false;
                }
            }
        }
        if (bRet) {
            Config.getProperty("Timeout", new Integer(120).toString());
            Config.getProperty("LogLevel", "INFORMATION");
            Config.getProperty("Retries", new Integer(5).toString());
            Config.getProperty("LogBasePath", ".");
            Config.getProperty("LogFilename", "event_log.log");
            Config.getProperty("LogMaxSize", new Integer(10240000).toString());
            Config.getProperty("LogMaxBackupFiles", new Integer(10).toString());
        }
        if (!bRet) {
            EventLog.log(0, "Request not processed due to parameter(s) error(s).");
            EventLog.log(0, EXITED);
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(String aRequest) throws NullParameterException {
        boolean bRet;
        block63: {
            boolean bRecovery = false;
            boolean excepOccured = false;
            bRet = true;
            if (aRequest == null) {
                EventLog.log(1, " Request should be non null string");
                EventLog.log(0, "Can't process null request.");
                EventLog.log(0, EXITED);
                throw new NullParameterException(" Request should be non null string");
            }
            if (!this.myCfgFileRead) {
                this.myStatus = -3;
                this.myErrorDesc = "  ERROR(68) Call init method first.";
                EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                EventLog.log(0, this.getMerchantTXN(aRequest) + "Request not processed due to configuration file read error.");
                EventLog.log(0, EXITED);
                return false;
            }
            if (this.myMerchantId == null || this.myMerchantId.length() == 0) {
                this.myStatus = -2;
                this.myErrorDesc = new String("  ERROR(52) merchantId is missing.");
                EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                return false;
            }
            if (this.myMerchantPwd == null || this.myMerchantPwd.length() == 0) {
                this.myStatus = -2;
                this.myErrorDesc = new String("  ERROR(58) merchantPwd is missing.");
                EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                return false;
            }
            if (this.myAccount == null || this.myAccount.length() == 0) {
                this.myStatus = -2;
                this.myErrorDesc = new String("  ERROR(59) account is missing.");
                EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                bRet = false;
            }
            try {
                this.myRequest = this.completeTheRequest(aRequest);
            }
            catch (ConfigNotInitializedException not) {
                not.printStackTrace();
            }
            try {
                this.myTypeOfOperation = this.getTypeOfOperation();
            }
            catch (CodeOperationNotFoundException copex) {
                this.myTypeOfOperation = -1;
            }
            if (this.myTypeOfOperation == 1 || this.myTypeOfOperation == 2 || this.myTypeOfOperation == 3 || this.myTypeOfOperation == 4 || this.myTypeOfOperation == 5) {
                bRecovery = true;
            }
            Integer serverPort = null;
            String urlServer = "";
            try {
                serverPort = new Integer(Config.getProperty("PaymentServerPort"));
                urlServer = Config.getProperty("PaymentServerURL");
            }
            catch (ConfigNotInitializedException cni) {
                cni.printStackTrace();
            }
            try {
                try {
                    this.myResponse = this.sendTheRequest(urlServer, serverPort, bRecovery);
                }
                catch (IncorrectParametersException ipex) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = ipex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_12 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (SocketCreationFailedException scex) {
                    excepOccured = true;
                    this.myStatus = -5;
                    this.myErrorDesc = scex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_13 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (CipherSuiteRefusedByServerException refex) {
                    excepOccured = true;
                    this.myStatus = -12;
                    this.myErrorDesc = refex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_14 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (CantConnectToServerException canex) {
                    excepOccured = true;
                    this.myStatus = -8;
                    this.myErrorDesc = canex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_15 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (ConnectionRefusedException canex) {
                    excepOccured = true;
                    this.myStatus = -8;
                    this.myErrorDesc = canex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_16 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (SocketIOException sioe) {
                    excepOccured = true;
                    this.myStatus = -5;
                    this.myErrorDesc = sioe.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_17 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (HostUnknownException hoex) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = hoex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_18 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (InvalidURLException iurl) {
                    excepOccured = true;
                    this.myStatus = -8;
                    this.myErrorDesc = iurl.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_19 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (UnsupportedCipherSuiteException uce) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = uce.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_20 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (CommunicationErrorException comex) {
                    excepOccured = true;
                    this.myStatus = -8;
                    this.myErrorDesc = comex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_21 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (MerchantTxnNotSetException mtxexp) {
                    excepOccured = true;
                    this.myStatus = -9;
                    this.myErrorDesc = mtxexp.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_22 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (TransactionAbortedException taborex) {
                    excepOccured = true;
                    this.myStatus = -8;
                    this.myErrorDesc = taborex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = this.myBuiltErrResponse.toString();
                    Object var29_23 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (UnrecoverableTransactionException utex) {
                    excepOccured = true;
                    this.myStatus = -7;
                    this.myErrorDesc = utex.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = this.myUnrecoverableResponse.toString();
                    Object var29_24 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (TransactionNotFoundException tnf) {
                    excepOccured = true;
                    this.myStatus = -10;
                    this.myErrorDesc = tnf.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_25 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (ManualInterventionRequiredException mit) {
                    excepOccured = true;
                    this.myStatus = -9;
                    this.myErrorDesc = mit.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_26 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (ConfigNotInitializedException not) {
                    not.printStackTrace();
                    Object var29_27 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (HttpErrorException httpError) {
                    excepOccured = true;
                    this.myStatus = -8;
                    this.myErrorDesc = httpError.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_28 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (InvalidTimeoutException ite) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = ite.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_29 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (InvalidRetriesException ire) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = ire.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_30 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (CantTunnelThroughProxyException ctt) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = ctt.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_31 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                    break block63;
                }
                catch (ServerCertifNotTrustedException ser) {
                    excepOccured = true;
                    this.myStatus = -2;
                    this.myErrorDesc = ser.getMessage();
                    EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                    this.myResponse = aRequest;
                    Object var29_32 = null;
                    if (excepOccured) {
                        bRet = false;
                    }
                }
                Object var29_11 = null;
                if (excepOccured) {
                    bRet = false;
                }
            }
            catch (Throwable throwable) {
                Object var29_33 = null;
                if (excepOccured) {
                    bRet = false;
                }
                throw throwable;
            }
        }
        if (bRet) {
            EventLog.log(2, this.getMerchantTXN(aRequest) + "Response got from Payment Server: " + this.myResponse);
            if (this.myResponse.indexOf("status=E") >= 0) {
                this.myStatus = -8;
                this.myErrorDesc = "  ERROR(108) The server failed to process your transaction.";
                EventLog.log(1, this.getMerchantTXN(aRequest) + this.myErrorDesc);
                EventLog.log(0, this.getMerchantTXN(aRequest) + "Payment server failed to processt this request");
                bRet = false;
            } else {
                this.myStatus = 0;
                this.myErrorDesc = "Request processed successfully.";
                EventLog.log(0, this.getMerchantTXN(aRequest) + "Request successfully processed by Payment Server.");
            }
        } else {
            EventLog.log(0, this.getMerchantTXN(aRequest) + "Request not processed.");
        }
        EventLog.log(0, EXITED);
        return bRet;
    }

    private String completeTheRequest(String aRequest) throws ConfigNotInitializedException {
        StringBuffer strRequest = null;
        strRequest = new StringBuffer(aRequest);
        strRequest.append(UMPERSAND_SIGN);
        strRequest.append("account");
        strRequest.append(EQUAL_SIGN);
        strRequest.append(this.myAccount);
        strRequest.append(UMPERSAND_SIGN);
        strRequest.append("merchantId");
        strRequest.append(EQUAL_SIGN);
        strRequest.append(this.myMerchantId);
        strRequest.append(UMPERSAND_SIGN);
        strRequest.append("merchantPwd");
        strRequest.append(EQUAL_SIGN);
        strRequest.append(this.myMerchantPwd);
        return strRequest.toString();
    }

    int getTypeOfOperation() throws CodeOperationNotFoundException {
        int type = -1;
        int index = this.myRequest.indexOf("operation");
        if (index == -1) {
            throw new CodeOperationNotFoundException();
        }
        switch (this.myRequest.charAt(index + 10)) {
            case '1': 
            case 'A': 
            case 'a': {
                type = 1;
                break;
            }
            case '2': 
            case 'S': 
            case 's': {
                type = 2;
                break;
            }
            case '3': 
            case 'P': 
            case 'p': {
                type = 3;
                break;
            }
            case 'Q': 
            case 'q': {
                type = 4;
            }
        }
        return type;
    }

    private String sendTheRequest(String aURLServer, int aServerPort, boolean aRecovery) throws NullParameterException, IncorrectParametersException, SocketCreationFailedException, SocketIOException, CantConnectToServerException, HostUnknownException, CommunicationErrorException, MerchantTxnNotSetException, TransactionAbortedException, UnrecoverableTransactionException, TransactionNotFoundException, ManualInterventionRequiredException, ConfigNotInitializedException, InvalidTimeoutException, InvalidURLException, InvalidRetriesException, UnsupportedCipherSuiteException, CipherSuiteRefusedByServerException, ConnectionRefusedException, CantTunnelThroughProxyException, ServerCertifNotTrustedException, HttpErrorException {
        String response;
        block18: {
            SSLComm sslComm = null;
            boolean bRet = false;
            String flRequest = null;
            String queryRequest = null;
            response = null;
            boolean bRecov = false;
            sslComm = new SSLComm();
            ServerResponse sResponse = new ServerResponse();
            EventLog.log(2, this.getMerchantTXN(this.myRequest) + "Sending request: " + this.repCardNumberAndPwdInRequestbyX(this.myRequest));
            bRet = sslComm.send(aURLServer, aServerPort, this.myRequest, aRecovery, sResponse);
            if (!bRet) {
                EventLog.log(1, this.getMerchantTXN(this.myRequest) + "Communication error. Can't get response from Payment Server.");
                if (sResponse.getFLookupFlag()) {
                    EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Using automatic recovery to find out the status of the transaction.");
                    if (this.myTypeOfOperation == 1 || this.myTypeOfOperation == 3) {
                        EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery: building a Failure lookup request.");
                        try {
                            flRequest = this.buildFLRequest();
                        }
                        catch (MerchantTxnNotSetException txn) {
                            EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery failed. failure lookup request not successfully processed");
                            throw new MerchantTxnNotSetException("  ERROR(108) The server failed to process your transaction.");
                        }
                        catch (ConfigNotInitializedException cot) {
                            EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery failed. failure lookup request not successfully processed");
                            throw new ConfigNotInitializedException();
                        }
                        EventLog.log(2, this.getMerchantTXN(this.myRequest) + "Sending the Failure lookup request: " + this.repCardNumberAndPwdInRequestbyX(flRequest));
                        try {
                            bRet = sslComm.send(aURLServer, aServerPort, flRequest, bRecov, sResponse);
                            if (bRet) {
                                EventLog.log(2, this.getMerchantTXN(this.myRequest) + "Response got from Payment Server: " + sResponse.getResponse());
                                EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery: Failure Lookup request processed by the Payment Server.");
                                if (sResponse.getResponse().indexOf("status=C") < 0) {
                                    EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery: transaction not found.");
                                    this.buildErrorResponse(sResponse.getResponse());
                                    throw new TransactionAbortedException("  ERROR(81) Transaction aborted/rejected by server. Request could not be performed.");
                                }
                            } else {
                                EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery process failed.");
                                this.buildUnrecTransResponse();
                                throw new UnrecoverableTransactionException("  ERROR(82) Server encountered internal error.Transaction unrecoverable.\nPlease check your URL. If your Url is valid, please, make a failure lookup/Query to find out the transaction status.");
                            }
                            EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery: The txnNumber of the transaction found.");
                            this.myTxnNumber = this.getValueOfParam("txnNumber", sResponse.getResponse());
                        }
                        catch (TransactionAbortedException tae) {
                            throw tae;
                        }
                        catch (Exception e2) {
                            EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery process failed.");
                            this.buildUnrecTransResponse();
                            throw new UnrecoverableTransactionException("  ERROR(82) Server encountered internal error.Transaction unrecoverable.\nPlease check your URL. If your Url is valid, please, make a failure lookup/Query to find out the transaction status.");
                        }
                    }
                    EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery: Building a Query request.");
                    queryRequest = this.buildQueryRequest();
                    bRecov = false;
                    EventLog.log(2, this.getMerchantTXN(this.myRequest) + "Sending Query request: " + this.repCardNumberAndPwdInRequestbyX(queryRequest));
                    try {
                        bRet = sslComm.send(aURLServer, aServerPort, queryRequest, bRecov, sResponse);
                        if (bRet) {
                            EventLog.log(2, this.getMerchantTXN(this.myRequest) + "Response got from Payment Server: " + sResponse.getResponse());
                            EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery process: Query request processed by the Payment Server.");
                            try {
                                response = this.buildResponse(sResponse.getResponse());
                                break block18;
                            }
                            catch (ManualInterventionRequiredException mit) {
                                throw new ManualInterventionRequiredException("  ERROR(83) Manual intervention  required to process your request.");
                            }
                            catch (TransactionNotFoundException tnf) {
                                throw new TransactionNotFoundException("  ERROR(81) Transaction aborted/rejected by server. Request could not be performed.");
                            }
                        }
                        EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery failed.");
                        throw new UnrecoverableTransactionException("  ERROR(82) Server encountered internal error.Transaction unrecoverable.\nPlease check your URL. If your Url is valid, please, make a failure lookup/Query to find out the transaction status.");
                    }
                    catch (Exception e3) {
                        EventLog.log(0, this.getMerchantTXN(this.myRequest) + "Automatic recovery failed.");
                        throw new UnrecoverableTransactionException("  ERROR(82) Server encountered internal error.Transaction unrecoverable.\nPlease check your URL. If your Url is valid, please, make a failure lookup/Query to find out the transaction status.");
                    }
                }
                throw new CommunicationErrorException("  ERROR(78) Communication error occured. Can't read the response for the TimeOut value specified in your configuration file.");
            }
            response = sResponse.getResponse();
        }
        return response;
    }

    private String buildFLRequest() throws MerchantTxnNotSetException, ConfigNotInitializedException {
        if (this.myRequest.indexOf("merchantTxn") == -1) {
            throw new MerchantTxnNotSetException();
        }
        StringBuffer flRequest = new StringBuffer("operation");
        flRequest.append(EQUAL_SIGN);
        flRequest.append("FT");
        flRequest.append(UMPERSAND_SIGN);
        flRequest.append("merchantTxn");
        flRequest.append(EQUAL_SIGN);
        flRequest.append(this.getValueOfParam("merchantTxn", this.myRequest));
        if (this.myRequest.indexOf("clientVersion") != -1) {
            flRequest.append(UMPERSAND_SIGN);
            flRequest.append("clientVersion");
            flRequest.append(EQUAL_SIGN);
            flRequest.append(this.getValueOfParam("clientVersion", this.myRequest));
        }
        flRequest.append(UMPERSAND_SIGN);
        flRequest.append("account");
        flRequest.append(EQUAL_SIGN);
        flRequest.append(this.myAccount);
        flRequest.append(UMPERSAND_SIGN);
        flRequest.append("merchantId");
        flRequest.append(EQUAL_SIGN);
        flRequest.append(this.myMerchantId);
        flRequest.append(UMPERSAND_SIGN);
        flRequest.append("merchantPwd");
        flRequest.append(EQUAL_SIGN);
        flRequest.append(this.myMerchantPwd);
        return flRequest.toString();
    }

    private String buildQueryRequest() throws ConfigNotInitializedException {
        StringBuffer queryRequest = new StringBuffer("operation");
        queryRequest.append(EQUAL_SIGN);
        queryRequest.append("Q");
        if (this.myRequest.indexOf("clientVersion") != -1) {
            queryRequest.append(UMPERSAND_SIGN);
            queryRequest.append("clientVersion");
            queryRequest.append(EQUAL_SIGN);
            queryRequest.append(this.getValueOfParam("clientVersion", this.myRequest));
        }
        if (this.myTypeOfOperation == 2) {
            if (this.myRequest.indexOf("txnNumber") != -1) {
                queryRequest.append(UMPERSAND_SIGN);
                queryRequest.append("txnNumber");
                queryRequest.append(EQUAL_SIGN);
                queryRequest.append(this.getValueOfParam("txnNumber", this.myRequest));
            }
        } else {
            queryRequest.append(UMPERSAND_SIGN);
            queryRequest.append("txnNumber");
            queryRequest.append(EQUAL_SIGN);
            queryRequest.append(this.myTxnNumber);
        }
        queryRequest.append(UMPERSAND_SIGN);
        queryRequest.append("merchantTxn");
        queryRequest.append(EQUAL_SIGN);
        queryRequest.append(this.getValueOfParam("merchantTxn", this.myRequest));
        queryRequest.append(UMPERSAND_SIGN);
        queryRequest.append("account");
        queryRequest.append(EQUAL_SIGN);
        queryRequest.append(this.myAccount);
        queryRequest.append(UMPERSAND_SIGN);
        queryRequest.append("merchantId");
        queryRequest.append(EQUAL_SIGN);
        queryRequest.append(this.myMerchantId);
        queryRequest.append(UMPERSAND_SIGN);
        queryRequest.append("merchantPwd");
        queryRequest.append(EQUAL_SIGN);
        queryRequest.append(this.myMerchantPwd);
        return queryRequest.toString();
    }

    private String buildResponse(String aQueryResponse) throws UnrecoverableTransactionException, TransactionNotFoundException, ManualInterventionRequiredException {
        StringBuffer builtResponse = null;
        if (aQueryResponse.indexOf("status=P") >= 0 || aQueryResponse.indexOf("status=C") >= 0 || aQueryResponse.indexOf("status=A") >= 0 || aQueryResponse.indexOf("status=S") >= 0) {
            String txnType = this.getValueOfParam("txnType", aQueryResponse);
            if (txnType.equals("A")) {
                builtResponse = new StringBuffer("status");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("A");
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("curAmount");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append(this.getValueOfParam("amount", this.myRequest));
            } else if (txnType.equals("P")) {
                builtResponse = new StringBuffer("status");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("SP");
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("curAmount");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("0");
            } else {
                builtResponse = new StringBuffer("status");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("SP");
            }
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("amount");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("amount", this.myRequest));
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("authCode");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("authCode", aQueryResponse));
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("authTime");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("authTime", aQueryResponse));
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("avsInfo");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("avsInfo", aQueryResponse));
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("txnNumber");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("txnNumber", aQueryResponse));
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("clientVersion");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("clientVersion", aQueryResponse));
        } else if (aQueryResponse.indexOf("status=F") >= 0 || aQueryResponse.indexOf("status=AF") >= 0 || aQueryResponse.indexOf("status=AB") >= 0 || aQueryResponse.indexOf("status=SF") >= 0) {
            builtResponse = new StringBuffer("status");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append("E");
            builtResponse.append(UMPERSAND_SIGN);
            builtResponse.append("amount");
            builtResponse.append(EQUAL_SIGN);
            builtResponse.append(this.getValueOfParam("amount", this.myRequest));
            if (this.getValueOfParam("authCode", aQueryResponse) != null) {
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("authCode");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append(this.getValueOfParam("authCode", aQueryResponse));
            }
            if (this.getValueOfParam("authTime", aQueryResponse) != null) {
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("authTime");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append(this.getValueOfParam("authTime", aQueryResponse));
            }
            if (this.getValueOfParam("avsInfo", aQueryResponse) != null) {
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("avsInfo");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append(this.getValueOfParam("avsInfo", aQueryResponse));
            }
            if (this.getValueOfParam("txnNumber", aQueryResponse) != null) {
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("txnNumber");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append(this.getValueOfParam("txnNumber", aQueryResponse));
            }
            if (this.getValueOfParam("clientVersion", aQueryResponse) != null) {
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("clientVersion");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append(this.getValueOfParam("clientVersion", aQueryResponse));
            }
        } else {
            if (aQueryResponse.indexOf("status=M") >= 0) {
                throw new ManualInterventionRequiredException();
            }
            if (aQueryResponse.indexOf("status=NF") >= 0 || aQueryResponse.indexOf("status=E") >= 0) {
                throw new TransactionNotFoundException();
            }
            if (aQueryResponse.indexOf("status=U") >= 0) {
                builtResponse = new StringBuffer("status");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("E");
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("errCode");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("131");
                builtResponse.append(UMPERSAND_SIGN);
                builtResponse.append("errString");
                builtResponse.append(EQUAL_SIGN);
                builtResponse.append("Operation not supported (131) - Please check request parameters");
                if (aQueryResponse.indexOf("clientVersion") >= 0) {
                    builtResponse.append(UMPERSAND_SIGN);
                    builtResponse.append("clientVersion");
                    builtResponse.append(EQUAL_SIGN);
                    builtResponse.append(builtResponse.append(this.getValueOfParam("clientVersion", aQueryResponse)));
                }
            }
        }
        return builtResponse.toString();
    }

    private void buildErrorResponse(String aFLResponse) {
        this.myBuiltErrResponse = new StringBuffer("status");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        this.myBuiltErrResponse.append("E");
        this.myBuiltErrResponse.append(UMPERSAND_SIGN);
        this.myBuiltErrResponse.append("amount");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        this.myBuiltErrResponse.append(this.getValueOfParam("amount", this.myRequest));
        this.myBuiltErrResponse.append(UMPERSAND_SIGN);
        this.myBuiltErrResponse.append("clientVersion");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        this.myBuiltErrResponse.append(this.getValueOfParam("clientVersion", aFLResponse).substring(0, 5));
        this.myBuiltErrResponse.append(UMPERSAND_SIGN);
        this.myBuiltErrResponse.append("errCode");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        this.myBuiltErrResponse.append("unknown");
        this.myBuiltErrResponse.append(UMPERSAND_SIGN);
        this.myBuiltErrResponse.append("errString");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        this.myBuiltErrResponse.append("unknown");
        this.myBuiltErrResponse.append(UMPERSAND_SIGN);
        this.myBuiltErrResponse.append("subError");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        this.myBuiltErrResponse.append("unknown");
        this.myBuiltErrResponse.append(UMPERSAND_SIGN);
        this.myBuiltErrResponse.append("subErrorString");
        this.myBuiltErrResponse.append(EQUAL_SIGN);
        if (this.myTypeOfOperation == 1) {
            this.myBuiltErrResponse.append("The Authorization could not be performed.");
        } else if (this.myTypeOfOperation == 2) {
            this.myBuiltErrResponse.append("The Settlement could not be performed.");
        } else {
            this.myBuiltErrResponse.append("The Purchase could not be performed.");
        }
    }

    private void buildUnrecTransResponse() {
        String val = null;
        this.myUnrecoverableResponse = new StringBuffer("status");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append("unknown");
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("authCode");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append("unknown");
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("authTime");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append("unknown");
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("avsInfo");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append("unknown");
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("curAmount");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append("unknown");
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("amount");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append(this.getValueOfParam("amount", this.myRequest));
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("txnNumber");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        val = this.getValueOfParam("txnNumber", this.myRequest);
        if (val != null) {
            this.myUnrecoverableResponse.append(val);
        } else {
            this.myUnrecoverableResponse.append("unknown");
        }
        this.myUnrecoverableResponse.append(UMPERSAND_SIGN);
        this.myUnrecoverableResponse.append("clientVersion");
        this.myUnrecoverableResponse.append(EQUAL_SIGN);
        this.myUnrecoverableResponse.append("unknown");
    }

    private String getValueOfParam(String aParam, String aRequest) {
        int idx2;
        String value = null;
        int idx1 = aRequest.indexOf(aParam);
        if (idx1 != -1 && (idx2 = aRequest.indexOf(EQUAL_SIGN, idx1)) != -1) {
            int idx3 = aRequest.indexOf(UMPERSAND_SIGN, idx2);
            value = idx3 != -1 ? aRequest.substring(idx2 + 1, idx3) : aRequest.substring(idx2 + 1);
        }
        return value;
    }

    private String repCardNumberAndPwdInRequestbyX(String aRequest) {
        StringBuffer request = null;
        int idx = aRequest.indexOf("cardNumber");
        int idx1 = aRequest.indexOf("cardExp");
        int idx2 = aRequest.indexOf("merchantPwd");
        int idx3 = 0;
        if (idx != -1 || idx1 != -1 || idx2 != -1) {
            StringBuffer request1 = null;
            StringBuffer request2 = null;
            if (idx != -1) {
                request1 = new StringBuffer(aRequest.substring(0, idx));
                request1.append("cardNumber");
                request1.append(EQUAL_SIGN);
                request1.append("XXXXXXXXXXXXX");
                idx3 = aRequest.indexOf(UMPERSAND_SIGN, idx);
                if (idx3 != -1) {
                    request1.append(aRequest.substring(idx3));
                }
            } else {
                request1 = new StringBuffer(aRequest.toString());
            }
            if (idx1 != -1) {
                idx1 = request1.toString().indexOf("cardExp");
                request2 = new StringBuffer(request1.substring(0, idx1));
                request2.append("cardExp");
                request2.append(EQUAL_SIGN);
                request2.append("MM/YY");
                idx3 = request1.toString().indexOf(UMPERSAND_SIGN, idx1);
                if (idx3 != -1) {
                    request2.append(request1.substring(idx3));
                }
            } else {
                request2 = new StringBuffer(request1.toString());
            }
            if (idx2 != -1) {
                idx2 = request2.toString().indexOf("merchantPwd");
                request = new StringBuffer(request2.substring(0, idx2));
                request.append("merchantPwd");
                request.append(EQUAL_SIGN);
                request.append("ZZZZZZZZZZZZZZZ");
                idx3 = request2.toString().indexOf(UMPERSAND_SIGN, idx2);
                if (idx3 != -1) {
                    request.append(request2.substring(idx3));
                }
            }
        } else {
            request = new StringBuffer(aRequest);
        }
        return request.toString();
    }

    private String getMerchantTXN(String aRequest) {
        StringBuffer merchantTXN = null;
        int idx_umpersand = 0;
        int idx_equal = 0;
        int idx = aRequest.indexOf("merchantTxn");
        if (idx != -1 && (idx_equal = aRequest.indexOf(EQUAL_SIGN, idx)) != -1) {
            idx_umpersand = aRequest.indexOf(UMPERSAND_SIGN, idx_equal);
            if (idx_umpersand != -1) {
                if (idx_umpersand > idx_equal + 1) {
                    merchantTXN = new StringBuffer("[merchantTxn: ");
                    merchantTXN.append(aRequest.substring(idx_equal + 1, idx_umpersand));
                    merchantTXN.append("]");
                }
            } else if (aRequest.length() > idx_equal + 1) {
                merchantTXN = new StringBuffer("[merchantTxn: ");
                merchantTXN.append(aRequest.substring(idx_equal + 1));
                merchantTXN.append("]");
            }
        }
        if (merchantTXN == null) {
            merchantTXN = new StringBuffer("[merchantTxn: unknown]");
        }
        return merchantTXN.toString();
    }

    public String getResponse() {
        return this.myResponse;
    }

    public int getStatus() {
        return this.myStatus;
    }

    public String getErrorDesc() {
        return this.myErrorDesc;
    }

    public int getErrorNumber() {
        try {
            if (this.myErrorDesc.indexOf("(") == -1 || this.myErrorDesc.indexOf(")") == -1) {
                return 0;
            }
        }
        catch (NullPointerException _ex) {
            return 0;
        }
        String str = this.myErrorDesc.substring(this.myErrorDesc.indexOf("(") + 1, this.myErrorDesc.indexOf(")"));
        return Integer.parseInt(str);
    }

    public String getMerchantId() {
        return this.myMerchantId;
    }

    public String getMerchantPwd() {
        return this.myMerchantPwd;
    }

    public String getAccount() {
        return this.myAccount;
    }

    public boolean setMerchantId(String aMerchantId) {
        boolean bRet = true;
        if (aMerchantId == null || aMerchantId.length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = "  ERROR(111) merchantId is invalid.";
            EventLog.log(1, this.myErrorDesc);
            EventLog.log(0, EXITED);
            bRet = false;
        } else {
            this.myMerchantId = aMerchantId;
        }
        return bRet;
    }

    public boolean setMerchantPwd(String aMerchantPwd) {
        boolean bRet = true;
        if (aMerchantPwd == null || aMerchantPwd.length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = "  ERROR(112) merchantPwd is invalid.";
            EventLog.log(1, this.myErrorDesc);
            EventLog.log(0, EXITED);
            bRet = false;
        } else {
            this.myMerchantPwd = aMerchantPwd;
        }
        return bRet;
    }

    public boolean setAccount(String anAccount) {
        boolean bRet = true;
        if (anAccount == null || anAccount.length() == 0) {
            this.myStatus = -2;
            this.myErrorDesc = "  ERROR(113) account is invalid.";
            EventLog.log(1, this.myErrorDesc);
            EventLog.log(0, EXITED);
            bRet = false;
        } else {
            this.myAccount = anAccount;
        }
        return bRet;
    }
}

