/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.utilities;

import com.sfcommerce.jpaymentcomponent.exceptions.HttpErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.InternalServerErrorException;
import com.sfcommerce.jpaymentcomponent.exceptions.InvalidHTTPHeaderException;
import com.sfcommerce.jpaymentcomponent.exceptions.RequestNotCompletedException;
import com.sfcommerce.jpaymentcomponent.messages.ErrorsMsg;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpResponseHeader
implements ErrorsMsg {
    public static boolean isOK(String aHttpHeader) throws RequestNotCompletedException, InternalServerErrorException, InvalidHTTPHeaderException, HttpErrorException {
        int code2 = 0;
        boolean bRet = false;
        StringTokenizer st = new StringTokenizer(aHttpHeader);
        try {
            if (!st.nextToken().startsWith("HTTP/")) {
                throw new InvalidHTTPHeaderException("  ERROR(106) Http header is invalid.");
            }
        }
        catch (NoSuchElementException nsex) {
            throw new InvalidHTTPHeaderException("  ERROR(106) Http header is invalid.");
        }
        try {
            code2 = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException nsex) {
            throw new InvalidHTTPHeaderException("  ERROR(106) Http header is invalid.");
        }
        catch (NumberFormatException nfex) {
            throw new InvalidHTTPHeaderException("  ERROR(106) Http header is invalid.");
        }
        switch (code2) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                bRet = true;
                break;
            }
            case 305: {
                throw new HttpErrorException("  ERROR(84) The requested resource must be accessed through the proxy.");
            }
            case 400: {
                throw new HttpErrorException("  ERROR(85) The request could not be processed by the server due to invalid syntax in HTTP Header.");
            }
            case 401: {
                throw new HttpErrorException("  ERROR(86) The requested resource requires user authentication,");
            }
            case 403: {
                throw new HttpErrorException("  ERROR(87) The server refuses to fulfill the request.");
            }
            case 404: {
                throw new HttpErrorException("  ERROR(88) Invalid URL.");
            }
            case 405: {
                throw new HttpErrorException("  ERROR(89) Method in HTTP Header not allowed.");
            }
            case 406: {
                throw new HttpErrorException("  ERROR(90) Conditions identified by accept not satisfied.");
            }
            case 407: {
                throw new HttpErrorException("  ERROR(91) Proxy authentication required.");
            }
            case 408: {
                throw new HttpErrorException("  ERROR(92) The server timed out waiting for the request.");
            }
            case 409: {
                throw new RequestNotCompletedException("  ERROR(93) The request could not be completed.");
            }
            case 410: {
                throw new HttpErrorException("  ERROR(94) Requested resource not available.");
            }
            case 411: {
                throw new HttpErrorException("  ERROR(95) The server refuses to accept the request without a defined content length.");
            }
            case 412: {
                throw new HttpErrorException("  ERROR(96) Condition given in unless header field incomplete.");
            }
            case 413: {
                throw new HttpErrorException("  ERROR(97) Request too large.");
            }
            case 414: {
                throw new HttpErrorException("  ERROR(98) URL Too long.");
            }
            case 415: {
                throw new HttpErrorException("  ERROR(99) Request Format unsupported.");
            }
            case 500: {
                throw new InternalServerErrorException("  ERROR(100) Server encountered internal Error that prevented it from fulfilling the request.");
            }
            case 501: {
                throw new HttpErrorException("  ERROR(101) Server does not support functionality to fulfill the Request.");
            }
            case 502: {
                throw new HttpErrorException("  ERROR(102) Server while acting as gateway/proxy received invalid response from server.");
            }
            case 503: {
                throw new HttpErrorException("  ERROR(103) Service temporarily overloaded.");
            }
            case 504: {
                throw new HttpErrorException("  ERROR(104) gateway timed out.");
            }
            case 505: {
                throw new HttpErrorException("  ERROR(106) Http header is invalid.");
            }
        }
        return bRet;
    }
}

