/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;

public abstract class MetaMethod
extends ParameterTypes
implements Cloneable {
    private String signature;
    private String mopName;

    public MetaMethod() {
    }

    public MetaMethod(Class[] pt) {
        super(pt);
    }

    public abstract int getModifiers();

    public abstract String getName();

    public abstract Class getReturnType();

    public abstract CachedClass getDeclaringClass();

    public abstract Object invoke(Object var1, Object[] var2);

    public void checkParameters(Class[] arguments) {
        if (!MetaClassHelper.isValidMethod(this.getParameterTypes(), arguments)) {
            throw new IllegalArgumentException("Parameters to method: " + this.getName() + " do not match types: " + InvokerHelper.toString(this.getParameterTypes()) + " for arguments: " + InvokerHelper.toString(arguments));
        }
    }

    public boolean isMethod(MetaMethod method) {
        return this.getName().equals(method.getName()) && this.getModifiers() == method.getModifiers() && this.getReturnType().equals(method.getReturnType()) && MetaMethod.equal(this.getParameterTypes(), method.getParameterTypes());
    }

    protected static boolean equal(CachedClass[] a2, Class[] b2) {
        if (a2.length == b2.length) {
            int size = a2.length;
            for (int i2 = 0; i2 < size; ++i2) {
                if (a2[i2].getCachedClass().equals(b2[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static boolean equal(CachedClass[] a2, CachedClass[] b2) {
        if (a2.length == b2.length) {
            int size = a2.length;
            for (int i2 = 0; i2 < size; ++i2) {
                if (a2[i2] == b2[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[name: " + this.getName() + " params: " + InvokerHelper.toString(this.getParameterTypes()) + " returns: " + this.getReturnType() + " owner: " + this.getDeclaringClass() + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new GroovyRuntimeException("This should never happen", e2);
        }
    }

    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isSame(MetaMethod method) {
        return this.getName().equals(method.getName()) && MetaMethod.compatibleModifiers(this.getModifiers(), method.getModifiers()) && this.getReturnType().equals(method.getReturnType()) && MetaMethod.equal(this.getParameterTypes(), method.getParameterTypes());
    }

    private static boolean compatibleModifiers(int modifiersA, int modifiersB) {
        int mask = 15;
        return (modifiersA & mask) == (modifiersB & mask);
    }

    public boolean isCacheable() {
        return true;
    }

    public String getDescriptor() {
        return BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
    }

    public synchronized String getSignature() {
        if (this.signature == null) {
            CachedClass[] parameters = this.getParameterTypes();
            String name = this.getName();
            StringBuffer buf = new StringBuffer(name.length() + parameters.length * 10);
            buf.append(this.getReturnType().getName());
            buf.append(' ');
            buf.append(name);
            buf.append('(');
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                buf.append(parameters[i2].getName());
            }
            buf.append(')');
            this.signature = buf.toString();
        }
        return this.signature;
    }

    public String getMopName() {
        if (this.mopName == null) {
            String name = this.getName();
            CachedClass declaringClass = this.getDeclaringClass();
            this.mopName = (this.getModifiers() & 5) == 0 ? "this$" + declaringClass.getSuperClassDistance() + "$" + name : "super$" + declaringClass.getSuperClassDistance() + "$" + name;
        }
        return this.mopName;
    }

    protected final RuntimeException processDoMethodInvokeException(Exception e2, Object object2, Object[] argumentArray) {
        if (e2 instanceof IllegalArgumentException) {
            boolean setReason = e2.getClass() != IllegalArgumentException.class;
            return MetaClassHelper.createExceptionText("failed to invoke method: ", this, object2, argumentArray, e2, setReason);
        }
        if (e2 instanceof RuntimeException) {
            return (RuntimeException)e2;
        }
        return MetaClassHelper.createExceptionText("failed to invoke method: ", this, object2, argumentArray, e2, true);
    }

    public Object doMethodInvoke(Object object2, Object[] argumentArray) {
        argumentArray = this.coerceArgumentsToClasses(argumentArray);
        try {
            return this.invoke(object2, argumentArray);
        }
        catch (Exception e2) {
            throw this.processDoMethodInvokeException(e2, object2, argumentArray);
        }
    }
}

