/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObservableMap
implements Map {
    private Map delegate;
    private PropertyChangeSupport pcs;
    private Closure test;

    public ObservableMap() {
        this(new LinkedHashMap(), null);
    }

    public ObservableMap(Closure test) {
        this(new LinkedHashMap(), test);
    }

    public ObservableMap(Map delegate) {
        this(delegate, null);
    }

    public ObservableMap(Map delegate, Closure test) {
        this.delegate = delegate;
        this.test = test;
        this.pcs = new PropertyChangeSupport(this);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Object put(Object key, Object value) {
        Object oldValue = null;
        if (this.test != null) {
            oldValue = this.delegate.put(key, value);
            Object result = null;
            result = this.test.getMaximumNumberOfParameters() == 2 ? this.test.call(new Object[]{key, value}) : this.test.call(value);
            if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue() && oldValue != value) {
                this.pcs.firePropertyChange(String.valueOf(key), oldValue, value);
            }
        } else {
            oldValue = this.delegate.put(key, value);
            if (oldValue != value) {
                this.pcs.firePropertyChange(String.valueOf(key), oldValue, value);
            }
        }
        return oldValue;
    }

    public void putAll(Map map2) {
        if (map2 != null) {
            Iterator entries = map2.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }
}

