/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.OptionGroup;
import groovyjarjarcommonscli.Options;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_ARG_NAME = "arg";
    public int defaultWidth = 74;
    public int defaultLeftPad = 1;
    public int defaultDescPad = 3;
    public String defaultSyntaxPrefix = "usage: ";
    public String defaultNewLine = System.getProperty("line.separator");
    public String defaultOptPrefix = "-";
    public String defaultLongOptPrefix = "--";
    public String defaultArgName = "arg";

    public void printHelp(String cmdLineSyntax, Options options) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, null, options, null, false);
    }

    public void printHelp(String cmdLineSyntax, Options options, boolean autoUsage) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, null, options, null, autoUsage);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, header, options, footer, autoUsage);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(width, cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        PrintWriter pw = new PrintWriter(System.out);
        this.printHelp(pw, width, cmdLineSyntax, header, options, this.defaultLeftPad, this.defaultDescPad, footer, autoUsage);
        pw.flush();
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer) throws IllegalArgumentException {
        this.printHelp(pw, width, cmdLineSyntax, header, options, leftPad, descPad, footer, false);
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) throws IllegalArgumentException {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.printUsage(pw, width, cmdLineSyntax, options);
        } else {
            this.printUsage(pw, width, cmdLineSyntax);
        }
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printUsage(PrintWriter pw, int width, String app, Options options) {
        StringBuffer buff = new StringBuffer(this.defaultSyntaxPrefix).append(app).append(" ");
        ArrayList<OptionGroup> list = new ArrayList<OptionGroup>();
        Iterator i2 = options.getOptions().iterator();
        while (i2.hasNext()) {
            Option option2 = (Option)i2.next();
            OptionGroup group = options.getOptionGroup(option2);
            if (group != null && !list.contains(group)) {
                list.add(group);
                Collection names = group.getNames();
                buff.append("[");
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    buff.append(iter.next());
                    if (!iter.hasNext()) continue;
                    buff.append(" | ");
                }
                buff.append("]");
                continue;
            }
            if (!option2.isRequired()) {
                buff.append("[");
            }
            if (!" ".equals(option2.getOpt())) {
                buff.append(DEFAULT_OPT_PREFIX).append(option2.getOpt());
            } else {
                buff.append(DEFAULT_LONG_OPT_PREFIX).append(option2.getLongOpt());
            }
            if (option2.hasArg()) {
                buff.append(" ");
            }
            if (option2.hasArg()) {
                buff.append(option2.getArgName());
            }
            if (!option2.isRequired()) {
                buff.append("]");
            }
            buff.append(" ");
        }
        this.printWrapped(pw, width, buff.toString().indexOf(32) + 1, buff.toString());
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(pw, width, this.defaultSyntaxPrefix.length() + argPos, this.defaultSyntaxPrefix + cmdLineSyntax);
    }

    public void printOptions(PrintWriter pw, int width, Options options, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, width, options, leftPad, descPad);
        pw.println(sb.toString());
    }

    public void printWrapped(PrintWriter pw, int width, String text) {
        this.printWrapped(pw, width, 0, text);
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedText(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuffer optBuf;
        Option option2;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        List optList = options.helpOptions();
        Collections.sort(optList, new StringBufferComparator());
        Iterator i2 = optList.iterator();
        while (i2.hasNext()) {
            option2 = (Option)i2.next();
            optBuf = new StringBuffer(8);
            if (option2.getOpt().equals(" ")) {
                optBuf.append(lpad).append("   " + this.defaultLongOptPrefix).append(option2.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.defaultOptPrefix).append(option2.getOpt());
                if (option2.hasLongOpt()) {
                    optBuf.append(',').append(this.defaultLongOptPrefix).append(option2.getLongOpt());
                }
            }
            if (option2.hasArg()) {
                if (option2.hasArgName()) {
                    optBuf.append(" <").append(option2.getArgName()).append('>');
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            int n = max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i3 = optList.iterator();
        while (i3.hasNext()) {
            option2 = (Option)i3.next();
            if ((optBuf = new StringBuffer(prefixList.get(x++).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.append(option2.getDescription()).toString());
            if (!i3.hasNext()) continue;
            sb.append(this.defaultNewLine);
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        int pos = this.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(this.rtrim(text));
            return sb;
        }
        sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        String padding = this.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = this.findWrapPos(text = padding + text.substring(pos).trim(), width, nextLineTabStop)) == -1) {
                sb.append(text);
                return sb;
            }
            sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        }
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c2;
        int pos = -1;
        pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width || (pos = text.indexOf(9, startPos)) != -1 && pos <= width) {
            return pos;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        pos = startPos + width;
        while (pos >= startPos && (c2 = text.charAt(pos)) != ' ' && c2 != '\n' && c2 != '\r') {
            --pos;
        }
        if (pos > startPos) {
            return pos;
        }
        pos = startPos + width;
        while (pos <= text.length() && (c2 = text.charAt(pos)) != ' ' && c2 != '\n' && c2 != '\r') {
            ++pos;
        }
        return pos == text.length() ? -1 : pos;
    }

    protected String createPadding(int len) {
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < len) {
            sb.append(' ');
            ++i2;
        }
        return sb.toString();
    }

    protected String rtrim(String s2) {
        if (s2 == null || s2.length() == 0) {
            return s2;
        }
        int pos = s2.length();
        while (pos >= 0 && Character.isWhitespace(s2.charAt(pos - 1))) {
            --pos;
        }
        return s2.substring(0, pos);
    }

    private static class StringBufferComparator
    implements Comparator {
        private StringBufferComparator() {
        }

        public int compare(Object o1, Object o2) {
            String str1 = this.stripPrefix(o1.toString());
            String str2 = this.stripPrefix(o2.toString());
            return str1.compareTo(str2);
        }

        private String stripPrefix(String strOption) {
            int iStartIndex = strOption.lastIndexOf(45);
            if (iStartIndex == -1) {
                iStartIndex = 0;
            }
            return strOption.substring(iStartIndex);
        }
    }
}

