/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRBaseTimeSeriesDataset
extends JRBaseChartDataset
implements JRTimeSeriesDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TIME_PERIOD = "timePeriod";
    private JRTimeSeries[] timeSeries = null;
    private Class timePeriod;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseTimeSeriesDataset(JRTimeSeriesDataset dataset) {
        super(dataset);
    }

    public JRBaseTimeSeriesDataset(JRTimeSeriesDataset dataset, JRBaseObjectFactory factory) {
        super(dataset, factory);
        this.timePeriod = dataset.getTimePeriod();
        JRTimeSeries[] srcTimeSeries = dataset.getSeries();
        if (srcTimeSeries != null && srcTimeSeries.length > 0) {
            this.timeSeries = new JRTimeSeries[srcTimeSeries.length];
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                this.timeSeries[i2] = factory.getTimeSeries(srcTimeSeries[i2]);
            }
        }
    }

    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    public Class getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Class timePeriod) {
        Class old = this.timePeriod;
        this.timePeriod = timePeriod;
        this.getEventSupport().firePropertyChange(PROPERTY_TIME_PERIOD, old, this.timePeriod);
    }

    public byte getDatasetType() {
        return 6;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRBaseTimeSeriesDataset clone = (JRBaseTimeSeriesDataset)super.clone();
        if (this.timeSeries != null) {
            clone.timeSeries = new JRTimeSeries[this.timeSeries.length];
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                this.timeSeries[i2] = (JRTimeSeries)this.timeSeries[i2].clone();
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseTimeSeriesDataset jRBaseTimeSeriesDataset = this;
        synchronized (jRBaseTimeSeriesDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

