/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartRendererFactory;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.renderers.BatikRenderer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SvgChartRendererFactory
implements ChartRendererFactory {
    public JRRenderable getRenderer(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D grx = new SVGGraphics2D(document);
        grx.setSVGCanvasSize(rectangle.getBounds().getSize());
        List areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            areaHyperlinks = ChartUtil.getImageAreaHyperlinks(chart, chartHyperlinkProvider, (Graphics2D)grx, rectangle);
        } else {
            chart.draw((Graphics2D)grx, rectangle);
        }
        try {
            StringWriter swriter = new StringWriter();
            grx.stream((Writer)swriter);
            return new BatikRenderer(swriter.getBuffer().toString(), areaHyperlinks);
        }
        catch (SVGGraphics2DIOException e2) {
            throw new JRRuntimeException(e2);
        }
    }
}

