/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.list.FillDatasetRun;
import net.sf.jasperreports.components.list.FillListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillList
extends BaseFillComponent {
    private static final Log log = LogFactory.getLog(FillList.class);
    private final FillListContents listContents;
    private final FillDatasetRun datasetRun;
    private Map printFrameTemplates = new HashMap();
    private JRTemplatePrintFrame printFrame;
    private boolean filling;
    private boolean fillStarted;
    private boolean overflow;

    public FillList(ListComponent component, JRFillObjectFactory factory) throws JRException {
        JRFillObjectFactory datasetFactory = new JRFillObjectFactory(factory, this.createDatasetExpressionEvaluator());
        this.listContents = new FillListContents(component.getContents(), datasetFactory);
        this.datasetRun = new FillDatasetRun(component.getDatasetRun(), factory);
    }

    private JRFillExpressionEvaluator createDatasetExpressionEvaluator() {
        return new JRFillExpressionEvaluator(){

            public Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
                return FillList.this.datasetRun.evaluateDatasetExpression(expression, evaluationType);
            }
        };
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.filling) {
            log.warn("List fill did not complete, closing previous dataset run");
            this.datasetRun.end();
        }
        this.filling = false;
        this.fillStarted = false;
        this.datasetRun.evaluate(evaluation);
    }

    public FillPrepareResult prepare(int availableHeight) {
        this.createPrintFrame();
        try {
            boolean hadData = false;
            this.overflow = false;
            if (this.filling) {
                if (log.isDebugEnabled()) {
                    log.debug("Continuing list after overflow");
                }
                hadData = true;
                this.fillContents(availableHeight);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Starting list rendering");
                }
                if (this.fillStarted) {
                    if (log.isDebugEnabled()) {
                        log.debug("List reprinted, rewinding data source");
                    }
                    this.datasetRun.rewind();
                }
                this.datasetRun.start();
                this.fillStarted = true;
            }
            while (!this.overflow && this.datasetRun.next()) {
                hadData = true;
                this.listContents.evaluateContents();
                this.fillContents(availableHeight);
            }
            if (this.overflow) {
                if (log.isDebugEnabled()) {
                    log.debug("List has overflowed");
                }
                this.filling = true;
                return FillPrepareResult.printStretch(availableHeight, this.overflow);
            }
            if (log.isDebugEnabled()) {
                log.debug("List has completed rendering");
            }
            this.filling = false;
            this.datasetRun.end();
            if (!hadData) {
                return FillPrepareResult.NO_PRINT_NO_OVERFLOW;
            }
            return FillPrepareResult.printStretch(this.printFrame.getHeight(), false);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    protected void fillContents(int availableHeight) throws JRException {
        int contentsStretchHeight = availableHeight - this.printFrame.getHeight() - this.listContents.getHeight();
        if (contentsStretchHeight < 0) {
            this.overflow = true;
        } else {
            this.listContents.prepare(contentsStretchHeight);
            this.listContents.fillElements(new AppendingPrintElementContainer(this.printFrame));
            if (this.listContents.willOverflow()) {
                this.overflow = true;
            }
        }
    }

    protected void createPrintFrame() {
        this.printFrame = new JRTemplatePrintFrame(this.getFrameTemplate());
        this.printFrame.setX(this.fillContext.getComponentElement().getX());
        this.printFrame.setWidth(this.fillContext.getComponentElement().getWidth());
    }

    protected JRTemplateFrame getFrameTemplate() {
        JRStyle style2 = this.fillContext.getElementStyle();
        JRTemplateFrame frameTemplate = (JRTemplateFrame)this.printFrameTemplates.get(style2);
        if (frameTemplate == null) {
            frameTemplate = new JRTemplateFrame(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            frameTemplate.setElement(this.fillContext.getComponentElement());
            this.printFrameTemplates.put(style2, frameTemplate);
        }
        return frameTemplate;
    }

    public JRPrintElement fill() {
        this.printFrame.setY(this.fillContext.getElementPrintY());
        return this.printFrame;
    }

    public void rewind() {
        try {
            if (this.filling) {
                this.datasetRun.end();
            }
            if (this.fillStarted) {
                if (log.isDebugEnabled()) {
                    log.debug("Rewinding started list");
                }
                this.datasetRun.rewind();
            }
            this.filling = false;
            this.fillStarted = false;
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    protected static class AppendingPrintElementContainer
    implements JRPrintElementContainer {
        private final JRPrintElementContainer container;
        private final int initialContainerHeight;

        public AppendingPrintElementContainer(JRPrintElementContainer container) {
            this.container = container;
            this.initialContainerHeight = container.getHeight();
        }

        public void addElement(JRPrintElement element) {
            element.setY(this.initialContainerHeight + element.getY());
            this.container.addElement(element);
        }

        public List getElements() {
            return this.container.getElements();
        }

        public int getHeight() {
            return 0;
        }

        public void setHeight(int height) {
            this.container.setHeight(this.initialContainerHeight + height);
        }
    }
}

