/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.list.UnusedSpaceImageRenderer;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;

public class ListDesignConverter
implements ComponentDesignConverter {
    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        ListComponent list = (ListComponent)element.getComponent();
        if (list == null || list.getContents() == null) {
            return null;
        }
        JRBasePrintFrame frame2 = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        reportConverter.copyBaseAttributes(element, frame2);
        ListContents contents = list.getContents();
        if (contents.getHeight() > 0) {
            JRBasePrintFrame contentsFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
            contentsFrame.setX(0);
            contentsFrame.setY(0);
            contentsFrame.setWidth(element.getWidth());
            contentsFrame.setHeight(contents.getHeight());
            contentsFrame.setMode((byte)2);
            List children = contents.getChildren();
            if (children != null) {
                ConvertVisitor contentsVisitor = new ConvertVisitor(reportConverter, contentsFrame);
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    JRChild child = (JRChild)it.next();
                    child.visit(contentsVisitor);
                }
            }
            frame2.addElement(contentsFrame);
            if (contents.getHeight() < element.getHeight()) {
                JRBasePrintImage image = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
                image.setX(0);
                image.setWidth(element.getWidth());
                image.setY(contents.getHeight());
                image.setHeight(element.getHeight() - contents.getHeight());
                image.setMode((byte)2);
                image.setRenderer(UnusedSpaceImageRenderer.INSTANCE);
                frame2.addElement(image);
            }
        }
        return frame2;
    }
}

