/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseDatasetParameter;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDatasetRun
implements JRDatasetRun,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String datasetName;
    protected JRExpression parametersMapExpression;
    protected JRDatasetParameter[] parameters;
    protected JRExpression connectionExpression;
    protected JRExpression dataSourceExpression;

    protected JRBaseDatasetRun() {
    }

    protected JRBaseDatasetRun(JRDatasetRun datasetRun, JRBaseObjectFactory factory) {
        factory.put(datasetRun, this);
        this.datasetName = datasetRun.getDatasetName();
        this.parametersMapExpression = factory.getExpression(datasetRun.getParametersMapExpression());
        this.connectionExpression = factory.getExpression(datasetRun.getConnectionExpression());
        this.dataSourceExpression = factory.getExpression(datasetRun.getDataSourceExpression());
        JRDatasetParameter[] datasetParams = datasetRun.getParameters();
        if (datasetParams != null && datasetParams.length > 0) {
            this.parameters = new JRBaseDatasetParameter[datasetParams.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                this.parameters[i2] = factory.getDatasetParameter(datasetParams[i2]);
            }
        }
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public Object clone() {
        JRBaseDatasetRun clone = null;
        try {
            clone = (JRBaseDatasetRun)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.parametersMapExpression != null) {
            clone.parametersMapExpression = (JRExpression)this.parametersMapExpression.clone();
        }
        if (this.connectionExpression != null) {
            clone.connectionExpression = (JRExpression)this.connectionExpression.clone();
        }
        if (this.dataSourceExpression != null) {
            clone.dataSourceExpression = (JRExpression)this.dataSourceExpression.clone();
        }
        if (this.parameters != null) {
            clone.parameters = new JRDatasetParameter[this.parameters.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                clone.parameters[i2] = (JRDatasetParameter)this.parameters[i2].clone();
            }
        }
        return clone;
    }
}

