/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRRecordedValues;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElement
implements JRElement,
JRFillCloneable,
JRStyleSetter {
    protected JRElement parent = null;
    protected Map templates = new HashMap();
    protected JRBaseFiller filler = null;
    protected JRFillExpressionEvaluator expressionEvaluator = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRGroup printWhenGroupChanges = null;
    protected JRFillElementGroup elementGroup = null;
    protected JRFillBand band = null;
    protected JROriginProvider originProvider;
    private boolean isPrintWhenExpressionNull = true;
    private boolean isPrintWhenTrue = true;
    private boolean isToPrint = true;
    private boolean isReprinted = false;
    private boolean isAlreadyPrinted = false;
    private Collection dependantElements = new ArrayList();
    private int relativeY = 0;
    private int stretchHeight = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isValueRepeating = false;
    protected byte currentEvaluation;
    protected Map delayedEvaluationsMap;
    protected JRFillElementContainer conditionalStylesContainer;
    protected JRStyle initStyle;
    protected JRStyle currentStyle;
    private boolean shrinkable;
    protected JRPropertiesMap staticProperties;
    protected JRPropertiesMap dynamicProperties;
    protected JRPropertiesMap mergedProperties;

    protected JRFillElement(JRBaseFiller filler, JRElement element, JRFillObjectFactory factory) {
        factory.put(element, this);
        this.parent = element;
        this.filler = filler;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = (JRFillElementGroup)factory.getVisitResult(element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.mergedProperties = this.staticProperties = element.hasProperties() ? element.getPropertiesMap().cloneProperties() : null;
        factory.registerDelayedStyleSetter((JRStyleSetter)this, this.parent);
    }

    protected JRFillElement(JRFillElement element, JRFillCloneFactory factory) {
        factory.put(element, this);
        this.parent = element.parent;
        this.filler = element.filler;
        this.expressionEvaluator = element.expressionEvaluator;
        this.defaultStyleProvider = element.defaultStyleProvider;
        this.originProvider = element.originProvider;
        this.printWhenGroupChanges = element.printWhenGroupChanges;
        this.elementGroup = (JRFillElementGroup)factory.getClone((JRFillElementGroup)element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.templates = element.templates;
        this.initStyle = element.initStyle;
        this.shrinkable = element.shrinkable;
        this.mergedProperties = this.staticProperties = element.staticProperties == null ? null : element.staticProperties.cloneProperties();
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public String getKey() {
        return this.parent.getKey();
    }

    public byte getPositionType() {
        return this.parent.getPositionType();
    }

    public void setPositionType(byte positionType) {
    }

    public byte getStretchType() {
        return this.parent.getStretchType();
    }

    public void setStretchType(byte stretchType) {
    }

    public boolean isPrintRepeatedValues() {
        return this.parent.isPrintRepeatedValues();
    }

    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    public Byte getOwnMode() {
        return this.parent.getOwnMode();
    }

    public void setMode(byte mode) {
    }

    public void setMode(Byte mode) {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRemoveLineWhenBlank() {
        return this.parent.isRemoveLineWhenBlank();
    }

    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
    }

    public boolean isPrintInFirstWholeBand() {
        return this.parent.isPrintInFirstWholeBand();
    }

    public void setPrintInFirstWholeBand(boolean isPrint) {
    }

    public boolean isPrintWhenDetailOverflows() {
        return this.parent.isPrintWhenDetailOverflows();
    }

    public void setPrintWhenDetailOverflows(boolean isPrint) {
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.parent.getOwnForecolor();
    }

    public void setForecolor(Color forecolor) {
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.parent.getOwnBackcolor();
    }

    public void setBackcolor(Color backcolor) {
    }

    public JRExpression getPrintWhenExpression() {
        return this.parent.getPrintWhenExpression();
    }

    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.isPrintWhenExpressionNull;
    }

    protected void setPrintWhenExpressionNull(boolean isPrintWhenExpressionNull) {
        this.isPrintWhenExpressionNull = isPrintWhenExpressionNull;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isToPrint;
    }

    protected void setToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    protected boolean isReprinted() {
        return this.isReprinted;
    }

    protected void setReprinted(boolean isReprinted) {
        this.isReprinted = isReprinted;
    }

    protected boolean isAlreadyPrinted() {
        return this.isAlreadyPrinted;
    }

    protected void setAlreadyPrinted(boolean isAlreadyPrinted) {
        this.isAlreadyPrinted = isAlreadyPrinted;
    }

    protected JRElement[] getGroupElements() {
        JRElement[] groupElements = null;
        if (this.elementGroup != null) {
            groupElements = this.elementGroup.getElements();
        }
        return groupElements;
    }

    protected Collection getDependantElements() {
        return this.dependantElements;
    }

    protected void addDependantElement(JRElement element) {
        this.dependantElements.add(element);
    }

    protected int getRelativeY() {
        return this.relativeY;
    }

    protected void setRelativeY(int relativeY) {
        this.relativeY = relativeY;
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight > this.getHeight() || this.shrinkable && this.isRemoveLineWhenBlank() ? stretchHeight : this.getHeight();
    }

    protected JRFillBand getBand() {
        return this.band;
    }

    protected void setBand(JRFillBand band) {
        this.band = band;
        if (this.originProvider == null) {
            this.setOriginProvider(band);
        }
    }

    protected void reset() {
        this.relativeY = this.y;
        this.stretchHeight = this.height;
        if (this.elementGroup != null) {
            this.elementGroup.reset();
        }
    }

    protected void setCurrentEvaluation(byte evaluation) {
        this.currentEvaluation = evaluation;
    }

    protected abstract void evaluate(byte var1) throws JRException;

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isExprNull = true;
        boolean isExprTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            isExprNull = false;
            Boolean printWhenExpressionValue = (Boolean)this.evaluateExpression(expression, evaluation);
            isExprTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenExpressionNull(isExprNull);
        this.setPrintWhenTrue(isExprTrue);
    }

    protected abstract void rewind() throws JRException;

    protected abstract JRPrintElement fill() throws JRException;

    protected JRTemplateElement getElementTemplate() {
        JRStyle style2 = this.getStyle();
        JRTemplateElement template = this.getTemplate(style2);
        if (template == null) {
            template = this.createElementTemplate();
            this.transferProperties(template);
            this.registerTemplate(style2, template);
        }
        return template;
    }

    protected abstract JRTemplateElement createElementTemplate();

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        this.setReprinted(false);
        return false;
    }

    protected void stretchElement(int bandStretch) {
        switch (this.getStretchType()) {
            case 2: {
                this.setStretchHeight(this.getHeight() + bandStretch);
                break;
            }
            case 1: {
                if (this.elementGroup == null) break;
                this.setStretchHeight(this.getHeight() + this.elementGroup.getStretchHeightDiff());
                break;
            }
        }
    }

    protected void moveDependantElements() {
        Collection elements = this.getDependantElements();
        if (elements != null && elements.size() > 0) {
            JRFillElement element = null;
            int diffY = 0;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRFillElement)it.next();
                diffY = element.getY() - this.getY() - this.getHeight() - (element.getRelativeY() - this.getRelativeY() - this.getStretchHeight());
                if (diffY < 0) {
                    diffY = 0;
                }
                element.setRelativeY(element.getRelativeY() + diffY);
            }
        }
    }

    protected abstract void resolveElement(JRPrintElement var1, byte var2) throws JRException;

    protected void performDelayedEvaluation(JRPrintElement element, byte evaluation) throws JRException {
        if (this.isDelayedStyleEvaluation()) {
            JRStyle evaluatedStyle;
            JRStyle elementStyle = this.initStyle;
            if (elementStyle == null) {
                elementStyle = this.filler.getDefaultStyle();
            }
            if (elementStyle != null && (evaluatedStyle = this.conditionalStylesContainer.evaluateConditionalStyle(elementStyle, evaluation)) != element.getStyle()) {
                this.currentStyle = evaluatedStyle;
                JRTemplateElement newTemplate = this.getElementTemplate();
                ((JRTemplatePrintElement)element).updateElementTemplate(newTemplate);
            }
        }
        this.resolveElement(element, evaluation);
        this.currentStyle = null;
    }

    public final Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.expressionEvaluator.evaluate(expression, evaluation);
    }

    protected boolean isValueRepeating() {
        return this.isValueRepeating;
    }

    protected void setValueRepeating(boolean isValueRepeating) {
        this.isValueRepeating = isValueRepeating;
    }

    protected JRFillVariable getVariable(String variableName) {
        return this.filler.getVariable(variableName);
    }

    protected JRFillField getField(String fieldName) {
        return this.filler.getField(fieldName);
    }

    protected byte getEvaluationTime() {
        return 1;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation, JREvaluationTime evaluationTime) throws JRException {
        byte evaluationTimeType = this.getEvaluationTime();
        switch (evaluationTimeType) {
            case 1: {
                break;
            }
            case 7: {
                this.delayedEvaluate((JRRecordedValuesPrintElement)element, evaluationTime, evaluation);
                break;
            }
            default: {
                this.performDelayedEvaluation(element, evaluation);
            }
        }
    }

    protected void initDelayedEvaluations() {
        if (this.getEvaluationTime() == 7 && this.delayedEvaluationsMap == null) {
            this.delayedEvaluationsMap = new HashMap();
            this.collectDelayedEvaluations();
        }
    }

    protected void collectDelayedEvaluations() {
        if (this.isDelayedStyleEvaluation()) {
            this.collectStyleDelayedEvaluations();
        }
    }

    protected void collectStyleDelayedEvaluations() {
        JRStyle elementStyle = this.initStyle;
        if (elementStyle == null) {
            elementStyle = this.filler.getDefaultStyle();
        }
        if (elementStyle != null) {
            for (JRStyle style2 = elementStyle; style2 != null; style2 = style2.getStyle()) {
                this.collectDelayedEvaluations(style2);
            }
        }
    }

    protected void collectDelayedEvaluations(JRStyle style2) {
        JRConditionalStyle[] conditionalStyles = style2.getConditionalStyles();
        if (conditionalStyles != null && conditionalStyles.length > 0) {
            for (int i2 = 0; i2 < conditionalStyles.length; ++i2) {
                this.collectDelayedEvaluations(conditionalStyles[i2].getConditionExpression());
            }
        }
    }

    protected void collectDelayedEvaluations(JRExpression expression) {
        JRExpressionChunk[] chunks;
        if (expression != null && (chunks = expression.getChunks()) != null) {
            block4: for (int i2 = 0; i2 < chunks.length; ++i2) {
                JRExpressionChunk chunk = chunks[i2];
                switch (chunk.getType()) {
                    case 3: {
                        DelayedEvaluations delayedEvaluations = this.getDelayedEvaluations(JREvaluationTime.EVALUATION_TIME_NOW);
                        delayedEvaluations.fields.add(chunk.getText());
                        continue block4;
                    }
                    case 4: {
                        JREvaluationTime time = this.autogetVariableEvaluationTime(chunk.getText());
                        DelayedEvaluations delayedEvaluations = this.getDelayedEvaluations(time);
                        delayedEvaluations.variables.add(chunk.getText());
                        continue block4;
                    }
                }
            }
        }
    }

    private DelayedEvaluations getDelayedEvaluations(JREvaluationTime time) {
        DelayedEvaluations delayedEvaluations = (DelayedEvaluations)this.delayedEvaluationsMap.get(time);
        if (delayedEvaluations == null) {
            delayedEvaluations = new DelayedEvaluations();
            this.delayedEvaluationsMap.put(time, delayedEvaluations);
        }
        return delayedEvaluations;
    }

    private JREvaluationTime autogetVariableEvaluationTime(String variableName) {
        JREvaluationTime evaluationTime;
        JRFillVariable variable = this.getVariable(variableName);
        switch (variable.getResetType()) {
            case 1: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_REPORT;
                break;
            }
            case 2: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_PAGE;
                break;
            }
            case 3: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_COLUMN;
                break;
            }
            case 4: {
                evaluationTime = JREvaluationTime.getGroupEvaluationTime(variable.getResetGroup().getName());
                break;
            }
            default: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_NOW;
            }
        }
        if (!evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW) && this.band.isNowEvaluationTime(evaluationTime)) {
            evaluationTime = JREvaluationTime.EVALUATION_TIME_NOW;
        }
        if (variable.getCalculation() == 8 && evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW) && this.band.isVariableUsedInSubreportReturns(variableName)) {
            evaluationTime = JREvaluationTime.getBandEvaluationTime(this.band);
        }
        return evaluationTime;
    }

    protected void initDelayedEvaluationPrint(JRRecordedValuesPrintElement printElement) throws JRException {
        Iterator it = this.delayedEvaluationsMap.keySet().iterator();
        while (it.hasNext()) {
            JREvaluationTime evaluationTime = (JREvaluationTime)it.next();
            if (evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW)) continue;
            this.filler.addBoundElement(this, printElement, evaluationTime);
        }
        printElement.initRecordedValues(this.delayedEvaluationsMap.keySet());
        if (this.delayedEvaluationsMap.containsKey(JREvaluationTime.EVALUATION_TIME_NOW)) {
            this.delayedEvaluate(printElement, JREvaluationTime.EVALUATION_TIME_NOW, this.currentEvaluation);
        }
    }

    protected void delayedEvaluate(JRRecordedValuesPrintElement printElement, JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        JRRecordedValues recordedValues = printElement.getRecordedValues();
        if (!recordedValues.lastEvaluationTime()) {
            DelayedEvaluations delayedEvaluations = (DelayedEvaluations)this.delayedEvaluationsMap.get(evaluationTime);
            Iterator it = delayedEvaluations.fields.iterator();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                JRFillField field = this.getField(fieldName);
                recordedValues.recordFieldValue(fieldName, field.getValue(evaluation));
            }
            it = delayedEvaluations.variables.iterator();
            while (it.hasNext()) {
                String variableName = (String)it.next();
                JRFillVariable variable = this.getVariable(variableName);
                recordedValues.recordVariableValue(variableName, variable.getValue(evaluation));
            }
        }
        recordedValues.doneEvaluation(evaluationTime);
        if (recordedValues.finishedEvaluations()) {
            this.overwriteWithRecordedValues(recordedValues, evaluation);
            this.performDelayedEvaluation(printElement, evaluation);
            this.restoreValues(recordedValues, evaluation);
            printElement.deleteRecordedValues();
        }
    }

    private void overwriteWithRecordedValues(JRRecordedValues recordedValues, byte evaluation) {
        Map variableValues;
        Map fieldValues = recordedValues.getRecordedFieldValues();
        if (fieldValues != null) {
            Iterator it = fieldValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String fieldName = (String)entry.getKey();
                Object fieldValue = entry.getValue();
                JRFillField field = this.getField(fieldName);
                field.overwriteValue(fieldValue, evaluation);
            }
        }
        if ((variableValues = recordedValues.getRecordedVariableValues()) != null) {
            Iterator it = variableValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String variableName = (String)entry.getKey();
                Object variableValue = entry.getValue();
                JRFillVariable variable = this.getVariable(variableName);
                variable.overwriteValue(variableValue, evaluation);
            }
        }
    }

    private void restoreValues(JRRecordedValues recordedValues, byte evaluation) {
        Map variableValues;
        Map fieldValues = recordedValues.getRecordedFieldValues();
        if (fieldValues != null) {
            Iterator it = fieldValues.keySet().iterator();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                JRFillField field = this.getField(fieldName);
                field.restoreValue(evaluation);
            }
        }
        if ((variableValues = recordedValues.getRecordedVariableValues()) != null) {
            Iterator it = variableValues.keySet().iterator();
            while (it.hasNext()) {
                String variableName = (String)it.next();
                JRFillVariable variable = this.getVariable(variableName);
                variable.restoreValue(evaluation);
            }
        }
    }

    protected void setConditionalStylesContainer(JRFillElementContainer conditionalStylesContainer) {
        this.conditionalStylesContainer = conditionalStylesContainer;
    }

    public JRStyle getStyle() {
        if (this.currentStyle != null) {
            return this.currentStyle;
        }
        JRStyle crtStyle = this.initStyle;
        boolean isUsingDefaultStyle = false;
        if (crtStyle == null) {
            crtStyle = this.filler.getDefaultStyle();
            isUsingDefaultStyle = true;
        }
        JRStyle evalStyle = crtStyle;
        if (this.conditionalStylesContainer != null) {
            evalStyle = this.conditionalStylesContainer.getEvaluatedConditionalStyle(crtStyle);
        }
        if (isUsingDefaultStyle && evalStyle == crtStyle) {
            evalStyle = null;
        }
        return evalStyle;
    }

    protected JRTemplateElement getTemplate(JRStyle style2) {
        return (JRTemplateElement)this.templates.get(style2);
    }

    protected void registerTemplate(JRStyle style2, JRTemplateElement template) {
        this.templates.put(style2, template);
    }

    protected final void setShrinkable(boolean shrinkable) {
        this.shrinkable = shrinkable;
    }

    protected void stretchHeightFinal() {
    }

    protected boolean isEvaluateNow() {
        boolean evaluateNow;
        switch (this.getEvaluationTime()) {
            case 1: {
                evaluateNow = true;
                break;
            }
            case 7: {
                evaluateNow = this.isAutoEvaluateNow();
                break;
            }
            default: {
                evaluateNow = false;
            }
        }
        return evaluateNow;
    }

    protected boolean isAutoEvaluateNow() {
        return this.delayedEvaluationsMap == null || this.delayedEvaluationsMap.isEmpty() || this.delayedEvaluationsMap.size() == 1 && this.delayedEvaluationsMap.containsKey(JREvaluationTime.EVALUATION_TIME_NOW);
    }

    protected boolean isEvaluateAuto() {
        return this.getEvaluationTime() == 7 && !this.isAutoEvaluateNow();
    }

    public String getStyleNameReference() {
        return null;
    }

    public void setStyle(JRStyle style2) {
        this.initStyle = style2;
        this.conditionalStylesContainer.collectConditionalStyle(style2);
    }

    public void setStyleNameReference(String name) {
        throw new UnsupportedOperationException("Style name references not allowed at fill time");
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public Object clone(JRElementGroup parentGroup) {
        throw new UnsupportedOperationException();
    }

    public boolean hasProperties() {
        return this.mergedProperties != null && this.mergedProperties.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.mergedProperties;
    }

    public JRPropertiesHolder getParentProperties() {
        return this.filler.getJasperReport();
    }

    public JRPropertyExpression[] getPropertyExpressions() {
        return this.parent.getPropertyExpressions();
    }

    protected void transferProperties(JRTemplateElement template) {
        JRProperties.transferProperties(this.parent, (JRPropertiesHolder)template, "net.sf.jasperreports.print.transfer.");
    }

    protected void transferProperties(JRPrintElement element) {
        JRProperties.transferProperties(this.dynamicProperties, (JRPropertiesHolder)element, "net.sf.jasperreports.print.transfer.");
    }

    protected JRPropertiesMap getEvaluatedProperties() {
        return this.mergedProperties;
    }

    protected void evaluateProperties(byte evaluation) throws JRException {
        JRPropertyExpression[] propExprs = this.getPropertyExpressions();
        if (propExprs == null || propExprs.length == 0) {
            this.dynamicProperties = null;
            this.mergedProperties = this.staticProperties;
        } else {
            this.dynamicProperties = new JRPropertiesMap();
            for (int i2 = 0; i2 < propExprs.length; ++i2) {
                JRPropertyExpression prop = propExprs[i2];
                String value = (String)this.evaluateExpression(prop.getValueExpression(), evaluation);
                if (value == null) continue;
                this.dynamicProperties.setProperty(prop.getName(), value);
            }
            this.mergedProperties = this.dynamicProperties.cloneProperties();
            this.mergedProperties.setBaseProperties(this.staticProperties);
        }
    }

    protected void setOriginProvider(JROriginProvider originProvider) {
        this.originProvider = originProvider;
    }

    protected JROrigin getElementOrigin() {
        JROrigin elementOrigin = null;
        if (this.originProvider != null) {
            elementOrigin = this.originProvider.getOrigin();
        }
        return elementOrigin;
    }

    protected boolean isDelayedStyleEvaluation() {
        return JRProperties.getBooleanProperty(this, "net.sf.jasperreports.style.evaluation.time.enabled", false);
    }

    private static class DelayedEvaluations
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        final Set fields = new HashSet();
        final Set variables = new HashSet();

        DelayedEvaluations() {
        }
    }
}

