/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import net.sf.jasperreports.engine.util.JEditorPaneMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JEditorPaneHtmlMarkupProcessor
extends JEditorPaneMarkupProcessor {
    private static final Log log = LogFactory.getLog(JEditorPaneHtmlMarkupProcessor.class);
    private static JEditorPaneHtmlMarkupProcessor instance = null;

    public static JEditorPaneHtmlMarkupProcessor getInstance() {
        if (instance == null) {
            instance = new JEditorPaneHtmlMarkupProcessor();
        }
        return instance;
    }

    public String convert(String srcText) {
        JEditorPane editorPane = new JEditorPane("text/html", srcText);
        editorPane.setEditable(false);
        ArrayList elements = new ArrayList();
        Document document = editorPane.getDocument();
        Element root = document.getDefaultRootElement();
        if (root != null) {
            this.addElements(elements, root);
        }
        int startOffset = 0;
        int endOffset = 0;
        int crtOffset = 0;
        String chunk = null;
        Element element = null;
        Element parent = null;
        boolean bodyOccurred = false;
        int[] orderedListIndex = new int[elements.size()];
        String whitespace = "    ";
        String[] whitespaces = new String[elements.size()];
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            whitespaces[i2] = "";
        }
        JRStyledText styledText = new JRStyledText();
        styledText.setGlobalAttributes(new HashMap());
        for (int i3 = 0; i3 < elements.size(); ++i3) {
            Object object2;
            if (bodyOccurred && chunk != null) {
                styledText.append(chunk);
                styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset + crtOffset, endOffset + crtOffset));
            }
            chunk = null;
            element = (Element)elements.get(i3);
            parent = element.getParentElement();
            startOffset = element.getStartOffset();
            endOffset = element.getEndOffset();
            AttributeSet attrs = element.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object3 = object2 = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (!(object2 instanceof HTML.Tag)) continue;
            HTML.Tag htmlTag = (HTML.Tag)object2;
            if (htmlTag == HTML.Tag.BODY) {
                bodyOccurred = true;
                crtOffset = -startOffset;
                continue;
            }
            if (htmlTag == HTML.Tag.BR) {
                chunk = "\n";
                continue;
            }
            if (htmlTag == HTML.Tag.OL) {
                orderedListIndex[i3] = 0;
                String parentName = parent.getName().toLowerCase();
                whitespaces[i3] = whitespaces[elements.indexOf(parent)] + whitespace;
                if (parentName.equals("li")) {
                    chunk = "";
                    continue;
                }
                chunk = "\n";
                continue;
            }
            if (htmlTag == HTML.Tag.UL) {
                whitespaces[i3] = whitespaces[elements.indexOf(parent)] + whitespace;
                String parentName = parent.getName().toLowerCase();
                if (parentName.equals("li")) {
                    chunk = "";
                    continue;
                }
                chunk = "\n";
                continue;
            }
            if (htmlTag == HTML.Tag.LI) {
                whitespaces[i3] = whitespaces[elements.indexOf(parent)];
                if (element.getElement(0) != null && (element.getElement(0).getName().toLowerCase().equals("ol") || element.getElement(0).getName().toLowerCase().equals("ul"))) {
                    chunk = "";
                } else if (parent.getName().equals("ol")) {
                    int index;
                    int n = index = elements.indexOf(parent);
                    int n2 = orderedListIndex[n] + 1;
                    orderedListIndex[n] = n2;
                    chunk = whitespaces[index] + String.valueOf(n2) + ".  ";
                } else {
                    chunk = whitespaces[elements.indexOf(parent)] + "\u2022  ";
                }
                crtOffset += chunk.length();
                continue;
            }
            if (!(element instanceof AbstractDocument.LeafElement)) continue;
            try {
                chunk = document.getText(startOffset, endOffset - startOffset);
                continue;
            }
            catch (BadLocationException e2) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error converting markup.", e2);
            }
        }
        if (chunk != null && !"\n".equals(chunk)) {
            styledText.append(chunk);
            styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset + crtOffset, endOffset + crtOffset));
        }
        return JRStyledTextParser.getInstance().write(styledText);
    }

    protected void addElements(List elements, Element element) {
        elements.add(element);
        for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
            Element child = element.getElement(i2);
            this.addElements(elements, child);
        }
    }

    protected Map getAttributes(AttributeSet attrSet) {
        HashMap<TextAttribute, Object> attrMap = new HashMap<TextAttribute, Object>();
        if (attrSet.isDefined(StyleConstants.FontFamily)) {
            attrMap.put(TextAttribute.FAMILY, StyleConstants.getFontFamily(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Bold)) {
            attrMap.put(TextAttribute.WEIGHT, StyleConstants.isBold(attrSet) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Italic)) {
            attrMap.put(TextAttribute.POSTURE, StyleConstants.isItalic(attrSet) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Underline)) {
            attrMap.put(TextAttribute.UNDERLINE, StyleConstants.isUnderline(attrSet) ? TextAttribute.UNDERLINE_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.StrikeThrough)) {
            attrMap.put(TextAttribute.STRIKETHROUGH, StyleConstants.isStrikeThrough(attrSet) ? TextAttribute.STRIKETHROUGH_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.FontSize)) {
            attrMap.put(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(attrSet)));
        }
        if (attrSet.isDefined(StyleConstants.Foreground)) {
            attrMap.put(TextAttribute.FOREGROUND, StyleConstants.getForeground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Background)) {
            attrMap.put(TextAttribute.BACKGROUND, StyleConstants.getBackground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Superscript) && !StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        if (attrSet.isDefined(StyleConstants.Subscript) && StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        return attrMap;
    }
}

