/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.IOException;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;

public abstract class JRXmlBaseWriter {
    protected JRXmlWriteHelper writer;

    protected void useWriter(JRXmlWriteHelper aWriter) {
        this.writer = aWriter;
    }

    protected void writeStyle(JRStyle style2) throws IOException {
        this.writer.startElement("style");
        this.writer.addEncodedAttribute("name", style2.getName());
        this.writer.addAttribute("isDefault", style2.isDefault());
        this.writeStyleReferenceAttr(style2);
        this.writer.addAttribute("mode", style2.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("forecolor", style2.getOwnForecolor());
        this.writer.addAttribute("backcolor", style2.getOwnBackcolor());
        this.writer.addAttribute("fill", style2.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.addAttribute("radius", style2.getOwnRadius());
        this.writer.addAttribute("scaleImage", style2.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", style2.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", style2.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", style2.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", style2.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("markup", style2.getOwnMarkup());
        this.writer.addEncodedAttribute("pattern", style2.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", style2.isOwnBlankWhenNull());
        this.writer.addEncodedAttribute("fontName", style2.getOwnFontName());
        this.writer.addAttribute("fontSize", style2.getOwnFontSize());
        this.writer.addAttribute("isBold", style2.isOwnBold());
        this.writer.addAttribute("isItalic", style2.isOwnItalic());
        this.writer.addAttribute("isUnderline", style2.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", style2.isOwnStrikeThrough());
        this.writer.addEncodedAttribute("pdfFontName", style2.getOwnPdfFontName());
        this.writer.addEncodedAttribute("pdfEncoding", style2.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", style2.isOwnPdfEmbedded());
        this.writePen(style2.getLinePen());
        this.writeBox(style2.getLineBox());
        if (this.toWriteConditionalStyles()) {
            JRConditionalStyle[] conditionalStyles = style2.getConditionalStyles();
            if (!(style2 instanceof JRConditionalStyle) && conditionalStyles != null) {
                for (int i2 = 0; i2 < conditionalStyles.length; ++i2) {
                    this.writeConditionalStyle(conditionalStyles[i2]);
                }
            }
        }
        this.writer.closeElement();
    }

    protected void writeStyleReferenceAttr(JRStyleContainer styleContainer) {
        if (styleContainer.getStyle() != null) {
            this.writer.addEncodedAttribute("style", styleContainer.getStyle().getName());
        } else if (styleContainer.getStyleNameReference() != null) {
            this.writer.addEncodedAttribute("style", styleContainer.getStyleNameReference());
        }
    }

    protected abstract boolean toWriteConditionalStyles();

    protected void writeConditionalStyle(JRConditionalStyle style2) throws IOException {
        this.writer.startElement("conditionalStyle");
        this.writer.writeExpression("conditionExpression", style2.getConditionExpression(), false);
        this.writeStyle(style2);
        this.writer.closeElement();
    }

    protected void writePen(JRPen pen) throws IOException {
        this.writePen("pen", pen);
    }

    private void writePen(String element, JRPen pen) throws IOException {
        this.writer.startElement(element);
        this.writer.addAttribute("lineWidth", pen.getOwnLineWidth());
        this.writer.addAttribute("lineStyle", pen.getOwnLineStyle(), JRXmlConstants.getLineStyleMap());
        this.writer.addAttribute("lineColor", pen.getOwnLineColor());
        this.writer.closeElement(true);
    }

    protected void writeBox(JRLineBox box) throws IOException {
        if (box != null) {
            this.writer.startElement("box");
            this.writer.addAttribute("padding", box.getOwnPadding());
            this.writer.addAttribute("topPadding", box.getOwnTopPadding());
            this.writer.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.writer.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.writer.addAttribute("rightPadding", box.getOwnRightPadding());
            this.writePen("pen", box.getPen());
            this.writePen("topPen", box.getTopPen());
            this.writePen("leftPen", box.getLeftPen());
            this.writePen("bottomPen", box.getBottomPen());
            this.writePen("rightPen", box.getRightPen());
            this.writer.closeElement(true);
        }
    }
}

