/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import net.sf.jasperreports.swing.JRViewerPanel;
import net.sf.jasperreports.swing.JRViewerToolbar;

public class JRViewer
extends JPanel
implements JRViewerListener {
    private static final long serialVersionUID = 10200L;
    public static final String VIEWER_RENDER_BUFFER_MAX_SIZE = "net.sf.jasperreports.viewer.render.buffer.max.size";
    protected JRViewerController viewerContext;
    protected JLabel lblStatus;
    private JRViewerPanel pnlMain;
    protected JPanel pnlStatus;
    protected JRViewerToolbar tlbToolBar;

    public JRViewer(String fileName, boolean isXML) throws JRException {
        this(fileName, isXML, null);
    }

    public JRViewer(InputStream is, boolean isXML) throws JRException {
        this(is, isXML, null);
    }

    public JRViewer(JasperPrint jrPrint) {
        this(jrPrint, null);
    }

    public JRViewer(String fileName, boolean isXML, Locale locale) throws JRException {
        this(fileName, isXML, locale, null);
    }

    public JRViewer(InputStream is, boolean isXML, Locale locale) throws JRException {
        this(is, isXML, locale, null);
    }

    public JRViewer(JasperPrint jrPrint, Locale locale) {
        this(jrPrint, locale, null);
    }

    public JRViewer(String fileName, boolean isXML, Locale locale, ResourceBundle resBundle) throws JRException {
        this.initViewerContext(locale, resBundle);
        this.initComponents();
        this.viewerContext.loadReport(fileName, isXML);
        this.tlbToolBar.init();
    }

    public JRViewer(InputStream is, boolean isXML, Locale locale, ResourceBundle resBundle) throws JRException {
        this.initViewerContext(locale, resBundle);
        this.initComponents();
        this.viewerContext.loadReport(is, isXML);
        this.tlbToolBar.init();
    }

    public JRViewer(JasperPrint jrPrint, Locale locale, ResourceBundle resBundle) {
        this.initViewerContext(locale, resBundle);
        this.initComponents();
        this.viewerContext.loadReport(jrPrint);
        this.tlbToolBar.init();
    }

    protected void initViewerContext(Locale locale, ResourceBundle resBundle) {
        this.viewerContext = new JRViewerController(locale, resBundle);
        this.setLocale(this.viewerContext.getLocale());
        this.viewerContext.addListener(this);
    }

    public void clear() {
        this.emptyContainer(this);
        this.viewerContext.clear();
    }

    protected String getBundleString(String key) {
        return this.viewerContext.getBundleString(key);
    }

    private void initComponents() {
        this.tlbToolBar = this.createToolbar();
        this.pnlMain = this.createViewerPanel();
        this.lblStatus = new JLabel();
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new FlowLayout(1, 0, 0));
        this.lblStatus.setFont(new Font("Dialog", 1, 10));
        this.lblStatus.setText("Page i of n");
        this.pnlStatus.add(this.lblStatus);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tlbToolBar, "North");
        this.add((Component)this.pnlMain, "Center");
        this.add((Component)this.pnlStatus, "South");
        KeyListener keyNavigationListener = this.pnlMain.getKeyNavigationListener();
        this.addKeyListener(keyNavigationListener);
        this.tlbToolBar.addComponentKeyListener(keyNavigationListener);
    }

    protected JRViewerToolbar createToolbar() {
        return new JRViewerToolbar(this.viewerContext);
    }

    protected JRViewerPanel createViewerPanel() {
        return new JRViewerPanel(this.viewerContext);
    }

    public void setFitWidthZoomRatio() {
        this.pnlMain.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.pnlMain.setFitPageZoomRatio();
    }

    public int getPageIndex() {
        return this.viewerContext.getPageIndex();
    }

    private void emptyContainer(Container container) {
        Component[] components = container.getComponents();
        if (components != null) {
            for (int i2 = 0; i2 < components.length; ++i2) {
                if (!(components[i2] instanceof Container)) continue;
                this.emptyContainer((Container)components[i2]);
            }
        }
        components = null;
        container.removeAll();
        container = null;
    }

    public void setZoomRatio(float zoomRatio) {
        this.viewerContext.setZoomRatio(zoomRatio);
    }

    public void pageChanged() {
        if (this.viewerContext.hasPages()) {
            this.lblStatus.setText(MessageFormat.format(this.getBundleString("page"), new Integer(this.viewerContext.getPageIndex() + 1), new Integer(this.viewerContext.getPageCount())));
        } else {
            this.lblStatus.setText("");
        }
    }

    public void viewerEvent(JRViewerEvent event) {
        switch (event.getCode()) {
            case 3: {
                this.pageChanged();
                break;
            }
            case 7: {
                JOptionPane.showMessageDialog(this, this.getBundleString("error.loading"));
            }
        }
    }
}

