/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue.output;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import net.sourceforge.barbecue.output.AbstractOutput;

public class SVGOutput
extends AbstractOutput {
    private String mUnits;
    private StringBuffer mSB;
    private final Writer writer;
    private static final String DEFAULT_FAMILY = "Arial";
    private static final int DEFAULT_SIZE = 20;

    public SVGOutput(Writer writer, Font font2, double d2, Color color, Color color2, double d3, String string) {
        super(font2, 1.0, d2, true, d3, color, color2);
        this.writer = new BufferedWriter(writer);
        this.mUnits = string;
        this.mSB = new StringBuffer();
    }

    public void beginDraw(double d2, double d3) {
        this.mSB.setLength(0);
        this.mSB.append("<svg ");
        this.mSB.append("xmlns=\"http://www.w3.org/2000/svg\" ");
        this.mSB.append("width=\"" + this.getScaledDimension(d2) + "\" ");
        this.mSB.append("height=\"" + this.getScaledDimension(d3) + "\"");
        this.mSB.append(">\n");
        try {
            this.writer.write(this.mSB.toString());
        }
        catch (IOException iOException) {
            System.err.println("IO Exception writing SVG prologue: " + iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void endDraw() {
        block8: {
            this.mSB.setLength(0);
            this.mSB.append("</svg>\n");
            this.writer.write(this.mSB.toString());
            Object var3_1 = null;
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException iOException) {
                System.err.println("IO Exception closing SVG stream: " + iOException.toString());
            }
            break block8;
            {
                catch (IOException iOException) {
                    System.err.println("IO Exception writing svg closing tag: " + iOException.toString());
                    Object var3_2 = null;
                    try {
                        this.writer.flush();
                        this.writer.close();
                    }
                    catch (IOException iOException2) {
                        System.err.println("IO Exception closing SVG stream: " + iOException2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.writer.flush();
                    this.writer.close();
                }
                catch (IOException iOException) {
                    System.err.println("IO Exception closing SVG stream: " + iOException.toString());
                }
                throw throwable;
            }
        }
    }

    public void drawBar(int n, int n2, int n3, int n4, boolean bl) {
        this.mSB.setLength(0);
        this.mSB.append(" <rect ");
        this.mSB.append("x=\"" + this.getScaledDimension(n) + "\" ");
        this.mSB.append("y=\"" + this.getScaledDimension(n2) + "\" ");
        this.mSB.append("width=\"" + this.getScaledDimension(n3) + "\" ");
        this.mSB.append("height=\"" + this.getScaledDimension(n4) + "\" ");
        this.mSB.append("style=\"fill:");
        this.mSB.append(bl ? this.getColorAsCSS(this.foregroundColour) : this.getColorAsCSS(this.backgroundColour));
        this.mSB.append(";\"");
        this.mSB.append("/>\n");
        try {
            this.writer.write(this.mSB.toString());
        }
        catch (IOException iOException) {
            System.err.println("Exception Writing Module:" + iOException.toString());
        }
    }

    public double drawText(String string, double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d3;
        d6 = d3 + this.barHeight;
        String string2 = DEFAULT_FAMILY;
        int n = 20;
        int n2 = 0;
        if (this.font != null) {
            string2 = this.font.getFamily();
            n = this.font.getSize();
            n2 = this.font.getStyle();
        }
        this.mSB.setLength(0);
        this.mSB.append(" <text ");
        this.mSB.append("x=\"" + this.getScaledDimension(d5) + "\" ");
        this.mSB.append("y=\"" + this.getScaledDimension(d6) + "\" ");
        this.mSB.append("style=\"");
        this.mSB.append("font-family: " + string2 + "; ");
        this.mSB.append("font-size: " + n + "pt; ");
        switch (n2) {
            case 0: {
                this.mSB.append("font-style: normal; ");
                break;
            }
            case 1: {
                this.mSB.append("font-weight: bold; ");
                break;
            }
            case 2: {
                this.mSB.append("font-style: italic; ");
                break;
            }
            default: {
                System.err.println("Unknown Font Style: " + this.font.getStyle());
                this.mSB.append("font-style: normal; ");
            }
        }
        this.mSB.append("\"");
        this.mSB.append(">");
        this.mSB.append(string);
        this.mSB.append("</text>\n");
        try {
            this.writer.write(this.mSB.toString());
        }
        catch (IOException iOException) {
            System.err.println("IO Exception writing text: " + iOException.toString());
        }
        return d6 - d3;
    }

    private String getScaledDimension(double d2) {
        return "" + d2 * this.scalar + this.mUnits;
    }

    private String getColorAsCSS(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        float[] fArray = color.getColorComponents(null);
        for (int j = 0; j < fArray.length; ++j) {
            String string = Integer.toHexString((int)(255.0f * fArray[j])).toUpperCase();
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

