/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.collection.PredicatedCollection;
import org.apache.commons.collections.iterators.AbstractListIteratorDecorator;

public class PredicatedList
extends PredicatedCollection
implements List {
    private static final long serialVersionUID = -5722039223898659102L;

    public static List decorate(List list, Predicate predicate) {
        return new PredicatedList(list, predicate);
    }

    protected PredicatedList(List list, Predicate predicate) {
        super(list, predicate);
    }

    protected List getList() {
        return (List)this.getCollection();
    }

    public Object get(int index) {
        return this.getList().get(index);
    }

    public int indexOf(Object object2) {
        return this.getList().indexOf(object2);
    }

    public int lastIndexOf(Object object2) {
        return this.getList().lastIndexOf(object2);
    }

    public Object remove(int index) {
        return this.getList().remove(index);
    }

    public void add(int index, Object object2) {
        this.validate(object2);
        this.getList().add(index, object2);
    }

    public boolean addAll(int index, Collection coll) {
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            this.validate(it.next());
        }
        return this.getList().addAll(index, coll);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int i2) {
        return new PredicatedListIterator(this.getList().listIterator(i2));
    }

    public Object set(int index, Object object2) {
        this.validate(object2);
        return this.getList().set(index, object2);
    }

    public List subList(int fromIndex, int toIndex) {
        List sub2 = this.getList().subList(fromIndex, toIndex);
        return new PredicatedList(sub2, this.predicate);
    }

    protected class PredicatedListIterator
    extends AbstractListIteratorDecorator {
        protected PredicatedListIterator(ListIterator iterator) {
            super(iterator);
        }

        public void add(Object object2) {
            PredicatedList.super.validate(object2);
            this.iterator.add(object2);
        }

        public void set(Object object2) {
            PredicatedList.super.validate(object2);
            this.iterator.set(object2);
        }
    }
}

