/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.AbstractInputCheckedMapDecorator;
import org.apache.commons.collections.map.LinkedMap;

public class TransformedMap
extends AbstractInputCheckedMapDecorator
implements Serializable {
    private static final long serialVersionUID = 7023152376788900464L;
    protected final Transformer keyTransformer;
    protected final Transformer valueTransformer;

    public static Map decorate(Map map2, Transformer keyTransformer, Transformer valueTransformer) {
        return new TransformedMap(map2, keyTransformer, valueTransformer);
    }

    protected TransformedMap(Map map2, Transformer keyTransformer, Transformer valueTransformer) {
        super(map2);
        this.keyTransformer = keyTransformer;
        this.valueTransformer = valueTransformer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    protected Object transformKey(Object object2) {
        if (this.keyTransformer == null) {
            return object2;
        }
        return this.keyTransformer.transform(object2);
    }

    protected Object transformValue(Object object2) {
        if (this.valueTransformer == null) {
            return object2;
        }
        return this.valueTransformer.transform(object2);
    }

    protected Map transformMap(Map map2) {
        LinkedMap result = new LinkedMap(map2.size());
        Iterator it = map2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.put(this.transformKey(entry.getKey()), this.transformValue(entry.getValue()));
        }
        return result;
    }

    protected Object checkSetValue(Object value) {
        return this.valueTransformer.transform(value);
    }

    protected boolean isSetValueChecking() {
        return this.valueTransformer != null;
    }

    public Object put(Object key, Object value) {
        key = this.transformKey(key);
        value = this.transformValue(value);
        return this.getMap().put(key, value);
    }

    public void putAll(Map mapToCopy) {
        mapToCopy = this.transformMap(mapToCopy);
        this.getMap().putAll(mapToCopy);
    }
}

