/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayInputStream;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class EmbeddedObjectRefSubRecord
extends SubRecord {
    public static final short sid = 9;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int field_1_unknown_int;
    private Ptg field_2_refPtg;
    private byte[] field_2_unknownFormulaData;
    private boolean field_3_unicode_flag;
    private String field_4_ole_classname;
    private Byte field_4_unknownByte;
    private Integer field_5_stream_id;
    private byte[] field_6_unknown;

    EmbeddedObjectRefSubRecord() {
        this.field_2_unknownFormulaData = new byte[]{2, 108, 106, 22, 1};
        this.field_6_unknown = EMPTY_BYTE_ARRAY;
        this.field_4_ole_classname = null;
    }

    public short getSid() {
        return 9;
    }

    public EmbeddedObjectRefSubRecord(RecordInputStream in) {
        int nUnexpectedPadding;
        int stringByteCount;
        short streamIdOffset = in.readShort();
        int dataLenAfterFormula = in.remaining() - streamIdOffset;
        int formulaSize = in.readUShort();
        this.field_1_unknown_int = in.readInt();
        byte[] formulaRawBytes = EmbeddedObjectRefSubRecord.readRawData(in, formulaSize);
        this.field_2_refPtg = EmbeddedObjectRefSubRecord.readRefPtg(formulaRawBytes);
        this.field_2_unknownFormulaData = (byte[])(this.field_2_refPtg == null ? formulaRawBytes : null);
        if (in.remaining() >= dataLenAfterFormula + 3) {
            byte tag = in.readByte();
            if (tag != 3) {
                throw new RecordFormatException("Expected byte 0x03 here");
            }
            int nChars = in.readUShort();
            if (nChars > 0) {
                boolean bl = this.field_3_unicode_flag = (in.readByte() & 1) != 0;
                if (this.field_3_unicode_flag) {
                    this.field_4_ole_classname = in.readUnicodeLEString(nChars);
                    stringByteCount = nChars * 2;
                } else {
                    this.field_4_ole_classname = in.readCompressedUnicode(nChars);
                    stringByteCount = nChars;
                }
            } else {
                this.field_4_ole_classname = "";
                stringByteCount = 0;
            }
        } else {
            this.field_4_ole_classname = null;
            stringByteCount = 0;
        }
        if ((stringByteCount + formulaSize) % 2 != 0) {
            byte b2 = in.readByte();
            if (this.field_2_refPtg != null && this.field_4_ole_classname == null) {
                this.field_4_unknownByte = new Byte(b2);
            }
        }
        if ((nUnexpectedPadding = in.remaining() - dataLenAfterFormula) > 0) {
            System.err.println("Discarding " + nUnexpectedPadding + " unexpected padding bytes ");
            EmbeddedObjectRefSubRecord.readRawData(in, nUnexpectedPadding);
        }
        this.field_5_stream_id = dataLenAfterFormula >= 4 ? new Integer(in.readInt()) : null;
        this.field_6_unknown = in.readRemainder();
    }

    private static Ptg readRefPtg(byte[] formulaRawBytes) {
        byte[] data = new byte[formulaRawBytes.length + 4];
        LittleEndian.putUShort(data, 0, -5555);
        LittleEndian.putUShort(data, 2, formulaRawBytes.length);
        System.arraycopy(formulaRawBytes, 0, data, 4, formulaRawBytes.length);
        RecordInputStream in = new RecordInputStream(new ByteArrayInputStream(data));
        in.nextRecord();
        byte ptgSid = in.readByte();
        switch (ptgSid) {
            case 37: {
                return new AreaPtg(in);
            }
            case 59: {
                return new Area3DPtg(in);
            }
            case 36: {
                return new RefPtg(in);
            }
            case 58: {
                return new Ref3DPtg(in);
            }
        }
        return null;
    }

    private static byte[] readRawData(RecordInputStream in, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size (" + size + ")");
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result[i2] = in.readByte();
        }
        return result;
    }

    private int getStreamIDOffset(int formulaSize) {
        int result = 6;
        result += formulaSize;
        if (this.field_4_ole_classname == null) {
            boolean stringLen = false;
        } else {
            result += 4;
            int stringLen = this.field_4_ole_classname.length();
            result = this.field_3_unicode_flag ? (result += stringLen * 2) : (result += stringLen);
        }
        if (result % 2 != 0) {
            ++result;
        }
        return result;
    }

    private int getDataSize(int idOffset) {
        int result = 2 + idOffset;
        if (this.field_5_stream_id != null) {
            result += 4;
        }
        return result + this.field_6_unknown.length;
    }

    private int getDataSize() {
        int formulaSize = this.field_2_refPtg == null ? this.field_2_unknownFormulaData.length : this.field_2_refPtg.getSize();
        int idOffset = this.getStreamIDOffset(formulaSize);
        return this.getDataSize(idOffset);
    }

    public int serialize(int base2, byte[] data) {
        int formulaSize = this.field_2_refPtg == null ? this.field_2_unknownFormulaData.length : this.field_2_refPtg.getSize();
        int idOffset = this.getStreamIDOffset(formulaSize);
        int dataSize = this.getDataSize(idOffset);
        LittleEndian.putUShort(data, base2 + 0, 9);
        LittleEndian.putUShort(data, base2 + 2, dataSize);
        LittleEndian.putUShort(data, base2 + 4, idOffset);
        LittleEndian.putUShort(data, base2 + 6, formulaSize);
        LittleEndian.putInt(data, base2 + 8, this.field_1_unknown_int);
        int pos = base2 + 12;
        if (this.field_2_refPtg == null) {
            System.arraycopy(this.field_2_unknownFormulaData, 0, data, pos, this.field_2_unknownFormulaData.length);
        } else {
            this.field_2_refPtg.writeBytes(data, pos);
        }
        pos += formulaSize;
        if (this.field_4_ole_classname == null) {
            boolean stringLen = false;
        } else {
            LittleEndian.putByte(data, pos, 3);
            int stringLen = this.field_4_ole_classname.length();
            LittleEndian.putUShort(data, ++pos, stringLen);
            LittleEndian.putByte(data, pos += 2, this.field_3_unicode_flag ? 1 : 0);
            ++pos;
            if (this.field_3_unicode_flag) {
                StringUtil.putUnicodeLE(this.field_4_ole_classname, data, pos);
                pos += stringLen * 2;
            } else {
                StringUtil.putCompressedUnicode(this.field_4_ole_classname, data, pos);
                pos += stringLen;
            }
        }
        switch (idOffset - (pos - 6 - base2)) {
            case 1: {
                LittleEndian.putByte(data, pos, this.field_4_unknownByte == null ? 0 : this.field_4_unknownByte.intValue());
                ++pos;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Bad padding calculation (" + idOffset + ", " + (pos - base2) + ")");
            }
        }
        if (this.field_5_stream_id != null) {
            LittleEndian.putInt(data, pos, this.field_5_stream_id);
            pos += 4;
        }
        System.arraycopy(this.field_6_unknown, 0, data, pos, this.field_6_unknown.length);
        return 4 + dataSize;
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public Integer getStreamId() {
        return this.field_5_stream_id;
    }

    public String getOLEClassName() {
        return this.field_4_ole_classname;
    }

    public byte[] getObjectData() {
        return this.field_6_unknown;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ftPictFmla]\n");
        sb.append("    .f2unknown     = ").append(HexDump.intToHex(this.field_1_unknown_int)).append("\n");
        if (this.field_2_refPtg == null) {
            sb.append("    .f3unknown     = ").append(HexDump.toHex(this.field_2_unknownFormulaData)).append("\n");
        } else {
            sb.append("    .formula       = ").append(this.field_2_refPtg.toString()).append("\n");
        }
        if (this.field_4_ole_classname != null) {
            sb.append("    .unicodeFlag   = ").append(this.field_3_unicode_flag).append("\n");
            sb.append("    .oleClassname  = ").append(this.field_4_ole_classname).append("\n");
        }
        if (this.field_4_unknownByte != null) {
            sb.append("    .f4unknown   = ").append(HexDump.byteToHex(this.field_4_unknownByte.intValue())).append("\n");
        }
        if (this.field_5_stream_id != null) {
            sb.append("    .streamId      = ").append(HexDump.intToHex(this.field_5_stream_id)).append("\n");
        }
        if (this.field_6_unknown.length > 0) {
            sb.append("    .f7unknown     = ").append(HexDump.toHex(this.field_6_unknown)).append("\n");
        }
        sb.append("[/ftPictFmla]");
        return sb.toString();
    }
}

