/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.LittleEndian;

public final class SupBookRecord
extends Record {
    public static final short sid = 430;
    private static final short SMALL_RECORD_SIZE = 4;
    private static final short TAG_INTERNAL_REFERENCES = 1025;
    private static final short TAG_ADD_IN_FUNCTIONS = 14849;
    private short field_1_number_of_sheets;
    private UnicodeString field_2_encoded_url;
    private UnicodeString[] field_3_sheet_names;
    private boolean _isAddInFunctions;

    public static SupBookRecord createInternalReferences(short numberOfSheets) {
        return new SupBookRecord(false, numberOfSheets);
    }

    public static SupBookRecord createAddInFunctions() {
        return new SupBookRecord(true, 0);
    }

    public static SupBookRecord createExternalReferences(UnicodeString url, UnicodeString[] sheetNames) {
        return new SupBookRecord(url, sheetNames);
    }

    private SupBookRecord(boolean isAddInFuncs, short numberOfSheets) {
        this.field_1_number_of_sheets = numberOfSheets;
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        this._isAddInFunctions = isAddInFuncs;
    }

    public SupBookRecord(UnicodeString url, UnicodeString[] sheetNames) {
        this.field_1_number_of_sheets = (short)sheetNames.length;
        this.field_2_encoded_url = url;
        this.field_3_sheet_names = sheetNames;
        this._isAddInFunctions = false;
    }

    public boolean isExternalReferences() {
        return this.field_3_sheet_names != null;
    }

    public boolean isInternalReferences() {
        return this.field_3_sheet_names == null && !this._isAddInFunctions;
    }

    public boolean isAddInFunctions() {
        return this.field_3_sheet_names == null && this._isAddInFunctions;
    }

    public SupBookRecord(RecordInputStream in) {
        this.field_1_number_of_sheets = in.readShort();
        if (in.getLength() > 4) {
            this._isAddInFunctions = false;
            this.field_2_encoded_url = in.readUnicodeString();
            UnicodeString[] sheetNames = new UnicodeString[this.field_1_number_of_sheets];
            for (int i2 = 0; i2 < sheetNames.length; ++i2) {
                sheetNames[i2] = in.readUnicodeString();
            }
            this.field_3_sheet_names = sheetNames;
            return;
        }
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        short nextShort = in.readShort();
        if (nextShort == 1025) {
            this._isAddInFunctions = false;
        } else if (nextShort == 14849) {
            this._isAddInFunctions = true;
            if (this.field_1_number_of_sheets != 1) {
                throw new RuntimeException("Expected 0x0001 for number of sheets field in 'Add-In Functions' but got (" + this.field_1_number_of_sheets + ")");
            }
        } else {
            throw new RuntimeException("invalid EXTERNALBOOK code (" + Integer.toHexString(nextShort) + ")");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [SUPBOOK ");
        if (this.isExternalReferences()) {
            sb.append("External References");
            sb.append(" nSheets=").append(this.field_1_number_of_sheets);
            sb.append(" url=").append(this.field_2_encoded_url);
        } else if (this._isAddInFunctions) {
            sb.append("Add-In Functions");
        } else {
            sb.append("Internal References ");
            sb.append(" nSheets= ").append(this.field_1_number_of_sheets);
        }
        sb.append("]");
        return sb.toString();
    }

    private int getDataSize() {
        if (!this.isExternalReferences()) {
            return 4;
        }
        int sum = 2;
        UnicodeString.UnicodeRecordStats urs = new UnicodeString.UnicodeRecordStats();
        this.field_2_encoded_url.getRecordSize(urs);
        sum += urs.recordSize;
        for (int i2 = 0; i2 < this.field_3_sheet_names.length; ++i2) {
            urs = new UnicodeString.UnicodeRecordStats();
            this.field_3_sheet_names[i2].getRecordSize(urs);
            sum += urs.recordSize;
        }
        return sum;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)430);
        int dataSize = this.getDataSize();
        LittleEndian.putShort(data, 2 + offset, (short)dataSize);
        LittleEndian.putShort(data, 4 + offset, this.field_1_number_of_sheets);
        if (this.isExternalReferences()) {
            int currentOffset = 6 + offset;
            UnicodeString.UnicodeRecordStats urs = new UnicodeString.UnicodeRecordStats();
            this.field_2_encoded_url.serialize(urs, currentOffset, data);
            currentOffset += urs.recordSize;
            for (int i2 = 0; i2 < this.field_3_sheet_names.length; ++i2) {
                urs = new UnicodeString.UnicodeRecordStats();
                this.field_3_sheet_names[i2].serialize(urs, currentOffset, data);
                currentOffset += urs.recordSize;
            }
        } else {
            short field2val = this._isAddInFunctions ? (short)14849 : 1025;
            LittleEndian.putShort(data, 6 + offset, field2val);
        }
        return dataSize + 4;
    }

    public void setNumberOfSheets(short number) {
        this.field_1_number_of_sheets = number;
    }

    public short getNumberOfSheets() {
        return this.field_1_number_of_sheets;
    }

    public int getRecordSize() {
        return this.getDataSize() + 4;
    }

    public short getSid() {
        return 430;
    }

    public String getURL() {
        String encodedUrl = this.field_2_encoded_url.getString();
        switch (encodedUrl.charAt(0)) {
            case '\u0000': {
                return encodedUrl.substring(1);
            }
            case '\u0001': {
                return SupBookRecord.decodeFileName(encodedUrl);
            }
            case '\u0002': {
                return encodedUrl.substring(1);
            }
        }
        return encodedUrl;
    }

    private static String decodeFileName(String encodedUrl) {
        return encodedUrl.substring(1);
    }

    public UnicodeString[] getSheetNames() {
        return (UnicodeString[])this.field_3_sheet_names.clone();
    }
}

