/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;

public abstract class AbstractFunctionPtg
extends OperationPtg {
    public static final String FUNCTION_NAME_IF = "IF";
    private static final short FUNCTION_INDEX_EXTERNAL = 255;
    protected byte returnClass;
    protected byte[] paramClass;
    protected byte field_1_num_args;
    protected short field_2_fnc_index;

    public final boolean isBaseToken() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.field_2_fnc_index).append(" ").append(this.field_1_num_args);
        sb.append("]");
        return sb.toString();
    }

    public short getFunctionIndex() {
        return this.field_2_fnc_index;
    }

    public String getName() {
        return this.lookupName(this.field_2_fnc_index);
    }

    public boolean isExternalFunction() {
        return this.field_2_fnc_index == 255;
    }

    public String toFormulaString() {
        return this.getName();
    }

    public String toFormulaString(String[] operands) {
        StringBuffer buf = new StringBuffer();
        if (this.isExternalFunction()) {
            buf.append(operands[0]);
            AbstractFunctionPtg.appendArgs(buf, 1, operands);
        } else {
            buf.append(this.getName());
            AbstractFunctionPtg.appendArgs(buf, 0, operands);
        }
        return buf.toString();
    }

    private static void appendArgs(StringBuffer buf, int firstArgIx, String[] operands) {
        buf.append('(');
        for (int i2 = firstArgIx; i2 < operands.length; ++i2) {
            if (i2 > firstArgIx) {
                buf.append(',');
            }
            buf.append(operands[i2]);
        }
        buf.append(")");
    }

    public abstract void writeBytes(byte[] var1, int var2);

    public abstract int getSize();

    public static final boolean isBuiltInFunctionName(String name) {
        short ix = FunctionMetadataRegistry.lookupIndexByName(name.toUpperCase());
        return ix >= 0;
    }

    protected String lookupName(short index) {
        if (index == 255) {
            return "#external#";
        }
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByIndex(index);
        if (fm == null) {
            throw new RuntimeException("bad function index (" + index + ")");
        }
        return fm.getName();
    }

    protected static short lookupIndex(String name) {
        short ix = FunctionMetadataRegistry.lookupIndexByName(name.toUpperCase());
        if (ix < 0) {
            return 255;
        }
        return ix;
    }

    public byte getDefaultOperandClass() {
        return this.returnClass;
    }

    public byte getParameterClass(int index) {
        if (index >= this.paramClass.length) {
            return this.paramClass[this.paramClass.length - 1];
        }
        return this.paramClass[index];
    }
}

