/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

public final class MathX {
    private MathX() {
    }

    public static double round(double n, int p2) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p2 != 0) {
            double temp = Math.pow(10.0, p2);
            retval = (double)Math.round(n * temp) / temp;
        } else {
            retval = Math.round(n);
        }
        return retval;
    }

    public static double roundUp(double n, int p2) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p2 != 0) {
            double temp = Math.pow(10.0, p2);
            double nat = Math.abs(n * temp);
            retval = (double)MathX.sign(n) * (nat == (double)((long)nat) ? nat / temp : (double)Math.round(nat + 0.5) / temp);
        } else {
            double na = Math.abs(n);
            retval = (double)MathX.sign(n) * (na == (double)((long)na) ? na : (double)((long)na + 1L));
        }
        return retval;
    }

    public static double roundDown(double n, int p2) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p2 != 0) {
            double temp = Math.pow(10.0, p2);
            retval = (double)((long)MathX.sign(n) * Math.round(Math.abs(n) * temp - 0.5)) / temp;
        } else {
            retval = (long)n;
        }
        return retval;
    }

    public static short sign(double d2) {
        return (short)(d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1));
    }

    public static double average(double[] values) {
        double ave = 0.0;
        double sum = 0.0;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            sum += values[i2];
        }
        ave = sum / (double)values.length;
        return ave;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            sum += values[i2];
        }
        return sum;
    }

    public static double sumsq(double[] values) {
        double sumsq = 0.0;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            sumsq += values[i2] * values[i2];
        }
        return sumsq;
    }

    public static double product(double[] values) {
        double product = 0.0;
        if (values != null && values.length > 0) {
            product = 1.0;
            int iSize = values.length;
            for (int i2 = 0; i2 < iSize; ++i2) {
                product *= values[i2];
            }
        }
        return product;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            min = Math.min(min, values[i2]);
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            max = Math.max(max, values[i2]);
        }
        return max;
    }

    public static double floor(double n, double s2) {
        double f2 = n < 0.0 && s2 > 0.0 || n > 0.0 && s2 < 0.0 || s2 == 0.0 && n != 0.0 ? Double.NaN : (n == 0.0 || s2 == 0.0 ? 0.0 : Math.floor(n / s2) * s2);
        return f2;
    }

    public static double ceiling(double n, double s2) {
        double c2 = n < 0.0 && s2 > 0.0 || n > 0.0 && s2 < 0.0 ? Double.NaN : (n == 0.0 || s2 == 0.0 ? 0.0 : Math.ceil(n / s2) * s2);
        return c2;
    }

    public static double factorial(int n) {
        double d2 = 1.0;
        if (n >= 0) {
            if (n <= 170) {
                for (int i2 = 1; i2 <= n; ++i2) {
                    d2 *= (double)i2;
                }
            } else {
                d2 = Double.POSITIVE_INFINITY;
            }
        } else {
            d2 = Double.NaN;
        }
        return d2;
    }

    public static double mod(double n, double d2) {
        double result = 0.0;
        if (d2 == 0.0) {
            result = Double.NaN;
        } else if (MathX.sign(n) == MathX.sign(d2)) {
            double t = Math.abs(n / d2);
            t -= (double)((long)t);
            result = (double)MathX.sign(d2) * Math.abs(t * d2);
        } else {
            double t = Math.abs(n / d2);
            t -= (double)((long)t);
            t = Math.ceil(t) - t;
            result = (double)MathX.sign(d2) * Math.abs(t * d2);
        }
        return result;
    }

    public static double acosh(double d2) {
        return Math.log(Math.sqrt(Math.pow(d2, 2.0) - 1.0) + d2);
    }

    public static double asinh(double d2) {
        double d22 = d2 * d2;
        return Math.log(Math.sqrt(d2 * d2 + 1.0) + d2);
    }

    public static double atanh(double d2) {
        return Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
    }

    public static double cosh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        d2 = (ePowX + ePowNegX) / 2.0;
        return d2;
    }

    public static double sinh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        d2 = (ePowX - ePowNegX) / 2.0;
        return d2;
    }

    public static double tanh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        d2 = (ePowX - ePowNegX) / (ePowX + ePowNegX);
        return d2;
    }

    public static double sumproduct(double[][] arrays) {
        double d2 = 0.0;
        try {
            int narr = arrays.length;
            int arrlen = arrays[0].length;
            for (int j = 0; j < arrlen; ++j) {
                double t = 1.0;
                for (int i2 = 0; i2 < narr; ++i2) {
                    t *= arrays[i2][j];
                }
                d2 += t;
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            d2 = Double.NaN;
        }
        return d2;
    }

    public static double nChooseK(int n, int k) {
        double d2 = 1.0;
        if (n < 0 || k < 0 || n < k) {
            d2 = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n - k, k);
            for (int i2 = maxnk = Math.max(n - k, k); i2 < n; ++i2) {
                d2 *= (double)(i2 + 1);
            }
            d2 /= MathX.factorial(minnk);
        }
        return d2;
    }
}

