/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Offset
implements Function {
    private static final int LAST_VALID_ROW_INDEX = 65535;
    private static final int LAST_VALID_COLUMN_INDEX = 255;

    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        if (args.length < 3 || args.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            BaseRef baseRef = Offset.evaluateBaseRef(args[0]);
            int rowOffset = Offset.evaluateIntArg(args[1], srcCellRow, srcCellCol);
            int columnOffset = Offset.evaluateIntArg(args[2], srcCellRow, srcCellCol);
            int height = baseRef.getHeight();
            int width = baseRef.getWidth();
            switch (args.length) {
                case 5: {
                    width = Offset.evaluateIntArg(args[4], srcCellRow, srcCellCol);
                }
                case 4: {
                    height = Offset.evaluateIntArg(args[3], srcCellRow, srcCellCol);
                }
            }
            if (height == 0 || width == 0) {
                return ErrorEval.REF_INVALID;
            }
            LinearOffsetRange rowOffsetRange = new LinearOffsetRange(rowOffset, height);
            LinearOffsetRange colOffsetRange = new LinearOffsetRange(columnOffset, width);
            return Offset.createOffset(baseRef, rowOffsetRange, colOffsetRange);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
    }

    private static AreaEval createOffset(BaseRef baseRef, LinearOffsetRange orRow, LinearOffsetRange orCol) throws EvaluationException {
        LinearOffsetRange absRows = orRow.normaliseAndTranslate(baseRef.getFirstRowIndex());
        LinearOffsetRange absCols = orCol.normaliseAndTranslate(baseRef.getFirstColumnIndex());
        if (absRows.isOutOfBounds(0, 65535)) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        if (absCols.isOutOfBounds(0, 255)) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        return baseRef.offset(orRow.getFirstIndex(), orRow.getLastIndex(), orCol.getFirstIndex(), orCol.getLastIndex());
    }

    private static BaseRef evaluateBaseRef(Eval eval) throws EvaluationException {
        if (eval instanceof RefEval) {
            return new BaseRef((RefEval)eval);
        }
        if (eval instanceof AreaEval) {
            return new BaseRef((AreaEval)eval);
        }
        if (eval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)eval);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    private static int evaluateIntArg(Eval eval, int srcCellRow, short srcCellCol) throws EvaluationException {
        double d2 = Offset.evaluateDoubleArg(eval, srcCellRow, srcCellCol);
        return Offset.convertDoubleToInt(d2);
    }

    static int convertDoubleToInt(double d2) {
        return (int)Math.floor(d2);
    }

    private static double evaluateDoubleArg(Eval eval, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(eval, srcCellRow, srcCellCol);
        if (ve instanceof NumericValueEval) {
            return ((NumericValueEval)ve).getNumberValue();
        }
        if (ve instanceof StringEval) {
            StringEval se = (StringEval)ve;
            Double d2 = OperandResolver.parseDouble(se.getStringValue());
            if (d2 == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return d2;
        }
        if (ve instanceof BoolEval) {
            if (((BoolEval)ve).getBooleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        throw new RuntimeException("Unexpected eval type (" + ve.getClass().getName() + ")");
    }

    private static final class BaseRef {
        private final int _firstRowIndex;
        private final int _firstColumnIndex;
        private final int _width;
        private final int _height;
        private final RefEval _refEval;
        private final AreaEval _areaEval;

        public BaseRef(RefEval re) {
            this._refEval = re;
            this._areaEval = null;
            this._firstRowIndex = re.getRow();
            this._firstColumnIndex = re.getColumn();
            this._height = 1;
            this._width = 1;
        }

        public BaseRef(AreaEval ae) {
            this._refEval = null;
            this._areaEval = ae;
            this._firstRowIndex = ae.getFirstRow();
            this._firstColumnIndex = ae.getFirstColumn();
            this._height = ae.getLastRow() - ae.getFirstRow() + 1;
            this._width = ae.getLastColumn() - ae.getFirstColumn() + 1;
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }

        public int getFirstRowIndex() {
            return this._firstRowIndex;
        }

        public int getFirstColumnIndex() {
            return this._firstColumnIndex;
        }

        public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
            if (this._refEval == null) {
                return this._areaEval.offset(relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
            }
            return this._refEval.offset(relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        }
    }

    static final class LinearOffsetRange {
        private final int _offset;
        private final int _length;

        public LinearOffsetRange(int offset, int length) {
            if (length == 0) {
                throw new RuntimeException("length may not be zero");
            }
            this._offset = offset;
            this._length = length;
        }

        public short getFirstIndex() {
            return (short)this._offset;
        }

        public short getLastIndex() {
            return (short)(this._offset + this._length - 1);
        }

        public LinearOffsetRange normaliseAndTranslate(int translationAmount) {
            if (this._length > 0) {
                if (translationAmount == 0) {
                    return this;
                }
                return new LinearOffsetRange(translationAmount + this._offset, this._length);
            }
            return new LinearOffsetRange(translationAmount + this._offset + this._length + 1, -this._length);
        }

        public boolean isOutOfBounds(int lowValidIx, int highValidIx) {
            if (this._offset < lowValidIx) {
                return true;
            }
            return this.getLastIndex() > highValidIx;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this._offset).append("...").append(this.getLastIndex());
            sb.append("]");
            return sb.toString();
        }
    }
}

