/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.formula.EvaluationCache;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.WorkbookEvaluator;

public final class CollaboratingWorkbooksEnvironment {
    public static final CollaboratingWorkbooksEnvironment EMPTY = new CollaboratingWorkbooksEnvironment();
    private final Map _evaluatorsByName;
    private final WorkbookEvaluator[] _evaluators;
    private boolean _unhooked;

    private CollaboratingWorkbooksEnvironment() {
        this._evaluatorsByName = Collections.EMPTY_MAP;
        this._evaluators = new WorkbookEvaluator[0];
    }

    public static void setup(String[] workbookNames, WorkbookEvaluator[] evaluators) {
        int nItems = workbookNames.length;
        if (evaluators.length != nItems) {
            throw new IllegalArgumentException("Number of workbook names is " + nItems + " but number of evaluators is " + evaluators.length);
        }
        if (nItems < 1) {
            throw new IllegalArgumentException("Must provide at least one collaborating worbook");
        }
        new CollaboratingWorkbooksEnvironment(workbookNames, evaluators, nItems);
    }

    private CollaboratingWorkbooksEnvironment(String[] workbookNames, WorkbookEvaluator[] evaluators, int nItems) {
        HashMap<String, WorkbookEvaluator> m = new HashMap<String, WorkbookEvaluator>(nItems * 3 / 2);
        IdentityHashMap<WorkbookEvaluator, String> uniqueEvals = new IdentityHashMap<WorkbookEvaluator, String>(nItems * 3 / 2);
        for (int i2 = 0; i2 < nItems; ++i2) {
            String wbName = workbookNames[i2];
            WorkbookEvaluator wbEval = evaluators[i2];
            if (m.containsKey(wbName)) {
                throw new IllegalArgumentException("Duplicate workbook name '" + wbName + "'");
            }
            if (uniqueEvals.containsKey(wbEval)) {
                String msg = "Attempted to register same workbook under names '" + uniqueEvals.get(wbEval) + "' and '" + wbName + "'";
                throw new IllegalArgumentException(msg);
            }
            uniqueEvals.put(wbEval, wbName);
            m.put(wbName, wbEval);
        }
        this.unhookOldEnvironments(evaluators);
        CollaboratingWorkbooksEnvironment.hookNewEnvironment(evaluators, this);
        this._unhooked = false;
        this._evaluators = evaluators;
        this._evaluatorsByName = m;
    }

    private static void hookNewEnvironment(WorkbookEvaluator[] evaluators, CollaboratingWorkbooksEnvironment env) {
        int nItems = evaluators.length;
        IEvaluationListener evalListener = evaluators[0].getEvaluationListener();
        for (int i2 = 0; i2 < nItems; ++i2) {
            if (evalListener == evaluators[i2].getEvaluationListener()) continue;
            throw new RuntimeException("Workbook evaluators must all have the same evaluation listener");
        }
        EvaluationCache cache = new EvaluationCache(evalListener);
        for (int i3 = 0; i3 < nItems; ++i3) {
            evaluators[i3].attachToEnvironment(env, cache, i3);
        }
    }

    private void unhookOldEnvironments(WorkbookEvaluator[] evaluators) {
        HashSet<CollaboratingWorkbooksEnvironment> oldEnvs = new HashSet<CollaboratingWorkbooksEnvironment>();
        for (int i2 = 0; i2 < evaluators.length; ++i2) {
            oldEnvs.add(evaluators[i2].getEnvironment());
        }
        CollaboratingWorkbooksEnvironment[] oldCWEs = new CollaboratingWorkbooksEnvironment[oldEnvs.size()];
        oldEnvs.toArray(oldCWEs);
        for (int i3 = 0; i3 < oldCWEs.length; ++i3) {
            oldCWEs[i3].unhook();
        }
    }

    private void unhook() {
        if (this._evaluators.length < 1) {
            return;
        }
        for (int i2 = 0; i2 < this._evaluators.length; ++i2) {
            this._evaluators[i2].detachFromEnvironment();
        }
        this._unhooked = true;
    }

    public WorkbookEvaluator getWorkbookEvaluator(String workbookName) {
        if (this._unhooked) {
            throw new IllegalStateException("This environment has been unhooked");
        }
        WorkbookEvaluator result = (WorkbookEvaluator)this._evaluatorsByName.get(workbookName);
        if (result == null) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Could not resolve external workbook name '").append(workbookName).append("'.");
            if (this._evaluators.length < 1) {
                sb.append(" Workbook environment has not been set up.");
            } else {
                sb.append(" The following workbook names are valid: (");
                Iterator i2 = this._evaluatorsByName.keySet().iterator();
                int count = 0;
                while (i2.hasNext()) {
                    if (count++ > 0) {
                        sb.append(", ");
                    }
                    sb.append("'").append(i2.next()).append("'");
                }
                sb.append(")");
            }
            throw new RuntimeException(sb.toString());
        }
        return result;
    }
}

