/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.control.ParserPluginFactory;
import org.codehaus.groovy.control.io.NullWriter;

public class CompilerConfiguration {
    private static final String JDK5_CLASSNAME_CHECK = "java.lang.annotation.Annotation";
    public static final String POST_JDK5 = "1.5";
    public static final String PRE_JDK5 = "1.4";
    public static final String currentJVMVersion = CompilerConfiguration.getVMVersion();
    public static final CompilerConfiguration DEFAULT = new CompilerConfiguration();
    private int warningLevel;
    private String sourceEncoding;
    private PrintWriter output;
    private File targetDirectory;
    private LinkedList classpath;
    private boolean verbose;
    private boolean debug;
    private int tolerance;
    private String scriptBaseClass;
    private ParserPluginFactory pluginFactory;
    private String defaultScriptExtension;
    private boolean recompileGroovySource;
    private int minimumRecompilationInterval;
    private String targetBytecode;
    private Map jointCompilationOptions;

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setOutput(null);
        this.setTargetDirectory((File)null);
        this.setClasspath("");
        this.setVerbose(false);
        this.setDebug(false);
        this.setTolerance(10);
        this.setScriptBaseClass(null);
        this.setRecompileGroovySource(false);
        this.setMinimumRecompilationInterval(100);
        this.setTargetBytecode(CompilerConfiguration.getVMVersion());
        this.setDefaultScriptExtension(".groovy");
        String encoding = null;
        try {
            encoding = System.getProperty("file.encoding", "US-ASCII");
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            encoding = System.getProperty("groovy.source.encoding", encoding);
        }
        catch (Exception e3) {
            // empty catch block
        }
        this.setSourceEncoding(encoding);
        try {
            this.setOutput(new PrintWriter(System.err));
        }
        catch (Exception e4) {
            // empty catch block
        }
        try {
            String target = System.getProperty("groovy.target.directory");
            if (target != null) {
                this.setTargetDirectory(target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CompilerConfiguration(CompilerConfiguration configuration) {
        this.setWarningLevel(configuration.getWarningLevel());
        this.setOutput(configuration.getOutput());
        this.setTargetDirectory(configuration.getTargetDirectory());
        this.setClasspathList(new LinkedList(configuration.getClasspath()));
        this.setVerbose(configuration.getVerbose());
        this.setDebug(configuration.getDebug());
        this.setTolerance(configuration.getTolerance());
        this.setScriptBaseClass(configuration.getScriptBaseClass());
        this.setRecompileGroovySource(configuration.getRecompileGroovySource());
        this.setMinimumRecompilationInterval(configuration.getMinimumRecompilationInterval());
        this.setTargetBytecode(configuration.getTargetBytecode());
        this.setDefaultScriptExtension(configuration.getDefaultScriptExtension());
        this.setSourceEncoding(configuration.getSourceEncoding());
        this.setOutput(configuration.getOutput());
        this.setTargetDirectory(configuration.getTargetDirectory());
        HashMap jointCompilationOptions = configuration.getJointCompilationOptions();
        if (jointCompilationOptions != null) {
            jointCompilationOptions = new HashMap(jointCompilationOptions);
        }
        this.setJointCompilationOptions(jointCompilationOptions);
        this.setPluginFactory(configuration.getPluginFactory());
    }

    public CompilerConfiguration(Properties configuration) throws ConfigurationException {
        this();
        this.configure(configuration);
    }

    public void configure(Properties configuration) throws ConfigurationException {
        String text = null;
        int numeric = 0;
        numeric = this.getWarningLevel();
        try {
            text = configuration.getProperty("groovy.warnings", "likely errors");
            numeric = Integer.parseInt(text);
        }
        catch (NumberFormatException e2) {
            text = text.toLowerCase();
            if (text.equals("none")) {
                numeric = 0;
            }
            if (text.startsWith("likely")) {
                numeric = 1;
            }
            if (text.startsWith("possible")) {
                numeric = 2;
            }
            if (text.startsWith("paranoia")) {
                numeric = 3;
            }
            throw new ConfigurationException("unrecogized groovy.warnings: " + text);
        }
        this.setWarningLevel(numeric);
        text = configuration.getProperty("groovy.source.encoding");
        if (text != null) {
            this.setSourceEncoding(text);
        }
        if ((text = configuration.getProperty("groovy.target.directory")) != null) {
            this.setTargetDirectory(text);
        }
        if ((text = configuration.getProperty("groovy.target.bytecode")) != null) {
            this.setTargetBytecode(text);
        }
        if ((text = configuration.getProperty("groovy.classpath")) != null) {
            this.setClasspath(text);
        }
        if ((text = configuration.getProperty("groovy.output.verbose")) != null && text.equalsIgnoreCase("true")) {
            this.setVerbose(true);
        }
        if ((text = configuration.getProperty("groovy.output.debug")) != null && text.equalsIgnoreCase("true")) {
            this.setDebug(true);
        }
        numeric = 10;
        try {
            text = configuration.getProperty("groovy.errors.tolerance", "10");
            numeric = Integer.parseInt(text);
        }
        catch (NumberFormatException e3) {
            throw new ConfigurationException(e3);
        }
        this.setTolerance(numeric);
        text = configuration.getProperty("groovy.script.base");
        if (text != null) {
            this.setScriptBaseClass(text);
        }
        if ((text = configuration.getProperty("groovy.recompile")) != null) {
            this.setRecompileGroovySource(text.equalsIgnoreCase("true"));
        }
        numeric = 100;
        try {
            text = configuration.getProperty("groovy.recompile.minimumIntervall");
            if (text == null) {
                text = configuration.getProperty("groovy.recompile.minimumInterval");
            }
            numeric = text != null ? Integer.parseInt(text) : 100;
        }
        catch (NumberFormatException e4) {
            throw new ConfigurationException(e4);
        }
        this.setMinimumRecompilationInterval(numeric);
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String encoding) {
        if (encoding == null) {
            encoding = "US-ASCII";
        }
        this.sourceEncoding = encoding;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter output) {
        this.output = output == null ? new PrintWriter(NullWriter.DEFAULT) : output;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String directory) {
        this.targetDirectory = directory != null && directory.length() > 0 ? new File(directory) : null;
    }

    public void setTargetDirectory(File directory) {
        this.targetDirectory = directory;
    }

    public List getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = new LinkedList();
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            this.classpath.add(tokenizer.nextToken());
        }
    }

    public void setClasspathList(List l) {
        this.classpath = new LinkedList(l);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public String getScriptBaseClass() {
        return this.scriptBaseClass;
    }

    public void setScriptBaseClass(String scriptBaseClass) {
        this.scriptBaseClass = scriptBaseClass;
    }

    public ParserPluginFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = ParserPluginFactory.newInstance(true);
        }
        return this.pluginFactory;
    }

    public void setPluginFactory(ParserPluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public String getDefaultScriptExtension() {
        return this.defaultScriptExtension;
    }

    public void setDefaultScriptExtension(String defaultScriptExtension) {
        this.defaultScriptExtension = defaultScriptExtension;
    }

    public void setRecompileGroovySource(boolean recompile) {
        this.recompileGroovySource = recompile;
    }

    public boolean getRecompileGroovySource() {
        return this.recompileGroovySource;
    }

    public void setMinimumRecompilationInterval(int time) {
        this.minimumRecompilationInterval = Math.max(0, time);
    }

    public int getMinimumRecompilationInterval() {
        return this.minimumRecompilationInterval;
    }

    public void setTargetBytecode(String version) {
        if (PRE_JDK5.equals(version) || POST_JDK5.equals(version)) {
            this.targetBytecode = version;
        }
    }

    public String getTargetBytecode() {
        return this.targetBytecode;
    }

    private static String getVMVersion() {
        try {
            Class.forName(JDK5_CLASSNAME_CHECK);
            return POST_JDK5;
        }
        catch (Exception exception) {
            return PRE_JDK5;
        }
    }

    public Map getJointCompilationOptions() {
        return this.jointCompilationOptions;
    }

    public void setJointCompilationOptions(Map options) {
        this.jointCompilationOptions = options;
    }
}

