/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.typehandling;

import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.codehaus.groovy.runtime.typehandling.IntegerCache;

public class DefaultTypeTransformation {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final BigInteger ONE_NEG = new BigInteger("-1");

    public static byte byteUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.byteValue();
    }

    public static char charUnbox(Object value) {
        return DefaultTypeTransformation.castToChar(value);
    }

    public static short shortUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.shortValue();
    }

    public static int intUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.intValue();
    }

    public static boolean booleanUnbox(Object value) {
        return DefaultTypeTransformation.castToBoolean(value);
    }

    public static long longUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.longValue();
    }

    public static float floatUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.floatValue();
    }

    public static double doubleUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.doubleValue();
    }

    public static Object box(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object box(byte value) {
        return new Byte(value);
    }

    public static Object box(char value) {
        return new Character(value);
    }

    public static Object box(short value) {
        return new Short(value);
    }

    public static Object box(int value) {
        return IntegerCache.integerValue(value);
    }

    public static Object box(long value) {
        return new Long(value);
    }

    public static Object box(float value) {
        return new Float(value);
    }

    public static Object box(double value) {
        return new Double(value);
    }

    public static Number castToNumber(Object object2) {
        if (object2 instanceof Number) {
            return (Number)object2;
        }
        if (object2 instanceof Character) {
            return new Integer(((Character)object2).charValue());
        }
        if (object2 instanceof String) {
            String c2 = (String)object2;
            if (c2.length() == 1) {
                return new Integer(c2.charAt(0));
            }
            throw new GroovyCastException((Object)c2, Integer.class);
        }
        throw new GroovyCastException(object2, Number.class);
    }

    public static boolean castToBoolean(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Boolean) {
            Boolean booleanValue = (Boolean)object2;
            return booleanValue;
        }
        if (object2 instanceof Matcher) {
            Matcher matcher = (Matcher)object2;
            RegexSupport.setLastMatcher(matcher);
            return matcher.find();
        }
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            return !collection.isEmpty();
        }
        if (object2 instanceof Map) {
            Map map2 = (Map)object2;
            return !map2.isEmpty();
        }
        if (object2 instanceof Iterator) {
            Iterator iterator = (Iterator)object2;
            return iterator.hasNext();
        }
        if (object2 instanceof Enumeration) {
            Enumeration e2 = (Enumeration)object2;
            return e2.hasMoreElements();
        }
        if (object2 instanceof CharSequence) {
            CharSequence string = (CharSequence)object2;
            return string.length() > 0;
        }
        if (object2 instanceof Object[]) {
            Object[] array = (Object[])object2;
            return array.length > 0;
        }
        if (object2 instanceof Character) {
            Character c2 = (Character)object2;
            return c2.charValue() != '\u0000';
        }
        if (object2 instanceof Number) {
            Number n = (Number)object2;
            return n.doubleValue() != 0.0;
        }
        return true;
    }

    public static char castToChar(Object object2) {
        if (object2 instanceof Character) {
            return ((Character)object2).charValue();
        }
        if (object2 instanceof Number) {
            Number value = (Number)object2;
            return (char)value.intValue();
        }
        String text = object2.toString();
        if (text.length() == 1) {
            return text.charAt(0);
        }
        throw new GroovyCastException((Object)text, Character.TYPE);
    }

    public static Object castToType(Object object2, Class type) {
        if (object2 == null) {
            return null;
        }
        if (type == Object.class) {
            return object2;
        }
        Class<?> aClass = object2.getClass();
        if (type == aClass) {
            return object2;
        }
        if (ReflectionCache.isArray(type)) {
            return DefaultTypeTransformation.asArray(object2, type);
        }
        if (ReflectionCache.isAssignableFrom(type, aClass)) {
            return object2;
        }
        if (Collection.class.isAssignableFrom(type)) {
            int modifiers = type.getModifiers();
            if (object2 instanceof Collection && type.isAssignableFrom(HashSet.class) && (type == HashSet.class || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers))) {
                return new HashSet((Collection)object2);
            }
            if (aClass.isArray()) {
                ArrayList<Object> answer;
                if (type.isAssignableFrom(ArrayList.class) && (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers))) {
                    answer = new ArrayList<Object>();
                } else {
                    try {
                        answer = (ArrayList<Object>)type.newInstance();
                    }
                    catch (Exception e2) {
                        throw new GroovyCastException("Could not instantiate instance of: " + type.getName() + ". Reason: " + e2);
                    }
                }
                int length = Array.getLength(object2);
                for (int i2 = 0; i2 < length; ++i2) {
                    Object element = Array.get(object2, i2);
                    answer.add(element);
                }
                return answer;
            }
        }
        if (type == String.class) {
            return object2.toString();
        }
        if (type == Character.class) {
            return DefaultTypeTransformation.box(DefaultTypeTransformation.castToChar(object2));
        }
        if (type == Boolean.class) {
            return DefaultTypeTransformation.box(DefaultTypeTransformation.castToBoolean(object2));
        }
        if (type == Class.class) {
            return DefaultTypeTransformation.castToClass(object2);
        }
        if (Number.class.isAssignableFrom(type)) {
            Number n = DefaultTypeTransformation.castToNumber(object2);
            if (type == Byte.class) {
                return new Byte(n.byteValue());
            }
            if (type == Character.class) {
                return new Character((char)n.intValue());
            }
            if (type == Short.class) {
                return new Short(n.shortValue());
            }
            if (type == Integer.class) {
                return new Integer(n.intValue());
            }
            if (type == Long.class) {
                return new Long(n.longValue());
            }
            if (type == Float.class) {
                return new Float(n.floatValue());
            }
            if (type == Double.class) {
                Double answer = new Double(n.doubleValue());
                if (!(n instanceof Double || answer != Double.NEGATIVE_INFINITY && answer != Double.POSITIVE_INFINITY)) {
                    throw new GroovyRuntimeException("Automatic coercion of " + n.getClass().getName() + " value " + n + " to double failed.  Value is out of range.");
                }
                return answer;
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(n.toString());
            }
            if (type == BigInteger.class) {
                if (object2 instanceof Float || object2 instanceof Double) {
                    BigDecimal bd = new BigDecimal(n.doubleValue());
                    return bd.toBigInteger();
                }
                if (object2 instanceof BigDecimal) {
                    return ((BigDecimal)object2).toBigInteger();
                }
                return new BigInteger(n.toString());
            }
        } else if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.booleanUnbox(object2));
            }
            if (type == Byte.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.byteUnbox(object2));
            }
            if (type == Character.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.charUnbox(object2));
            }
            if (type == Short.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.shortUnbox(object2));
            }
            if (type == Integer.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.intUnbox(object2));
            }
            if (type == Long.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.longUnbox(object2));
            }
            if (type == Float.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.floatUnbox(object2));
            }
            if (type == Double.TYPE) {
                Double answer = new Double(DefaultTypeTransformation.doubleUnbox(object2));
                if (!(object2 instanceof Double || answer != Double.NEGATIVE_INFINITY && answer != Double.POSITIVE_INFINITY)) {
                    throw new GroovyRuntimeException("Automatic coercion of " + aClass.getName() + " value " + object2 + " to double failed.  Value is out of range.");
                }
                return answer;
            }
        }
        Object[] args = null;
        if (object2 instanceof Collection) {
            Collection list = (Collection)object2;
            args = list.toArray();
        } else if (object2 instanceof Object[]) {
            args = (Object[])object2;
        } else if (object2 instanceof Map) {
            args = new Object[]{object2};
        }
        if (args != null) {
            try {
                return InvokerHelper.invokeConstructorOf(type, (Object)args);
            }
            catch (InvokerInvocationException iie) {
                throw iie;
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        throw new GroovyCastException(object2, type);
    }

    private static Class castToClass(Object object2) {
        try {
            return Class.forName(object2.toString());
        }
        catch (Exception e2) {
            throw new GroovyCastException(object2, Class.class);
        }
    }

    public static Object asArray(Object object2, Class type) {
        if (type.isAssignableFrom(object2.getClass())) {
            return object2;
        }
        Collection list = DefaultTypeTransformation.asCollection(object2);
        int size = list.size();
        Class<?> elementType = type.getComponentType();
        Object array = Array.newInstance(elementType, size);
        int idx = 0;
        if (Boolean.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setBoolean(array, idx, DefaultTypeTransformation.booleanUnbox(element));
                ++idx;
            }
        } else if (Byte.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setByte(array, idx, DefaultTypeTransformation.byteUnbox(element));
                ++idx;
            }
        } else if (Character.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setChar(array, idx, DefaultTypeTransformation.charUnbox(element));
                ++idx;
            }
        } else if (Double.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setDouble(array, idx, DefaultTypeTransformation.doubleUnbox(element));
                ++idx;
            }
        } else if (Float.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setFloat(array, idx, DefaultTypeTransformation.floatUnbox(element));
                ++idx;
            }
        } else if (Integer.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setInt(array, idx, DefaultTypeTransformation.intUnbox(element));
                ++idx;
            }
        } else if (Long.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setLong(array, idx, DefaultTypeTransformation.longUnbox(element));
                ++idx;
            }
        } else if (Short.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setShort(array, idx, DefaultTypeTransformation.shortUnbox(element));
                ++idx;
            }
        } else {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object coercedElement = DefaultTypeTransformation.castToType(element, elementType);
                Array.set(array, idx, coercedElement);
                ++idx;
            }
        }
        return array;
    }

    public static Collection asCollection(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Map) {
            Map map2 = (Map)value;
            return map2.entrySet();
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return DefaultTypeTransformation.primitiveArrayToList(value);
            }
            return Arrays.asList((Object[])value);
        }
        if (value instanceof MethodClosure) {
            MethodClosure method = (MethodClosure)value;
            IteratorClosureAdapter adapter = new IteratorClosureAdapter(method.getDelegate());
            method.call(adapter);
            return adapter.asList();
        }
        if (value instanceof String) {
            return DefaultGroovyMethods.toList((String)value);
        }
        if (value instanceof GString) {
            return DefaultGroovyMethods.toList(value.toString());
        }
        if (value instanceof File) {
            try {
                return DefaultGroovyMethods.readLines((File)value);
            }
            catch (IOException e2) {
                throw new GroovyRuntimeException("Error reading file: " + value, e2);
            }
        }
        if (DefaultTypeTransformation.isEnumSubclass(value)) {
            Object[] values = (Object[])InvokerHelper.invokeMethod(value, "values", new Object[0]);
            return Arrays.asList(values);
        }
        return Collections.singletonList(value);
    }

    public static boolean isEnumSubclass(Object value) {
        if (value instanceof Class) {
            for (Class superclass = ((Class)value).getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                if (!superclass.getName().equals("java.lang.Enum")) continue;
                return true;
            }
        }
        return false;
    }

    public static List primitiveArrayToList(Object array) {
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            Object item = Array.get(array, i2);
            if (item != null && item.getClass().isArray() && item.getClass().getComponentType().isPrimitive()) {
                item = DefaultTypeTransformation.primitiveArrayToList(item);
            }
            list.add(item);
        }
        return list;
    }

    public static Object[] primitiveArrayBox(Object array) {
        int size = Array.getLength(array);
        Object[] ret = (Object[])Array.newInstance(ReflectionCache.autoboxType(array.getClass().getComponentType()), size);
        for (int i2 = 0; i2 < size; ++i2) {
            ret[i2] = Array.get(array, i2);
        }
        return ret;
    }

    public static int compareTo(Object left, Object right) {
        return DefaultTypeTransformation.compareToWithEqualityCheck(left, right, false);
    }

    private static int compareToWithEqualityCheck(Object left, Object right, boolean equalityCheckOnly) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof Comparable) {
            if (left instanceof Number) {
                if (DefaultTypeTransformation.isValidCharacterString(right)) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
                if (right instanceof Character || right instanceof Number) {
                    return DefaultGroovyMethods.compareTo((Number)left, DefaultTypeTransformation.castToNumber(right));
                }
            } else if (left instanceof Character) {
                if (DefaultTypeTransformation.isValidCharacterString(right)) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
                if (right instanceof Number) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
            } else if (right instanceof Number) {
                if (DefaultTypeTransformation.isValidCharacterString(left)) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
            } else {
                if (left instanceof String && right instanceof Character) {
                    return ((String)left).compareTo(right.toString());
                }
                if (left instanceof String && right instanceof GString) {
                    return ((String)left).compareTo(right.toString());
                }
            }
            if (!equalityCheckOnly || left.getClass().isAssignableFrom(right.getClass()) || right.getClass().isAssignableFrom(left.getClass()) || left instanceof GString && right instanceof String) {
                Comparable comparable = (Comparable)left;
                return comparable.compareTo(right);
            }
        }
        if (equalityCheckOnly) {
            return -1;
        }
        throw new GroovyRuntimeException("Cannot compare " + left.getClass().getName() + " with value '" + left + "' and " + right.getClass().getName() + " with value '" + right + "'");
    }

    public static boolean compareEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Comparable) {
            return DefaultTypeTransformation.compareToWithEqualityCheck(left, right, true) == 0;
        }
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        if (leftClass.isArray() && rightClass.isArray()) {
            return DefaultTypeTransformation.compareArrayEqual(left, right);
        }
        if (leftClass.isArray() && leftClass.getComponentType().isPrimitive()) {
            left = DefaultTypeTransformation.primitiveArrayToList(left);
        }
        if (rightClass.isArray() && rightClass.getComponentType().isPrimitive()) {
            right = DefaultTypeTransformation.primitiveArrayToList(right);
        }
        if (left instanceof Object[] && right instanceof List) {
            return DefaultGroovyMethods.equals((Object[])left, (List)right);
        }
        if (left instanceof List && right instanceof Object[]) {
            return DefaultGroovyMethods.equals((List)left, (Object[])right);
        }
        if (left instanceof List && right instanceof List) {
            return DefaultGroovyMethods.equals((List)left, (List)right);
        }
        return (Boolean)InvokerHelper.invokeMethod(left, "equals", right);
    }

    public static boolean compareArrayEqual(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (Array.getLength(left) != Array.getLength(right)) {
            return false;
        }
        for (int i2 = 0; i2 < Array.getLength(left); ++i2) {
            Object r;
            Object l = Array.get(left, i2);
            if (DefaultTypeTransformation.compareEqual(l, r = Array.get(right, i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidCharacterString(Object value) {
        String s2;
        return value instanceof String && (s2 = (String)value).length() == 1;
    }

    public static int[] convertToIntArray(Object a2) {
        int[] ans = null;
        if (a2.getClass().getName().equals("[I")) {
            ans = (int[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new int[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = ((Number)ia[i2]).intValue();
            }
        }
        return ans;
    }

    public static boolean[] convertToBooleanArray(Object a2) {
        boolean[] ans = null;
        if (a2.getClass().getName().equals("[Z")) {
            ans = (boolean[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new boolean[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = (Boolean)ia[i2];
            }
        }
        return ans;
    }

    public static byte[] convertToByteArray(Object a2) {
        byte[] ans = null;
        if (a2.getClass().getName().equals("[B")) {
            ans = (byte[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new byte[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = ((Number)ia[i2]).byteValue();
            }
        }
        return ans;
    }

    public static short[] convertToShortArray(Object a2) {
        short[] ans = null;
        if (a2.getClass().getName().equals("[S")) {
            ans = (short[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new short[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                ans[i2] = ((Number)ia[i2]).shortValue();
            }
        }
        return ans;
    }

    public static char[] convertToCharArray(Object a2) {
        char[] ans = null;
        if (a2.getClass().getName().equals("[C")) {
            ans = (char[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new char[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = ((Character)ia[i2]).charValue();
            }
        }
        return ans;
    }

    public static long[] convertToLongArray(Object a2) {
        long[] ans = null;
        if (a2.getClass().getName().equals("[J")) {
            ans = (long[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new long[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = ((Number)ia[i2]).longValue();
            }
        }
        return ans;
    }

    public static float[] convertToFloatArray(Object a2) {
        float[] ans = null;
        if (a2.getClass().getName().equals("[F")) {
            ans = (float[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new float[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = ((Number)ia[i2]).floatValue();
            }
        }
        return ans;
    }

    public static double[] convertToDoubleArray(Object a2) {
        double[] ans = null;
        if (a2.getClass().getName().equals("[D")) {
            ans = (double[])a2;
        } else {
            Object[] ia = (Object[])a2;
            ans = new double[ia.length];
            for (int i2 = 0; i2 < ia.length; ++i2) {
                if (ia[i2] == null) continue;
                ans[i2] = ((Number)ia[i2]).doubleValue();
            }
        }
        return ans;
    }

    public static Object convertToPrimitiveArray(Object a2, Class type) {
        if (type == Byte.TYPE) {
            return DefaultTypeTransformation.convertToByteArray(a2);
        }
        if (type == Boolean.TYPE) {
            return DefaultTypeTransformation.convertToBooleanArray(a2);
        }
        if (type == Short.TYPE) {
            return DefaultTypeTransformation.convertToShortArray(a2);
        }
        if (type == Character.TYPE) {
            return DefaultTypeTransformation.convertToCharArray(a2);
        }
        if (type == Integer.TYPE) {
            return DefaultTypeTransformation.convertToIntArray(a2);
        }
        if (type == Long.TYPE) {
            return DefaultTypeTransformation.convertToLongArray(a2);
        }
        if (type == Float.TYPE) {
            return DefaultTypeTransformation.convertToFloatArray(a2);
        }
        if (type == Double.TYPE) {
            return DefaultTypeTransformation.convertToDoubleArray(a2);
        }
        return a2;
    }
}

