/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyPackageDoc;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTool;
import org.codehaus.groovy.tools.groovydoc.ResourceManager;

public class GroovyDocTemplateEngine {
    private TemplateEngine engine;
    private GroovyDocTool tool;
    private ResourceManager resourceManager;
    private Map docTemplates;
    private List docTemplatePaths;
    private Map packageTemplates;
    private List packageTemplatePaths;
    private Map classTemplates;
    private List classTemplatePaths;

    public GroovyDocTemplateEngine(GroovyDocTool tool, ResourceManager resourceManager, String classTemplate) {
        this(tool, resourceManager, new String[0], new String[0], new String[]{classTemplate});
    }

    public GroovyDocTemplateEngine(GroovyDocTool tool, ResourceManager resourceManager, String[] docTemplates, String[] packageTemplates, String[] classTemplates) {
        this.tool = tool;
        this.resourceManager = resourceManager;
        this.docTemplatePaths = Arrays.asList(docTemplates);
        this.packageTemplatePaths = Arrays.asList(packageTemplates);
        this.classTemplatePaths = Arrays.asList(classTemplates);
        this.docTemplates = new HashMap();
        this.packageTemplates = new HashMap();
        this.classTemplates = new HashMap();
        this.engine = new GStringTemplateEngine();
    }

    String applyClassTemplates(GroovyClassDoc classDoc) {
        String templatePath = (String)this.classTemplatePaths.get(0);
        String templateWithBindingApplied = "";
        try {
            Template t = (Template)this.classTemplates.get(templatePath);
            if (t == null) {
                t = this.engine.createTemplate(this.resourceManager.getReader(templatePath));
                this.classTemplates.put(templatePath, t);
            }
            HashMap<String, GroovyClassDoc> binding = new HashMap<String, GroovyClassDoc>();
            binding.put("classDoc", classDoc);
            templateWithBindingApplied = t.make(binding).toString();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return templateWithBindingApplied;
    }

    String applyPackageTemplate(String template, GroovyPackageDoc packageDoc) {
        String templatePath = template;
        String templateWithBindingApplied = "";
        try {
            Template t = (Template)this.packageTemplates.get(templatePath);
            if (t == null) {
                t = this.engine.createTemplate(this.resourceManager.getReader(templatePath));
                this.packageTemplates.put(templatePath, t);
            }
            HashMap<String, GroovyPackageDoc> binding = new HashMap<String, GroovyPackageDoc>();
            binding.put("packageDoc", packageDoc);
            templateWithBindingApplied = t.make(binding).toString();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return templateWithBindingApplied;
    }

    String applyRootDocTemplate(String template, GroovyRootDoc rootDoc) {
        String templatePath = template;
        String templateWithBindingApplied = "";
        try {
            Template t = (Template)this.docTemplates.get(templatePath);
            if (t == null) {
                t = this.engine.createTemplate(this.resourceManager.getReader(templatePath));
                this.docTemplates.put(templatePath, t);
            }
            HashMap<String, GroovyRootDoc> binding = new HashMap<String, GroovyRootDoc>();
            binding.put("rootDoc", rootDoc);
            templateWithBindingApplied = t.make(binding).toString();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return templateWithBindingApplied;
    }

    Iterator classTemplatesIterator() {
        return this.classTemplatePaths.iterator();
    }

    Iterator packageTemplatesIterator() {
        return this.packageTemplatePaths.iterator();
    }

    Iterator docTemplatesIterator() {
        return this.docTemplatePaths.iterator();
    }
}

