/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class BranchStatement
extends Statement {
    public char[] label;
    public Label targetLabel;
    public SubRoutineStatement[] subroutines;

    public BranchStatement(char[] l, int s2, int e2) {
        this.label = l;
        this.sourceStart = s2;
        this.sourceEnd = e2;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.subroutines != null) {
            int i2 = 0;
            int max = this.subroutines.length;
            while (i2 < max) {
                SubRoutineStatement sub2 = this.subroutines[i2];
                sub2.generateSubRoutineInvocation(currentScope, codeStream);
                if (sub2.isSubRoutineEscaping()) {
                    codeStream.recordPositionsFrom(pc, this.sourceStart);
                    SubRoutineStatement.reenterExceptionHandlers(this.subroutines, i2, codeStream);
                    return;
                }
                sub2.exitAnyExceptionHandler();
                ++i2;
            }
        }
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        SubRoutineStatement.reenterExceptionHandlers(this.subroutines, -1, codeStream);
    }

    public void resolve(BlockScope scope) {
    }
}

