/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class SubRoutineStatement
extends Statement {
    public static final ExceptionLabel[] NO_EXCEPTION_HANDLER = new ExceptionLabel[0];
    ExceptionLabel[] anyExceptionLabels = NO_EXCEPTION_HANDLER;
    int anyExceptionLabelsCount = 0;

    public abstract boolean isSubRoutineEscaping();

    public abstract void generateSubRoutineInvocation(BlockScope var1, CodeStream var2);

    public ExceptionLabel enterAnyExceptionHandler(CodeStream codeStream) {
        int length = this.anyExceptionLabelsCount;
        if (length == this.anyExceptionLabels.length) {
            this.anyExceptionLabels = new ExceptionLabel[length * 2 + 1];
            System.arraycopy(this.anyExceptionLabels, 0, this.anyExceptionLabels, 0, length);
        }
        ExceptionLabel exceptionLabel = new ExceptionLabel(codeStream, null);
        this.anyExceptionLabels[this.anyExceptionLabelsCount++] = exceptionLabel;
        return exceptionLabel;
    }

    public void exitAnyExceptionHandler() {
        if (this.anyExceptionLabelsCount == 0) {
            return;
        }
        ExceptionLabel currentLabel = this.anyExceptionLabels[this.anyExceptionLabelsCount - 1];
        if (currentLabel.start == currentLabel.codeStream.position) {
            this.anyExceptionLabels[--this.anyExceptionLabelsCount] = null;
            currentLabel.codeStream.removeExceptionHandler(currentLabel);
        } else {
            currentLabel.placeEnd();
        }
    }

    public void placeAllAnyExceptionHandlers() {
        int i2 = 0;
        while (i2 < this.anyExceptionLabelsCount) {
            this.anyExceptionLabels[i2].place();
            ++i2;
        }
    }

    public static void reenterExceptionHandlers(SubRoutineStatement[] subroutines, int max, CodeStream codeStream) {
        if (subroutines == null) {
            return;
        }
        if (max < 0) {
            max = subroutines.length;
        }
        int i2 = 0;
        while (i2 < max) {
            subroutines[i2].enterAnyExceptionHandler(codeStream);
            ++i2;
        }
    }
}

