/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    Expression[] nullReferences;
    int[] nullStatus;
    int nullCount;

    public FinallyFlowContext(FlowContext parent, ASTNode associatedNode) {
        super(parent, associatedNode);
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope scope) {
        int i2 = 0;
        while (i2 < this.assignCount) {
            VariableBinding variable = this.finalVariables[i2];
            if (variable != null) {
                boolean complained = false;
                if (variable instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)variable)) {
                        complained = true;
                        scope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variable, this.finalAssignments[i2]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variable)) {
                    complained = true;
                    scope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variable, this.finalAssignments[i2]);
                }
                if (complained) {
                    FlowContext currentContext = this.parent;
                    while (currentContext != null) {
                        currentContext.removeFinalAssignmentIfAny(this.finalAssignments[i2]);
                        currentContext = currentContext.parent;
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nullCount) {
            Expression expression = this.nullReferences[i2];
            if (expression != null) {
                LocalVariableBinding local = expression.localVariableBinding();
                switch (this.nullStatus[i2]) {
                    case 1: {
                        if (!flowInfo.isDefinitelyNull(local)) break;
                        this.nullReferences[i2] = null;
                        this.parent.recordUsingNullReference(scope, local, expression, this.nullStatus[i2], flowInfo);
                        break;
                    }
                    case -1: {
                        if (!flowInfo.isDefinitelyNonNull(local)) break;
                        this.nullReferences[i2] = null;
                        this.parent.recordUsingNullReference(scope, local, expression, this.nullStatus[i2], flowInfo);
                    }
                }
            }
            ++i2;
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Finally flow context");
        buffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        buffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return buffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    protected boolean recordFinalAssignment(VariableBinding binding, Reference finalAssignment) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = finalAssignment;
        this.finalVariables[this.assignCount++] = binding;
        return true;
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int i2 = 0;
        while (i2 < this.assignCount) {
            if (this.finalAssignments[i2] == reference) {
                this.finalAssignments[i2] = null;
                this.finalVariables[i2] = null;
                return;
            }
            ++i2;
        }
    }

    protected boolean recordNullReference(Expression expression, int status) {
        if (this.nullCount == 0) {
            this.nullReferences = new Expression[5];
            this.nullStatus = new int[5];
        } else if (this.nullCount == this.nullReferences.length) {
            this.nullReferences = new Expression[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullStatus = new int[this.nullCount * 2];
            System.arraycopy(this.nullStatus, 0, this.nullStatus, 0, this.nullCount);
        }
        this.nullReferences[this.nullCount] = expression;
        this.nullStatus[this.nullCount++] = status;
        return true;
    }
}

