/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SyntheticMethodBinding
extends MethodBinding {
    public FieldBinding targetReadField;
    public FieldBinding targetWriteField;
    public MethodBinding targetMethod;
    public TypeBinding targetEnumType;
    public int kind;
    public static final int FieldReadAccess = 1;
    public static final int FieldWriteAccess = 2;
    public static final int MethodAccess = 3;
    public static final int ConstructorAccess = 4;
    public static final int SuperMethodAccess = 5;
    public static final int BridgeMethod = 6;
    public static final int EnumValues = 7;
    public static final int EnumValueOf = 8;
    public static final int SwitchTable = 9;
    public int sourceStart = 0;
    public int index;

    public SyntheticMethodBinding(FieldBinding targetField, boolean isReadAccess, ReferenceBinding declaringClass) {
        int i2;
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        this.tagBits |= 0x200000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(methodId).toCharArray());
        if (isReadAccess) {
            this.returnType = targetField.type;
            if (targetField.isStatic()) {
                this.parameters = NoParameters;
            } else {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = declaringSourceType;
            }
            this.targetReadField = targetField;
            this.kind = 1;
        } else {
            this.returnType = VoidBinding;
            if (targetField.isStatic()) {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = targetField.type;
            } else {
                this.parameters = new TypeBinding[2];
                this.parameters[0] = declaringSourceType;
                this.parameters[1] = targetField.type;
            }
            this.targetWriteField = targetField;
            this.kind = 2;
        }
        this.thrownExceptions = NoExceptions;
        this.declaringClass = declaringSourceType;
        do {
            block15: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods;
                i2 = 0;
                int length = methods.length;
                while (i2 < length) {
                    if (CharOperation.equals(this.selector, methods[i2].selector) && this.areParametersEqual(methods[i2])) {
                        needRename = true;
                        break block15;
                    }
                    ++i2;
                }
                if (knownAccessMethods != null) {
                    i2 = 0;
                    length = knownAccessMethods.length;
                    while (i2 < length) {
                        if (knownAccessMethods[i2] != null && CharOperation.equals(this.selector, knownAccessMethods[i2].selector) && this.areParametersEqual(methods[i2])) {
                            needRename = true;
                            break;
                        }
                        ++i2;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        FieldDeclaration[] fieldDecls = declaringSourceType.scope.referenceContext.fields;
        if (fieldDecls != null) {
            i2 = 0;
            int max = fieldDecls.length;
            while (i2 < max) {
                if (fieldDecls[i2].binding == targetField) {
                    this.sourceStart = fieldDecls[i2].sourceStart;
                    return;
                }
                ++i2;
            }
        }
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    public SyntheticMethodBinding(FieldBinding targetField, ReferenceBinding declaringClass, TypeBinding enumBinding, char[] selector) {
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        this.tagBits |= 0x200000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = selector;
        this.returnType = declaringSourceType.scope.createArrayType(BaseTypes.IntBinding, 1);
        this.parameters = NoParameters;
        this.targetReadField = targetField;
        this.targetEnumType = enumBinding;
        this.kind = 9;
        this.thrownExceptions = NoExceptions;
        this.declaringClass = declaringSourceType;
        if (declaringSourceType.isStrictfp()) {
            this.modifiers |= 0x800;
        }
        do {
            block7: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods;
                int i2 = 0;
                int length = methods.length;
                while (i2 < length) {
                    if (CharOperation.equals(this.selector, methods[i2].selector) && this.areParametersEqual(methods[i2])) {
                        needRename = true;
                        break block7;
                    }
                    ++i2;
                }
                if (knownAccessMethods != null) {
                    i2 = 0;
                    length = knownAccessMethods.length;
                    while (i2 < length) {
                        if (knownAccessMethods[i2] != null && CharOperation.equals(this.selector, knownAccessMethods[i2].selector) && this.areParametersEqual(methods[i2])) {
                            needRename = true;
                            break;
                        }
                        ++i2;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(selector, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    public SyntheticMethodBinding(MethodBinding targetMethod, boolean isSuperAccess, ReferenceBinding receiverType) {
        if (targetMethod.isConstructor()) {
            this.initializeConstructorAccessor(targetMethod);
        } else {
            this.initializeMethodAccessor(targetMethod, isSuperAccess, receiverType);
        }
    }

    public SyntheticMethodBinding(MethodBinding overridenMethodToBridge, MethodBinding targetMethod, SourceTypeBinding declaringClass) {
        int methodId;
        this.declaringClass = declaringClass;
        this.selector = overridenMethodToBridge.selector;
        this.modifiers = (overridenMethodToBridge.modifiers | 0x40 | 0x1000) & 0xBFFFFAFF;
        this.tagBits |= 0x200000000L;
        this.returnType = overridenMethodToBridge.returnType;
        this.parameters = overridenMethodToBridge.parameters;
        this.thrownExceptions = overridenMethodToBridge.thrownExceptions;
        this.targetMethod = targetMethod;
        this.kind = 6;
        SyntheticMethodBinding[] knownAccessMethods = declaringClass.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    public SyntheticMethodBinding(SourceTypeBinding declaringEnum, char[] selector) {
        int methodId;
        this.declaringClass = declaringEnum;
        this.selector = selector;
        this.modifiers = 25;
        this.tagBits |= 0x200000000L;
        this.thrownExceptions = NoExceptions;
        if (selector == TypeConstants.VALUES) {
            this.returnType = declaringEnum.scope.createArrayType(declaringEnum, 1);
            this.parameters = NoParameters;
            this.kind = 7;
        } else if (selector == TypeConstants.VALUEOF) {
            this.returnType = declaringEnum;
            this.parameters = new TypeBinding[]{declaringEnum.scope.getJavaLangString()};
            this.kind = 8;
        }
        SyntheticMethodBinding[] knownAccessMethods = ((SourceTypeBinding)this.declaringClass).syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        if (declaringEnum.isStrictfp()) {
            this.modifiers |= 0x800;
        }
    }

    public void initializeConstructorAccessor(MethodBinding accessedConstructor) {
        int length;
        int i2;
        boolean needRename;
        this.targetMethod = accessedConstructor;
        this.modifiers = 4096;
        this.tagBits |= 0x200000000L;
        SourceTypeBinding sourceType = (SourceTypeBinding)accessedConstructor.declaringClass;
        SyntheticMethodBinding[] knownSyntheticMethods = sourceType.syntheticMethods();
        this.index = knownSyntheticMethods == null ? 0 : knownSyntheticMethods.length;
        this.selector = accessedConstructor.selector;
        this.returnType = accessedConstructor.returnType;
        this.kind = 4;
        this.parameters = new TypeBinding[accessedConstructor.parameters.length + 1];
        System.arraycopy(accessedConstructor.parameters, 0, this.parameters, 0, accessedConstructor.parameters.length);
        this.parameters[accessedConstructor.parameters.length] = accessedConstructor.declaringClass;
        this.thrownExceptions = accessedConstructor.thrownExceptions;
        this.declaringClass = sourceType;
        do {
            block9: {
                needRename = false;
                MethodBinding[] methods = sourceType.methods;
                i2 = 0;
                length = methods.length;
                while (i2 < length) {
                    if (CharOperation.equals(this.selector, methods[i2].selector) && this.areParametersEqual(methods[i2])) {
                        needRename = true;
                        break block9;
                    }
                    ++i2;
                }
                if (knownSyntheticMethods != null) {
                    i2 = 0;
                    length = knownSyntheticMethods.length;
                    while (i2 < length) {
                        if (knownSyntheticMethods[i2] != null && CharOperation.equals(this.selector, knownSyntheticMethods[i2].selector) && this.areParametersEqual(knownSyntheticMethods[i2])) {
                            needRename = true;
                            break;
                        }
                        ++i2;
                    }
                }
            }
            if (!needRename) continue;
            int length2 = this.parameters.length;
            this.parameters = new TypeBinding[length2 + 1];
            System.arraycopy(this.parameters, 0, this.parameters, 0, length2);
            this.parameters[length2] = this.declaringClass;
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = sourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            i2 = 0;
            length = methodDecls.length;
            while (i2 < length) {
                if (methodDecls[i2].binding == accessedConstructor) {
                    this.sourceStart = methodDecls[i2].sourceStart;
                    return;
                }
                ++i2;
            }
        }
    }

    public void initializeMethodAccessor(MethodBinding accessedMethod, boolean isSuperAccess, ReferenceBinding receiverType) {
        int length;
        int i2;
        boolean needRename;
        int methodId;
        this.targetMethod = accessedMethod;
        this.modifiers = 4104;
        this.tagBits |= 0x200000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)receiverType;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(methodId).toCharArray());
        this.returnType = accessedMethod.returnType;
        int n = this.kind = isSuperAccess ? 5 : 3;
        if (accessedMethod.isStatic()) {
            this.parameters = accessedMethod.parameters;
        } else {
            this.parameters = new TypeBinding[accessedMethod.parameters.length + 1];
            this.parameters[0] = declaringSourceType;
            System.arraycopy(accessedMethod.parameters, 0, this.parameters, 1, accessedMethod.parameters.length);
        }
        this.thrownExceptions = accessedMethod.thrownExceptions;
        this.declaringClass = declaringSourceType;
        do {
            block11: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods;
                i2 = 0;
                length = methods.length;
                while (i2 < length) {
                    if (CharOperation.equals(this.selector, methods[i2].selector) && this.areParametersEqual(methods[i2])) {
                        needRename = true;
                        break block11;
                    }
                    ++i2;
                }
                if (knownAccessMethods != null) {
                    i2 = 0;
                    length = knownAccessMethods.length;
                    while (i2 < length) {
                        if (knownAccessMethods[i2] != null && CharOperation.equals(this.selector, knownAccessMethods[i2].selector) && this.areParametersEqual(knownAccessMethods[i2])) {
                            needRename = true;
                            break;
                        }
                        ++i2;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = declaringSourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            i2 = 0;
            length = methodDecls.length;
            while (i2 < length) {
                if (methodDecls[i2].binding == accessedMethod) {
                    this.sourceStart = methodDecls[i2].sourceStart;
                    return;
                }
                ++i2;
            }
        }
    }

    protected boolean isConstructorRelated() {
        return this.kind == 4;
    }
}

