/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class TypeVariableBinding
extends ReferenceBinding {
    public Binding declaringElement;
    public int rank;
    public TypeBinding firstBound;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public char[] genericTypeSignature;

    public TypeVariableBinding(char[] sourceName, Binding declaringElement, int rank) {
        this.sourceName = sourceName;
        this.declaringElement = declaringElement;
        this.rank = rank;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
    }

    public int kind() {
        return 4100;
    }

    public int boundCheck(Substitution substitution, TypeBinding argumentType) {
        ReferenceBinding superType;
        boolean hasSubstitution;
        if (argumentType == NullBinding || argumentType == this) {
            return 0;
        }
        boolean bl = hasSubstitution = substitution != null;
        if (!(argumentType instanceof ReferenceBinding) && !argumentType.isArrayType()) {
            return 2;
        }
        if (this.superclass == null) {
            return 0;
        }
        if (argumentType.isWildcard() && !argumentType.isIntersectionType()) {
            WildcardBinding wildcard = (WildcardBinding)argumentType;
            switch (wildcard.boundKind) {
                case 1: {
                    TypeBinding wildcardBound = wildcard.bound;
                    if (wildcardBound == this) {
                        return 0;
                    }
                    ReferenceBinding superclassBound = hasSubstitution ? (ReferenceBinding)Scope.substitute(substitution, this.superclass) : this.superclass;
                    boolean isArrayBound = wildcardBound.isArrayType();
                    if (!wildcardBound.isInterface() && superclassBound.id != 1) {
                        if (isArrayBound) {
                            if (!wildcardBound.isCompatibleWith(superclassBound)) {
                                return 2;
                            }
                        } else {
                            ReferenceBinding match = ((ReferenceBinding)wildcardBound).findSuperTypeWithSameErasure(superclassBound);
                            if (match != null) {
                                if (!match.isIntersectingWith(superclassBound)) {
                                    return 2;
                                }
                            } else {
                                return 2;
                            }
                        }
                    }
                    ReferenceBinding[] superInterfaceBounds = hasSubstitution ? Scope.substitute(substitution, this.superInterfaces) : this.superInterfaces;
                    int length = superInterfaceBounds.length;
                    boolean mustImplement = isArrayBound || ((ReferenceBinding)wildcardBound).isFinal();
                    int i2 = 0;
                    while (i2 < length) {
                        ReferenceBinding match;
                        ReferenceBinding superInterfaceBound = superInterfaceBounds[i2];
                        if (isArrayBound ? !wildcardBound.isCompatibleWith(superInterfaceBound) : ((match = ((ReferenceBinding)wildcardBound).findSuperTypeWithSameErasure(superInterfaceBound)) != null ? !match.isIntersectingWith(superInterfaceBound) : mustImplement)) {
                            return 2;
                        }
                        ++i2;
                    }
                    break;
                }
                case 2: {
                    return this.boundCheck(substitution, wildcard.bound);
                }
            }
            return 0;
        }
        boolean unchecked = false;
        if (this.superclass.id != 1 && (superType = this.superclass) != argumentType) {
            ReferenceBinding referenceArgument;
            ReferenceBinding match;
            ReferenceBinding substitutedSuperType;
            TypeBinding typeBinding = substitutedSuperType = hasSubstitution ? Scope.substitute(substitution, superType) : superType;
            if (!argumentType.isCompatibleWith(substitutedSuperType)) {
                return 2;
            }
            if (argumentType instanceof ReferenceBinding && (match = (referenceArgument = (ReferenceBinding)argumentType).findSuperTypeWithSameErasure(substitutedSuperType)) != null && match.isRawType() && (substitutedSuperType.isGenericType() || substitutedSuperType.isBoundParameterizedType())) {
                unchecked = true;
            }
        }
        int i3 = 0;
        int length = this.superInterfaces.length;
        while (i3 < length) {
            ReferenceBinding superType2 = this.superInterfaces[i3];
            if (superType2 != argumentType) {
                ReferenceBinding referenceArgument;
                ReferenceBinding match;
                ReferenceBinding substitutedSuperType;
                TypeBinding typeBinding = substitutedSuperType = hasSubstitution ? Scope.substitute(substitution, superType2) : superType2;
                if (!argumentType.isCompatibleWith(substitutedSuperType)) {
                    return 2;
                }
                if (argumentType instanceof ReferenceBinding && (match = (referenceArgument = (ReferenceBinding)argumentType).findSuperTypeWithSameErasure(substitutedSuperType)) != null && match.isRawType() && (substitutedSuperType.isGenericType() || substitutedSuperType.isBoundParameterizedType())) {
                    unchecked = true;
                }
            }
            ++i3;
        }
        return unchecked ? 1 : 0;
    }

    public boolean canBeInstantiated() {
        return false;
    }

    public void collectSubstitutes(Scope scope, TypeBinding otherType, Map substitutes, int constraint) {
        block16: {
            int variableConstraint;
            switch (otherType.kind()) {
                case 132: {
                    if (otherType == NullBinding) {
                        return;
                    }
                    TypeBinding boxedType = scope.environment().computeBoxingType(otherType);
                    if (boxedType == otherType) {
                        return;
                    }
                    otherType = boxedType;
                    break;
                }
                case 516: {
                    WildcardBinding otherWildcard = (WildcardBinding)otherType;
                    if (otherWildcard.otherBounds != null) break;
                    return;
                }
            }
            switch (constraint) {
                case 0: {
                    variableConstraint = 0;
                    break;
                }
                case 1: {
                    variableConstraint = 2;
                    break;
                }
                default: {
                    variableConstraint = 1;
                }
            }
            TypeBinding[][] variableSubstitutes = (TypeBinding[][])substitutes.get(this);
            if (variableSubstitutes != null) {
                int length;
                TypeBinding[] constraintSubstitutes = variableSubstitutes[variableConstraint];
                if (constraintSubstitutes == null) {
                    length = 0;
                    constraintSubstitutes = new TypeBinding[1];
                } else {
                    length = constraintSubstitutes.length;
                    int i2 = 0;
                    while (i2 < length) {
                        TypeBinding substitute = constraintSubstitutes[i2];
                        if (substitute == otherType) {
                            return;
                        }
                        if (substitute == null) {
                            constraintSubstitutes[i2] = otherType;
                            break block16;
                        }
                        ++i2;
                    }
                    TypeBinding[] typeBindingArray = constraintSubstitutes;
                    constraintSubstitutes = new TypeBinding[length + 1];
                    System.arraycopy(typeBindingArray, 0, constraintSubstitutes, 0, length);
                }
                constraintSubstitutes[length] = otherType;
                variableSubstitutes[variableConstraint] = constraintSubstitutes;
            }
        }
    }

    public char[] constantPoolName() {
        if (this.firstBound != null) {
            return this.firstBound.constantPoolName();
        }
        return this.superclass.constantPoolName();
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        Binding declaring = this.declaringElement;
        if (!isLeaf && declaring.kind() == 8) {
            MethodBinding methodBinding = (MethodBinding)declaring;
            ReferenceBinding declaringClass = methodBinding.declaringClass;
            buffer.append(declaringClass.computeUniqueKey(false));
            buffer.append(':');
            MethodBinding[] methods = declaringClass.methods();
            if (methods != null) {
                int i2 = 0;
                int length = methods.length;
                while (i2 < length) {
                    MethodBinding binding = methods[i2];
                    if (binding == methodBinding) {
                        buffer.append(i2);
                        break;
                    }
                    ++i2;
                }
            }
        } else {
            buffer.append(declaring.computeUniqueKey(false));
            buffer.append(':');
        }
        buffer.append(this.genericTypeSignature());
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    public String debugName() {
        return new String(this.sourceName);
    }

    public TypeBinding erasure() {
        if (this.firstBound != null) {
            return this.firstBound.erasure();
        }
        return this.superclass;
    }

    public char[] genericSignature() {
        int interfaceLength;
        StringBuffer sig = new StringBuffer(10);
        sig.append(this.sourceName).append(':');
        int n = interfaceLength = this.superInterfaces == null ? 0 : this.superInterfaces.length;
        if ((interfaceLength == 0 || this.firstBound == this.superclass) && this.superclass != null) {
            sig.append(this.superclass.genericTypeSignature());
        }
        int i2 = 0;
        while (i2 < interfaceLength) {
            sig.append(':').append(this.superInterfaces[i2].genericTypeSignature());
            ++i2;
        }
        int sigLength = sig.length();
        char[] genericSignature = new char[sigLength];
        sig.getChars(0, sigLength, genericSignature, 0);
        return genericSignature;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature != null) {
            return this.genericTypeSignature;
        }
        this.genericTypeSignature = CharOperation.concat('T', this.sourceName, ';');
        return this.genericTypeSignature;
    }

    public boolean isErasureBoundTo(TypeBinding type) {
        if (this.superclass.erasure() == type) {
            return true;
        }
        int i2 = 0;
        int length = this.superInterfaces.length;
        while (i2 < length) {
            if (this.superInterfaces[i2].erasure() == type) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean isInterchangeableWith(final LookupEnvironment environment, final TypeVariableBinding otherVariable) {
        Substitution subst;
        int length;
        block11: {
            if (this == otherVariable) {
                return true;
            }
            length = this.superInterfaces.length;
            if (length != otherVariable.superInterfaces.length) {
                return false;
            }
            if (this.superclass != otherVariable.superclass) {
                if (this.superclass.erasure() != otherVariable.superclass.erasure()) {
                    return false;
                }
            } else {
                int i2 = 0;
                while (i2 < length) {
                    if (this.superInterfaces[i2] != otherVariable.superInterfaces[i2]) {
                        if (this.superInterfaces[i2].erasure() != otherVariable.superInterfaces[i2].erasure()) {
                            return false;
                        }
                        break block11;
                    }
                    ++i2;
                }
                return true;
            }
        }
        if (this.superclass != Scope.substitute(subst = new Substitution(){

            public LookupEnvironment environment() {
                return environment;
            }

            public boolean isRawSubstitution() {
                return false;
            }

            public TypeBinding substitute(TypeVariableBinding typeVariable) {
                return typeVariable == otherVariable ? TypeVariableBinding.this : typeVariable;
            }
        }, otherVariable.superclass)) {
            return false;
        }
        int i3 = 0;
        while (i3 < length) {
            if (this.superInterfaces[i3] != Scope.substitute(subst, otherVariable.superInterfaces[i3])) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public boolean isTypeVariable() {
        return true;
    }

    public TypeVariableBinding original() {
        if (this.declaringElement.kind() == 8) {
            MethodBinding originalMethod = ((MethodBinding)this.declaringElement).original();
            if (originalMethod != this.declaringElement) {
                return originalMethod.typeVariables[this.rank];
            }
        } else {
            ReferenceBinding originalType = (ReferenceBinding)((ReferenceBinding)this.declaringElement).erasure();
            if (originalType != this.declaringElement) {
                return originalType.typeVariables()[this.rank];
            }
        }
        return this;
    }

    public char[] readableName() {
        return this.sourceName;
    }

    ReferenceBinding resolve(LookupEnvironment environment) {
        int i2;
        ReferenceBinding[] interfaces;
        int length;
        if ((this.modifiers & 0x2000000) == 0) {
            return this;
        }
        ReferenceBinding oldSuperclass = this.superclass;
        ReferenceBinding oldFirstInterface = null;
        if (this.superclass != null) {
            this.superclass = BinaryTypeBinding.resolveUnresolvedType(this.superclass, environment, true);
        }
        if ((length = (interfaces = this.superInterfaces).length) != 0) {
            oldFirstInterface = interfaces[0];
            i2 = length;
            while (--i2 >= 0) {
                interfaces[i2] = BinaryTypeBinding.resolveUnresolvedType(interfaces[i2], environment, true);
            }
        }
        this.modifiers &= 0xFDFFFFFF;
        if (this.superclass != null) {
            this.superclass = BinaryTypeBinding.resolveType(this.superclass, environment, true);
        }
        i2 = interfaces.length;
        while (--i2 >= 0) {
            interfaces[i2] = BinaryTypeBinding.resolveType(interfaces[i2], environment, true);
        }
        if (this.firstBound != null) {
            if (this.firstBound == oldSuperclass) {
                this.firstBound = this.superclass;
            } else if (this.firstBound == oldFirstInterface) {
                this.firstBound = interfaces[0];
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        return this.readableName();
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append('<').append(this.sourceName);
        if (this.superclass != null && this.firstBound == this.superclass) {
            buffer.append(" extends ").append(this.superclass.debugName());
        }
        if (this.superInterfaces != null && this.superInterfaces != NoSuperInterfaces) {
            if (this.firstBound != this.superclass) {
                buffer.append(" extends ");
            }
            int i2 = 0;
            int length = this.superInterfaces.length;
            while (i2 < length) {
                if (i2 > 0 || this.firstBound == this.superclass) {
                    buffer.append(" & ");
                }
                buffer.append(this.superInterfaces[i2].debugName());
                ++i2;
            }
        }
        buffer.append('>');
        return buffer.toString();
    }

    public TypeBinding upperBound() {
        if (this.firstBound != null) {
            return this.firstBound;
        }
        return this.superclass;
    }
}

