/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.web.tomcat.security.HttpServletRequestCallback;
import org.jboss.web.tomcat.security.HttpServletRequestValve;

public class WebCallbackHandler
extends SecurityAssociationHandler
implements CallbackHandler {
    public WebCallbackHandler() {
    }

    public WebCallbackHandler(Principal principal, Object credential) {
        super(principal, credential);
    }

    public void setSecurityInfo(Principal principal, Object credential) {
        super.setSecurityInfo(principal, credential);
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        try {
            super.handle(callbacks);
        }
        catch (UnsupportedCallbackException uce) {
            Callback c = uce.getCallback();
            if (c instanceof HttpServletRequestCallback) {
                HttpServletRequest request = this.getHttpServletRequestFromValve();
                HttpServletRequestCallback hsrc = (HttpServletRequestCallback)c;
                hsrc.setHttpServletRequest(request);
            }
            throw new UnsupportedCallbackException(c, "Unrecognized Callback");
        }
    }

    protected HttpServletRequest getHttpServletRequestFromValve() {
        return (HttpServletRequest)HttpServletRequestValve.httpRequest.get();
    }
}

